/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum IndexEdition {
    DEVELOPER_EDITION("DEVELOPER_EDITION"),
    ENTERPRISE_EDITION("ENTERPRISE_EDITION"),
    GEN_AI_ENTERPRISE_EDITION("GEN_AI_ENTERPRISE_EDITION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, IndexEdition> VALUE_MAP;
    private final String value;

    private IndexEdition(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IndexEdition fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IndexEdition> knownValues() {
        EnumSet<IndexEdition> knownValues = EnumSet.allOf(IndexEdition.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(IndexEdition.class, IndexEdition::toString);
    }
}

