/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kendra.KendraClient;
import software.amazon.awssdk.services.kendra.internal.UserAgentUtils;
import software.amazon.awssdk.services.kendra.model.ListDataSourcesRequest;
import software.amazon.awssdk.services.kendra.model.ListDataSourcesResponse;

public class ListDataSourcesIterable
implements SdkIterable<ListDataSourcesResponse> {
    private final KendraClient client;
    private final ListDataSourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDataSourcesIterable(KendraClient client, ListDataSourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDataSourcesResponseFetcher();
    }

    public Iterator<ListDataSourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListDataSourcesResponseFetcher
    implements SyncPageFetcher<ListDataSourcesResponse> {
        private ListDataSourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListDataSourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDataSourcesResponse nextPage(ListDataSourcesResponse previousPage) {
            if (previousPage == null) {
                return ListDataSourcesIterable.this.client.listDataSources(ListDataSourcesIterable.this.firstRequest);
            }
            return ListDataSourcesIterable.this.client.listDataSources((ListDataSourcesRequest)((Object)ListDataSourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

