/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Persona {
    OWNER("OWNER"),
    VIEWER("VIEWER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Persona> VALUE_MAP;
    private final String value;

    private Persona(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Persona fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Persona> knownValues() {
        EnumSet<Persona> knownValues = EnumSet.allOf(Persona.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Persona.class, Persona::toString);
    }
}

