/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kendra.KendraAsyncClient;
import software.amazon.awssdk.services.kendra.internal.UserAgentUtils;
import software.amazon.awssdk.services.kendra.model.ListIndicesRequest;
import software.amazon.awssdk.services.kendra.model.ListIndicesResponse;

public class ListIndicesPublisher
implements SdkPublisher<ListIndicesResponse> {
    private final KendraAsyncClient client;
    private final ListIndicesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListIndicesPublisher(KendraAsyncClient client, ListIndicesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListIndicesPublisher(KendraAsyncClient client, ListIndicesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListIndicesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListIndicesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListIndicesResponseFetcher
    implements AsyncPageFetcher<ListIndicesResponse> {
        private ListIndicesResponseFetcher() {
        }

        public boolean hasNextPage(ListIndicesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListIndicesResponse> nextPage(ListIndicesResponse previousPage) {
            if (previousPage == null) {
                return ListIndicesPublisher.this.client.listIndices(ListIndicesPublisher.this.firstRequest);
            }
            return ListIndicesPublisher.this.client.listIndices((ListIndicesRequest)((Object)ListIndicesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

