/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kendra.KendraAsyncClient;
import software.amazon.awssdk.services.kendra.internal.UserAgentUtils;
import software.amazon.awssdk.services.kendra.model.ListDataSourceSyncJobsRequest;
import software.amazon.awssdk.services.kendra.model.ListDataSourceSyncJobsResponse;

public class ListDataSourceSyncJobsPublisher
implements SdkPublisher<ListDataSourceSyncJobsResponse> {
    private final KendraAsyncClient client;
    private final ListDataSourceSyncJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDataSourceSyncJobsPublisher(KendraAsyncClient client, ListDataSourceSyncJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDataSourceSyncJobsPublisher(KendraAsyncClient client, ListDataSourceSyncJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDataSourceSyncJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDataSourceSyncJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListDataSourceSyncJobsResponseFetcher
    implements AsyncPageFetcher<ListDataSourceSyncJobsResponse> {
        private ListDataSourceSyncJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListDataSourceSyncJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDataSourceSyncJobsResponse> nextPage(ListDataSourceSyncJobsResponse previousPage) {
            if (previousPage == null) {
                return ListDataSourceSyncJobsPublisher.this.client.listDataSourceSyncJobs(ListDataSourceSyncJobsPublisher.this.firstRequest);
            }
            return ListDataSourceSyncJobsPublisher.this.client.listDataSourceSyncJobs((ListDataSourceSyncJobsRequest)((Object)ListDataSourceSyncJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

