/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kendra.model.ContentSourceConfiguration;
import software.amazon.awssdk.services.kendra.model.UserIdentityConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExperienceConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExperienceConfiguration> {
    private static final SdkField<ContentSourceConfiguration> CONTENT_SOURCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ContentSourceConfiguration").getter(ExperienceConfiguration.getter(ExperienceConfiguration::contentSourceConfiguration)).setter(ExperienceConfiguration.setter(Builder::contentSourceConfiguration)).constructor(ContentSourceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentSourceConfiguration").build()}).build();
    private static final SdkField<UserIdentityConfiguration> USER_IDENTITY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UserIdentityConfiguration").getter(ExperienceConfiguration.getter(ExperienceConfiguration::userIdentityConfiguration)).setter(ExperienceConfiguration.setter(Builder::userIdentityConfiguration)).constructor(UserIdentityConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserIdentityConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_SOURCE_CONFIGURATION_FIELD, USER_IDENTITY_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ContentSourceConfiguration", CONTENT_SOURCE_CONFIGURATION_FIELD);
            this.put("UserIdentityConfiguration", USER_IDENTITY_CONFIGURATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final ContentSourceConfiguration contentSourceConfiguration;
    private final UserIdentityConfiguration userIdentityConfiguration;

    private ExperienceConfiguration(BuilderImpl builder) {
        this.contentSourceConfiguration = builder.contentSourceConfiguration;
        this.userIdentityConfiguration = builder.userIdentityConfiguration;
    }

    public final ContentSourceConfiguration contentSourceConfiguration() {
        return this.contentSourceConfiguration;
    }

    public final UserIdentityConfiguration userIdentityConfiguration() {
        return this.userIdentityConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.contentSourceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.userIdentityConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExperienceConfiguration)) {
            return false;
        }
        ExperienceConfiguration other = (ExperienceConfiguration)obj;
        return Objects.equals(this.contentSourceConfiguration(), other.contentSourceConfiguration()) && Objects.equals(this.userIdentityConfiguration(), other.userIdentityConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"ExperienceConfiguration").add("ContentSourceConfiguration", (Object)this.contentSourceConfiguration()).add("UserIdentityConfiguration", (Object)this.userIdentityConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContentSourceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.contentSourceConfiguration()));
            }
            case "UserIdentityConfiguration": {
                return Optional.ofNullable(clazz.cast(this.userIdentityConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ExperienceConfiguration, T> g) {
        return obj -> g.apply((ExperienceConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ContentSourceConfiguration contentSourceConfiguration;
        private UserIdentityConfiguration userIdentityConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ExperienceConfiguration model) {
            this.contentSourceConfiguration(model.contentSourceConfiguration);
            this.userIdentityConfiguration(model.userIdentityConfiguration);
        }

        public final ContentSourceConfiguration.Builder getContentSourceConfiguration() {
            return this.contentSourceConfiguration != null ? this.contentSourceConfiguration.toBuilder() : null;
        }

        public final void setContentSourceConfiguration(ContentSourceConfiguration.BuilderImpl contentSourceConfiguration) {
            this.contentSourceConfiguration = contentSourceConfiguration != null ? contentSourceConfiguration.build() : null;
        }

        @Override
        public final Builder contentSourceConfiguration(ContentSourceConfiguration contentSourceConfiguration) {
            this.contentSourceConfiguration = contentSourceConfiguration;
            return this;
        }

        public final UserIdentityConfiguration.Builder getUserIdentityConfiguration() {
            return this.userIdentityConfiguration != null ? this.userIdentityConfiguration.toBuilder() : null;
        }

        public final void setUserIdentityConfiguration(UserIdentityConfiguration.BuilderImpl userIdentityConfiguration) {
            this.userIdentityConfiguration = userIdentityConfiguration != null ? userIdentityConfiguration.build() : null;
        }

        @Override
        public final Builder userIdentityConfiguration(UserIdentityConfiguration userIdentityConfiguration) {
            this.userIdentityConfiguration = userIdentityConfiguration;
            return this;
        }

        public ExperienceConfiguration build() {
            return new ExperienceConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExperienceConfiguration> {
        public Builder contentSourceConfiguration(ContentSourceConfiguration var1);

        default public Builder contentSourceConfiguration(Consumer<ContentSourceConfiguration.Builder> contentSourceConfiguration) {
            return this.contentSourceConfiguration((ContentSourceConfiguration)((ContentSourceConfiguration.Builder)ContentSourceConfiguration.builder().applyMutation(contentSourceConfiguration)).build());
        }

        public Builder userIdentityConfiguration(UserIdentityConfiguration var1);

        default public Builder userIdentityConfiguration(Consumer<UserIdentityConfiguration.Builder> userIdentityConfiguration) {
            return this.userIdentityConfiguration((UserIdentityConfiguration)((UserIdentityConfiguration.Builder)UserIdentityConfiguration.builder().applyMutation(userIdentityConfiguration)).build());
        }
    }
}

