/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.EntityPersonaConfiguration;
import software.amazon.awssdk.services.kendra.model.EntityPersonaConfigurationListCopier;
import software.amazon.awssdk.services.kendra.model.KendraRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociatePersonasToEntitiesRequest
extends KendraRequest
implements ToCopyableBuilder<Builder, AssociatePersonasToEntitiesRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(AssociatePersonasToEntitiesRequest.getter(AssociatePersonasToEntitiesRequest::id)).setter(AssociatePersonasToEntitiesRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexId").getter(AssociatePersonasToEntitiesRequest.getter(AssociatePersonasToEntitiesRequest::indexId)).setter(AssociatePersonasToEntitiesRequest.setter(Builder::indexId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()}).build();
    private static final SdkField<List<EntityPersonaConfiguration>> PERSONAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Personas").getter(AssociatePersonasToEntitiesRequest.getter(AssociatePersonasToEntitiesRequest::personas)).setter(AssociatePersonasToEntitiesRequest.setter(Builder::personas)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Personas").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EntityPersonaConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, INDEX_ID_FIELD, PERSONAS_FIELD));
    private final String id;
    private final String indexId;
    private final List<EntityPersonaConfiguration> personas;

    private AssociatePersonasToEntitiesRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.indexId = builder.indexId;
        this.personas = builder.personas;
    }

    public final String id() {
        return this.id;
    }

    public final String indexId() {
        return this.indexId;
    }

    public final boolean hasPersonas() {
        return this.personas != null && !(this.personas instanceof SdkAutoConstructList);
    }

    public final List<EntityPersonaConfiguration> personas() {
        return this.personas;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPersonas() ? this.personas() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociatePersonasToEntitiesRequest)) {
            return false;
        }
        AssociatePersonasToEntitiesRequest other = (AssociatePersonasToEntitiesRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.indexId(), other.indexId()) && this.hasPersonas() == other.hasPersonas() && Objects.equals(this.personas(), other.personas());
    }

    public final String toString() {
        return ToString.builder((String)"AssociatePersonasToEntitiesRequest").add("Id", (Object)this.id()).add("IndexId", (Object)this.indexId()).add("Personas", this.hasPersonas() ? this.personas() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "IndexId": {
                return Optional.ofNullable(clazz.cast(this.indexId()));
            }
            case "Personas": {
                return Optional.ofNullable(clazz.cast(this.personas()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociatePersonasToEntitiesRequest, T> g) {
        return obj -> g.apply((AssociatePersonasToEntitiesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KendraRequest.BuilderImpl
    implements Builder {
        private String id;
        private String indexId;
        private List<EntityPersonaConfiguration> personas = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssociatePersonasToEntitiesRequest model) {
            super(model);
            this.id(model.id);
            this.indexId(model.indexId);
            this.personas(model.personas);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getIndexId() {
            return this.indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final List<EntityPersonaConfiguration.Builder> getPersonas() {
            List<EntityPersonaConfiguration.Builder> result = EntityPersonaConfigurationListCopier.copyToBuilder(this.personas);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPersonas(Collection<EntityPersonaConfiguration.BuilderImpl> personas) {
            this.personas = EntityPersonaConfigurationListCopier.copyFromBuilder(personas);
        }

        @Override
        public final Builder personas(Collection<EntityPersonaConfiguration> personas) {
            this.personas = EntityPersonaConfigurationListCopier.copy(personas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder personas(EntityPersonaConfiguration ... personas) {
            this.personas(Arrays.asList(personas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder personas(Consumer<EntityPersonaConfiguration.Builder> ... personas) {
            this.personas(Stream.of(personas).map(c -> (EntityPersonaConfiguration)((EntityPersonaConfiguration.Builder)EntityPersonaConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociatePersonasToEntitiesRequest build() {
            return new AssociatePersonasToEntitiesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KendraRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociatePersonasToEntitiesRequest> {
        public Builder id(String var1);

        public Builder indexId(String var1);

        public Builder personas(Collection<EntityPersonaConfiguration> var1);

        public Builder personas(EntityPersonaConfiguration ... var1);

        public Builder personas(Consumer<EntityPersonaConfiguration.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

