/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum KeyLocation {
    URL("URL"),
    SECRET_MANAGER("SECRET_MANAGER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, KeyLocation> VALUE_MAP;
    private final String value;

    private KeyLocation(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static KeyLocation fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<KeyLocation> knownValues() {
        EnumSet<KeyLocation> knownValues = EnumSet.allOf(KeyLocation.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(KeyLocation.class, KeyLocation::toString);
    }
}

