/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kendra.KendraAsyncClient;
import software.amazon.awssdk.services.kendra.internal.UserAgentUtils;
import software.amazon.awssdk.services.kendra.model.GetSnapshotsRequest;
import software.amazon.awssdk.services.kendra.model.GetSnapshotsResponse;

public class GetSnapshotsPublisher
implements SdkPublisher<GetSnapshotsResponse> {
    private final KendraAsyncClient client;
    private final GetSnapshotsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetSnapshotsPublisher(KendraAsyncClient client, GetSnapshotsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetSnapshotsPublisher(KendraAsyncClient client, GetSnapshotsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetSnapshotsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetSnapshotsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetSnapshotsResponseFetcher
    implements AsyncPageFetcher<GetSnapshotsResponse> {
        private GetSnapshotsResponseFetcher() {
        }

        public boolean hasNextPage(GetSnapshotsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetSnapshotsResponse> nextPage(GetSnapshotsResponse previousPage) {
            if (previousPage == null) {
                return GetSnapshotsPublisher.this.client.getSnapshots(GetSnapshotsPublisher.this.firstRequest);
            }
            return GetSnapshotsPublisher.this.client.getSnapshots((GetSnapshotsRequest)((Object)GetSnapshotsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

