/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.AttributeSuggestionsGetConfig;
import software.amazon.awssdk.services.kendra.model.KendraRequest;
import software.amazon.awssdk.services.kendra.model.SuggestionType;
import software.amazon.awssdk.services.kendra.model.SuggestionTypesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetQuerySuggestionsRequest
extends KendraRequest
implements ToCopyableBuilder<Builder, GetQuerySuggestionsRequest> {
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexId").getter(GetQuerySuggestionsRequest.getter(GetQuerySuggestionsRequest::indexId)).setter(GetQuerySuggestionsRequest.setter(Builder::indexId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()}).build();
    private static final SdkField<String> QUERY_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryText").getter(GetQuerySuggestionsRequest.getter(GetQuerySuggestionsRequest::queryText)).setter(GetQuerySuggestionsRequest.setter(Builder::queryText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryText").build()}).build();
    private static final SdkField<Integer> MAX_SUGGESTIONS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxSuggestionsCount").getter(GetQuerySuggestionsRequest.getter(GetQuerySuggestionsRequest::maxSuggestionsCount)).setter(GetQuerySuggestionsRequest.setter(Builder::maxSuggestionsCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSuggestionsCount").build()}).build();
    private static final SdkField<List<String>> SUGGESTION_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SuggestionTypes").getter(GetQuerySuggestionsRequest.getter(GetQuerySuggestionsRequest::suggestionTypesAsStrings)).setter(GetQuerySuggestionsRequest.setter(Builder::suggestionTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuggestionTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AttributeSuggestionsGetConfig> ATTRIBUTE_SUGGESTIONS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AttributeSuggestionsConfig").getter(GetQuerySuggestionsRequest.getter(GetQuerySuggestionsRequest::attributeSuggestionsConfig)).setter(GetQuerySuggestionsRequest.setter(Builder::attributeSuggestionsConfig)).constructor(AttributeSuggestionsGetConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeSuggestionsConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_ID_FIELD, QUERY_TEXT_FIELD, MAX_SUGGESTIONS_COUNT_FIELD, SUGGESTION_TYPES_FIELD, ATTRIBUTE_SUGGESTIONS_CONFIG_FIELD));
    private final String indexId;
    private final String queryText;
    private final Integer maxSuggestionsCount;
    private final List<String> suggestionTypes;
    private final AttributeSuggestionsGetConfig attributeSuggestionsConfig;

    private GetQuerySuggestionsRequest(BuilderImpl builder) {
        super(builder);
        this.indexId = builder.indexId;
        this.queryText = builder.queryText;
        this.maxSuggestionsCount = builder.maxSuggestionsCount;
        this.suggestionTypes = builder.suggestionTypes;
        this.attributeSuggestionsConfig = builder.attributeSuggestionsConfig;
    }

    public final String indexId() {
        return this.indexId;
    }

    public final String queryText() {
        return this.queryText;
    }

    public final Integer maxSuggestionsCount() {
        return this.maxSuggestionsCount;
    }

    public final List<SuggestionType> suggestionTypes() {
        return SuggestionTypesCopier.copyStringToEnum(this.suggestionTypes);
    }

    public final boolean hasSuggestionTypes() {
        return this.suggestionTypes != null && !(this.suggestionTypes instanceof SdkAutoConstructList);
    }

    public final List<String> suggestionTypesAsStrings() {
        return this.suggestionTypes;
    }

    public final AttributeSuggestionsGetConfig attributeSuggestionsConfig() {
        return this.attributeSuggestionsConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.indexId());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryText());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxSuggestionsCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuggestionTypes() ? this.suggestionTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeSuggestionsConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQuerySuggestionsRequest)) {
            return false;
        }
        GetQuerySuggestionsRequest other = (GetQuerySuggestionsRequest)((Object)obj);
        return Objects.equals(this.indexId(), other.indexId()) && Objects.equals(this.queryText(), other.queryText()) && Objects.equals(this.maxSuggestionsCount(), other.maxSuggestionsCount()) && this.hasSuggestionTypes() == other.hasSuggestionTypes() && Objects.equals(this.suggestionTypesAsStrings(), other.suggestionTypesAsStrings()) && Objects.equals(this.attributeSuggestionsConfig(), other.attributeSuggestionsConfig());
    }

    public final String toString() {
        return ToString.builder((String)"GetQuerySuggestionsRequest").add("IndexId", (Object)this.indexId()).add("QueryText", (Object)this.queryText()).add("MaxSuggestionsCount", (Object)this.maxSuggestionsCount()).add("SuggestionTypes", this.hasSuggestionTypes() ? this.suggestionTypesAsStrings() : null).add("AttributeSuggestionsConfig", (Object)this.attributeSuggestionsConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IndexId": {
                return Optional.ofNullable(clazz.cast(this.indexId()));
            }
            case "QueryText": {
                return Optional.ofNullable(clazz.cast(this.queryText()));
            }
            case "MaxSuggestionsCount": {
                return Optional.ofNullable(clazz.cast(this.maxSuggestionsCount()));
            }
            case "SuggestionTypes": {
                return Optional.ofNullable(clazz.cast(this.suggestionTypesAsStrings()));
            }
            case "AttributeSuggestionsConfig": {
                return Optional.ofNullable(clazz.cast(this.attributeSuggestionsConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetQuerySuggestionsRequest, T> g) {
        return obj -> g.apply((GetQuerySuggestionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KendraRequest.BuilderImpl
    implements Builder {
        private String indexId;
        private String queryText;
        private Integer maxSuggestionsCount;
        private List<String> suggestionTypes = DefaultSdkAutoConstructList.getInstance();
        private AttributeSuggestionsGetConfig attributeSuggestionsConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(GetQuerySuggestionsRequest model) {
            super(model);
            this.indexId(model.indexId);
            this.queryText(model.queryText);
            this.maxSuggestionsCount(model.maxSuggestionsCount);
            this.suggestionTypesWithStrings(model.suggestionTypes);
            this.attributeSuggestionsConfig(model.attributeSuggestionsConfig);
        }

        public final String getIndexId() {
            return this.indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final String getQueryText() {
            return this.queryText;
        }

        public final void setQueryText(String queryText) {
            this.queryText = queryText;
        }

        @Override
        public final Builder queryText(String queryText) {
            this.queryText = queryText;
            return this;
        }

        public final Integer getMaxSuggestionsCount() {
            return this.maxSuggestionsCount;
        }

        public final void setMaxSuggestionsCount(Integer maxSuggestionsCount) {
            this.maxSuggestionsCount = maxSuggestionsCount;
        }

        @Override
        public final Builder maxSuggestionsCount(Integer maxSuggestionsCount) {
            this.maxSuggestionsCount = maxSuggestionsCount;
            return this;
        }

        public final Collection<String> getSuggestionTypes() {
            if (this.suggestionTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.suggestionTypes;
        }

        public final void setSuggestionTypes(Collection<String> suggestionTypes) {
            this.suggestionTypes = SuggestionTypesCopier.copy(suggestionTypes);
        }

        @Override
        public final Builder suggestionTypesWithStrings(Collection<String> suggestionTypes) {
            this.suggestionTypes = SuggestionTypesCopier.copy(suggestionTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suggestionTypesWithStrings(String ... suggestionTypes) {
            this.suggestionTypesWithStrings(Arrays.asList(suggestionTypes));
            return this;
        }

        @Override
        public final Builder suggestionTypes(Collection<SuggestionType> suggestionTypes) {
            this.suggestionTypes = SuggestionTypesCopier.copyEnumToString(suggestionTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suggestionTypes(SuggestionType ... suggestionTypes) {
            this.suggestionTypes(Arrays.asList(suggestionTypes));
            return this;
        }

        public final AttributeSuggestionsGetConfig.Builder getAttributeSuggestionsConfig() {
            return this.attributeSuggestionsConfig != null ? this.attributeSuggestionsConfig.toBuilder() : null;
        }

        public final void setAttributeSuggestionsConfig(AttributeSuggestionsGetConfig.BuilderImpl attributeSuggestionsConfig) {
            this.attributeSuggestionsConfig = attributeSuggestionsConfig != null ? attributeSuggestionsConfig.build() : null;
        }

        @Override
        public final Builder attributeSuggestionsConfig(AttributeSuggestionsGetConfig attributeSuggestionsConfig) {
            this.attributeSuggestionsConfig = attributeSuggestionsConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetQuerySuggestionsRequest build() {
            return new GetQuerySuggestionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KendraRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetQuerySuggestionsRequest> {
        public Builder indexId(String var1);

        public Builder queryText(String var1);

        public Builder maxSuggestionsCount(Integer var1);

        public Builder suggestionTypesWithStrings(Collection<String> var1);

        public Builder suggestionTypesWithStrings(String ... var1);

        public Builder suggestionTypes(Collection<SuggestionType> var1);

        public Builder suggestionTypes(SuggestionType ... var1);

        public Builder attributeSuggestionsConfig(AttributeSuggestionsGetConfig var1);

        default public Builder attributeSuggestionsConfig(Consumer<AttributeSuggestionsGetConfig.Builder> attributeSuggestionsConfig) {
            return this.attributeSuggestionsConfig((AttributeSuggestionsGetConfig)((AttributeSuggestionsGetConfig.Builder)AttributeSuggestionsGetConfig.builder().applyMutation(attributeSuggestionsConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

