/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum IssueSubEntity {
    COMMENTS("COMMENTS"),
    ATTACHMENTS("ATTACHMENTS"),
    WORKLOGS("WORKLOGS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, IssueSubEntity> VALUE_MAP;
    private final String value;

    private IssueSubEntity(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IssueSubEntity fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IssueSubEntity> knownValues() {
        EnumSet<IssueSubEntity> knownValues = EnumSet.allOf(IssueSubEntity.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(IssueSubEntity.class, IssueSubEntity::toString);
    }
}

