/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.DataSourceIdListCopier;
import software.amazon.awssdk.services.kendra.model.FaqIdsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContentSourceConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContentSourceConfiguration> {
    private static final SdkField<List<String>> DATA_SOURCE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DataSourceIds").getter(ContentSourceConfiguration.getter(ContentSourceConfiguration::dataSourceIds)).setter(ContentSourceConfiguration.setter(Builder::dataSourceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> FAQ_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FaqIds").getter(ContentSourceConfiguration.getter(ContentSourceConfiguration::faqIds)).setter(ContentSourceConfiguration.setter(Builder::faqIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaqIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DIRECT_PUT_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DirectPutContent").getter(ContentSourceConfiguration.getter(ContentSourceConfiguration::directPutContent)).setter(ContentSourceConfiguration.setter(Builder::directPutContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectPutContent").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_IDS_FIELD, FAQ_IDS_FIELD, DIRECT_PUT_CONTENT_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> dataSourceIds;
    private final List<String> faqIds;
    private final Boolean directPutContent;

    private ContentSourceConfiguration(BuilderImpl builder) {
        this.dataSourceIds = builder.dataSourceIds;
        this.faqIds = builder.faqIds;
        this.directPutContent = builder.directPutContent;
    }

    public final boolean hasDataSourceIds() {
        return this.dataSourceIds != null && !(this.dataSourceIds instanceof SdkAutoConstructList);
    }

    public final List<String> dataSourceIds() {
        return this.dataSourceIds;
    }

    public final boolean hasFaqIds() {
        return this.faqIds != null && !(this.faqIds instanceof SdkAutoConstructList);
    }

    public final List<String> faqIds() {
        return this.faqIds;
    }

    public final Boolean directPutContent() {
        return this.directPutContent;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataSourceIds() ? this.dataSourceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFaqIds() ? this.faqIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.directPutContent());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContentSourceConfiguration)) {
            return false;
        }
        ContentSourceConfiguration other = (ContentSourceConfiguration)obj;
        return this.hasDataSourceIds() == other.hasDataSourceIds() && Objects.equals(this.dataSourceIds(), other.dataSourceIds()) && this.hasFaqIds() == other.hasFaqIds() && Objects.equals(this.faqIds(), other.faqIds()) && Objects.equals(this.directPutContent(), other.directPutContent());
    }

    public final String toString() {
        return ToString.builder((String)"ContentSourceConfiguration").add("DataSourceIds", this.hasDataSourceIds() ? this.dataSourceIds() : null).add("FaqIds", this.hasFaqIds() ? this.faqIds() : null).add("DirectPutContent", (Object)this.directPutContent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSourceIds": {
                return Optional.ofNullable(clazz.cast(this.dataSourceIds()));
            }
            case "FaqIds": {
                return Optional.ofNullable(clazz.cast(this.faqIds()));
            }
            case "DirectPutContent": {
                return Optional.ofNullable(clazz.cast(this.directPutContent()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContentSourceConfiguration, T> g) {
        return obj -> g.apply((ContentSourceConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> dataSourceIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> faqIds = DefaultSdkAutoConstructList.getInstance();
        private Boolean directPutContent;

        private BuilderImpl() {
        }

        private BuilderImpl(ContentSourceConfiguration model) {
            this.dataSourceIds(model.dataSourceIds);
            this.faqIds(model.faqIds);
            this.directPutContent(model.directPutContent);
        }

        public final Collection<String> getDataSourceIds() {
            if (this.dataSourceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dataSourceIds;
        }

        public final void setDataSourceIds(Collection<String> dataSourceIds) {
            this.dataSourceIds = DataSourceIdListCopier.copy(dataSourceIds);
        }

        @Override
        public final Builder dataSourceIds(Collection<String> dataSourceIds) {
            this.dataSourceIds = DataSourceIdListCopier.copy(dataSourceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSourceIds(String ... dataSourceIds) {
            this.dataSourceIds(Arrays.asList(dataSourceIds));
            return this;
        }

        public final Collection<String> getFaqIds() {
            if (this.faqIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.faqIds;
        }

        public final void setFaqIds(Collection<String> faqIds) {
            this.faqIds = FaqIdsListCopier.copy(faqIds);
        }

        @Override
        public final Builder faqIds(Collection<String> faqIds) {
            this.faqIds = FaqIdsListCopier.copy(faqIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faqIds(String ... faqIds) {
            this.faqIds(Arrays.asList(faqIds));
            return this;
        }

        public final Boolean getDirectPutContent() {
            return this.directPutContent;
        }

        public final void setDirectPutContent(Boolean directPutContent) {
            this.directPutContent = directPutContent;
        }

        @Override
        public final Builder directPutContent(Boolean directPutContent) {
            this.directPutContent = directPutContent;
            return this;
        }

        public ContentSourceConfiguration build() {
            return new ContentSourceConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContentSourceConfiguration> {
        public Builder dataSourceIds(Collection<String> var1);

        public Builder dataSourceIds(String ... var1);

        public Builder faqIds(Collection<String> var1);

        public Builder faqIds(String ... var1);

        public Builder directPutContent(Boolean var1);
    }
}

