/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.GroupSummary;
import software.amazon.awssdk.services.kendra.model.KendraResponse;
import software.amazon.awssdk.services.kendra.model.ListOfGroupSummariesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListGroupsOlderThanOrderingIdResponse
extends KendraResponse
implements ToCopyableBuilder<Builder, ListGroupsOlderThanOrderingIdResponse> {
    private static final SdkField<List<GroupSummary>> GROUPS_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GroupsSummaries").getter(ListGroupsOlderThanOrderingIdResponse.getter(ListGroupsOlderThanOrderingIdResponse::groupsSummaries)).setter(ListGroupsOlderThanOrderingIdResponse.setter(Builder::groupsSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupsSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GroupSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListGroupsOlderThanOrderingIdResponse.getter(ListGroupsOlderThanOrderingIdResponse::nextToken)).setter(ListGroupsOlderThanOrderingIdResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUPS_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<GroupSummary> groupsSummaries;
    private final String nextToken;

    private ListGroupsOlderThanOrderingIdResponse(BuilderImpl builder) {
        super(builder);
        this.groupsSummaries = builder.groupsSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasGroupsSummaries() {
        return this.groupsSummaries != null && !(this.groupsSummaries instanceof SdkAutoConstructList);
    }

    public final List<GroupSummary> groupsSummaries() {
        return this.groupsSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupsSummaries() ? this.groupsSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGroupsOlderThanOrderingIdResponse)) {
            return false;
        }
        ListGroupsOlderThanOrderingIdResponse other = (ListGroupsOlderThanOrderingIdResponse)((Object)obj);
        return this.hasGroupsSummaries() == other.hasGroupsSummaries() && Objects.equals(this.groupsSummaries(), other.groupsSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListGroupsOlderThanOrderingIdResponse").add("GroupsSummaries", this.hasGroupsSummaries() ? this.groupsSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupsSummaries": {
                return Optional.ofNullable(clazz.cast(this.groupsSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListGroupsOlderThanOrderingIdResponse, T> g) {
        return obj -> g.apply((ListGroupsOlderThanOrderingIdResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KendraResponse.BuilderImpl
    implements Builder {
        private List<GroupSummary> groupsSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGroupsOlderThanOrderingIdResponse model) {
            super(model);
            this.groupsSummaries(model.groupsSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<GroupSummary.Builder> getGroupsSummaries() {
            List<GroupSummary.Builder> result = ListOfGroupSummariesCopier.copyToBuilder(this.groupsSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupsSummaries(Collection<GroupSummary.BuilderImpl> groupsSummaries) {
            this.groupsSummaries = ListOfGroupSummariesCopier.copyFromBuilder(groupsSummaries);
        }

        @Override
        public final Builder groupsSummaries(Collection<GroupSummary> groupsSummaries) {
            this.groupsSummaries = ListOfGroupSummariesCopier.copy(groupsSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupsSummaries(GroupSummary ... groupsSummaries) {
            this.groupsSummaries(Arrays.asList(groupsSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupsSummaries(Consumer<GroupSummary.Builder> ... groupsSummaries) {
            this.groupsSummaries(Stream.of(groupsSummaries).map(c -> (GroupSummary)((GroupSummary.Builder)GroupSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListGroupsOlderThanOrderingIdResponse build() {
            return new ListGroupsOlderThanOrderingIdResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KendraResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListGroupsOlderThanOrderingIdResponse> {
        public Builder groupsSummaries(Collection<GroupSummary> var1);

        public Builder groupsSummaries(GroupSummary ... var1);

        public Builder groupsSummaries(Consumer<GroupSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

