/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kendra.KendraAsyncClient;
import software.amazon.awssdk.services.kendra.model.ListAccessControlConfigurationsRequest;
import software.amazon.awssdk.services.kendra.model.ListAccessControlConfigurationsResponse;

public class ListAccessControlConfigurationsPublisher
implements SdkPublisher<ListAccessControlConfigurationsResponse> {
    private final KendraAsyncClient client;
    private final ListAccessControlConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAccessControlConfigurationsPublisher(KendraAsyncClient client, ListAccessControlConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAccessControlConfigurationsPublisher(KendraAsyncClient client, ListAccessControlConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAccessControlConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAccessControlConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListAccessControlConfigurationsResponseFetcher
    implements AsyncPageFetcher<ListAccessControlConfigurationsResponse> {
        private ListAccessControlConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListAccessControlConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAccessControlConfigurationsResponse> nextPage(ListAccessControlConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListAccessControlConfigurationsPublisher.this.client.listAccessControlConfigurations(ListAccessControlConfigurationsPublisher.this.firstRequest);
            }
            return ListAccessControlConfigurationsPublisher.this.client.listAccessControlConfigurations((ListAccessControlConfigurationsRequest)((Object)ListAccessControlConfigurationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

