/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.DataSourceGroup;
import software.amazon.awssdk.services.kendra.model.DataSourceGroupsCopier;
import software.amazon.awssdk.services.kendra.model.GroupsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserContext
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UserContext> {
    private static final SdkField<String> TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Token").getter(UserContext.getter(UserContext::token)).setter(UserContext.setter(Builder::token)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Token").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserId").getter(UserContext.getter(UserContext::userId)).setter(UserContext.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()}).build();
    private static final SdkField<List<String>> GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Groups").getter(UserContext.getter(UserContext::groups)).setter(UserContext.setter(Builder::groups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Groups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DataSourceGroup>> DATA_SOURCE_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DataSourceGroups").getter(UserContext.getter(UserContext::dataSourceGroups)).setter(UserContext.setter(Builder::dataSourceGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSourceGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOKEN_FIELD, USER_ID_FIELD, GROUPS_FIELD, DATA_SOURCE_GROUPS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String token;
    private final String userId;
    private final List<String> groups;
    private final List<DataSourceGroup> dataSourceGroups;

    private UserContext(BuilderImpl builder) {
        this.token = builder.token;
        this.userId = builder.userId;
        this.groups = builder.groups;
        this.dataSourceGroups = builder.dataSourceGroups;
    }

    public final String token() {
        return this.token;
    }

    public final String userId() {
        return this.userId;
    }

    public final boolean hasGroups() {
        return this.groups != null && !(this.groups instanceof SdkAutoConstructList);
    }

    public final List<String> groups() {
        return this.groups;
    }

    public final boolean hasDataSourceGroups() {
        return this.dataSourceGroups != null && !(this.dataSourceGroups instanceof SdkAutoConstructList);
    }

    public final List<DataSourceGroup> dataSourceGroups() {
        return this.dataSourceGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.token());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroups() ? this.groups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataSourceGroups() ? this.dataSourceGroups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserContext)) {
            return false;
        }
        UserContext other = (UserContext)obj;
        return Objects.equals(this.token(), other.token()) && Objects.equals(this.userId(), other.userId()) && this.hasGroups() == other.hasGroups() && Objects.equals(this.groups(), other.groups()) && this.hasDataSourceGroups() == other.hasDataSourceGroups() && Objects.equals(this.dataSourceGroups(), other.dataSourceGroups());
    }

    public final String toString() {
        return ToString.builder((String)"UserContext").add("Token", (Object)this.token()).add("UserId", (Object)this.userId()).add("Groups", this.hasGroups() ? this.groups() : null).add("DataSourceGroups", this.hasDataSourceGroups() ? this.dataSourceGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Token": {
                return Optional.ofNullable(clazz.cast(this.token()));
            }
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "Groups": {
                return Optional.ofNullable(clazz.cast(this.groups()));
            }
            case "DataSourceGroups": {
                return Optional.ofNullable(clazz.cast(this.dataSourceGroups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserContext, T> g) {
        return obj -> g.apply((UserContext)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String token;
        private String userId;
        private List<String> groups = DefaultSdkAutoConstructList.getInstance();
        private List<DataSourceGroup> dataSourceGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UserContext model) {
            this.token(model.token);
            this.userId(model.userId);
            this.groups(model.groups);
            this.dataSourceGroups(model.dataSourceGroups);
        }

        public final String getToken() {
            return this.token;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        @Override
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final Collection<String> getGroups() {
            if (this.groups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.groups;
        }

        public final void setGroups(Collection<String> groups) {
            this.groups = GroupsCopier.copy(groups);
        }

        @Override
        public final Builder groups(Collection<String> groups) {
            this.groups = GroupsCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(String ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        public final List<DataSourceGroup.Builder> getDataSourceGroups() {
            List<DataSourceGroup.Builder> result = DataSourceGroupsCopier.copyToBuilder(this.dataSourceGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataSourceGroups(Collection<DataSourceGroup.BuilderImpl> dataSourceGroups) {
            this.dataSourceGroups = DataSourceGroupsCopier.copyFromBuilder(dataSourceGroups);
        }

        @Override
        public final Builder dataSourceGroups(Collection<DataSourceGroup> dataSourceGroups) {
            this.dataSourceGroups = DataSourceGroupsCopier.copy(dataSourceGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSourceGroups(DataSourceGroup ... dataSourceGroups) {
            this.dataSourceGroups(Arrays.asList(dataSourceGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSourceGroups(Consumer<DataSourceGroup.Builder> ... dataSourceGroups) {
            this.dataSourceGroups(Stream.of(dataSourceGroups).map(c -> (DataSourceGroup)((DataSourceGroup.Builder)DataSourceGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public UserContext build() {
            return new UserContext(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UserContext> {
        public Builder token(String var1);

        public Builder userId(String var1);

        public Builder groups(Collection<String> var1);

        public Builder groups(String ... var1);

        public Builder dataSourceGroups(Collection<DataSourceGroup> var1);

        public Builder dataSourceGroups(DataSourceGroup ... var1);

        public Builder dataSourceGroups(Consumer<DataSourceGroup.Builder> ... var1);
    }
}

