/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum HighlightType {
    STANDARD("STANDARD"),
    THESAURUS_SYNONYM("THESAURUS_SYNONYM"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private HighlightType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HighlightType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(HighlightType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HighlightType> knownValues() {
        return Stream.of(HighlightType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

