/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.KendraResponse;
import software.amazon.awssdk.services.kendra.model.QuerySuggestionsBlockListSummary;
import software.amazon.awssdk.services.kendra.model.QuerySuggestionsBlockListSummaryItemsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListQuerySuggestionsBlockListsResponse
extends KendraResponse
implements ToCopyableBuilder<Builder, ListQuerySuggestionsBlockListsResponse> {
    private static final SdkField<List<QuerySuggestionsBlockListSummary>> BLOCK_LIST_SUMMARY_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BlockListSummaryItems").getter(ListQuerySuggestionsBlockListsResponse.getter(ListQuerySuggestionsBlockListsResponse::blockListSummaryItems)).setter(ListQuerySuggestionsBlockListsResponse.setter(Builder::blockListSummaryItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockListSummaryItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(QuerySuggestionsBlockListSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListQuerySuggestionsBlockListsResponse.getter(ListQuerySuggestionsBlockListsResponse::nextToken)).setter(ListQuerySuggestionsBlockListsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCK_LIST_SUMMARY_ITEMS_FIELD, NEXT_TOKEN_FIELD));
    private final List<QuerySuggestionsBlockListSummary> blockListSummaryItems;
    private final String nextToken;

    private ListQuerySuggestionsBlockListsResponse(BuilderImpl builder) {
        super(builder);
        this.blockListSummaryItems = builder.blockListSummaryItems;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasBlockListSummaryItems() {
        return this.blockListSummaryItems != null && !(this.blockListSummaryItems instanceof SdkAutoConstructList);
    }

    public final List<QuerySuggestionsBlockListSummary> blockListSummaryItems() {
        return this.blockListSummaryItems;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBlockListSummaryItems() ? this.blockListSummaryItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQuerySuggestionsBlockListsResponse)) {
            return false;
        }
        ListQuerySuggestionsBlockListsResponse other = (ListQuerySuggestionsBlockListsResponse)((Object)obj);
        return this.hasBlockListSummaryItems() == other.hasBlockListSummaryItems() && Objects.equals(this.blockListSummaryItems(), other.blockListSummaryItems()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListQuerySuggestionsBlockListsResponse").add("BlockListSummaryItems", this.hasBlockListSummaryItems() ? this.blockListSummaryItems() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BlockListSummaryItems": {
                return Optional.ofNullable(clazz.cast(this.blockListSummaryItems()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListQuerySuggestionsBlockListsResponse, T> g) {
        return obj -> g.apply((ListQuerySuggestionsBlockListsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KendraResponse.BuilderImpl
    implements Builder {
        private List<QuerySuggestionsBlockListSummary> blockListSummaryItems = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListQuerySuggestionsBlockListsResponse model) {
            super(model);
            this.blockListSummaryItems(model.blockListSummaryItems);
            this.nextToken(model.nextToken);
        }

        public final List<QuerySuggestionsBlockListSummary.Builder> getBlockListSummaryItems() {
            List<QuerySuggestionsBlockListSummary.Builder> result = QuerySuggestionsBlockListSummaryItemsCopier.copyToBuilder(this.blockListSummaryItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder blockListSummaryItems(Collection<QuerySuggestionsBlockListSummary> blockListSummaryItems) {
            this.blockListSummaryItems = QuerySuggestionsBlockListSummaryItemsCopier.copy(blockListSummaryItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockListSummaryItems(QuerySuggestionsBlockListSummary ... blockListSummaryItems) {
            this.blockListSummaryItems(Arrays.asList(blockListSummaryItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockListSummaryItems(Consumer<QuerySuggestionsBlockListSummary.Builder> ... blockListSummaryItems) {
            this.blockListSummaryItems(Stream.of(blockListSummaryItems).map(c -> (QuerySuggestionsBlockListSummary)((QuerySuggestionsBlockListSummary.Builder)QuerySuggestionsBlockListSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBlockListSummaryItems(Collection<QuerySuggestionsBlockListSummary.BuilderImpl> blockListSummaryItems) {
            this.blockListSummaryItems = QuerySuggestionsBlockListSummaryItemsCopier.copyFromBuilder(blockListSummaryItems);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListQuerySuggestionsBlockListsResponse build() {
            return new ListQuerySuggestionsBlockListsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KendraResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListQuerySuggestionsBlockListsResponse> {
        public Builder blockListSummaryItems(Collection<QuerySuggestionsBlockListSummary> var1);

        public Builder blockListSummaryItems(QuerySuggestionsBlockListSummary ... var1);

        public Builder blockListSummaryItems(Consumer<QuerySuggestionsBlockListSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

