/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TextDocumentStatistics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TextDocumentStatistics> {
    private static final SdkField<Integer> INDEXED_TEXT_DOCUMENTS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("IndexedTextDocumentsCount").getter(TextDocumentStatistics.getter(TextDocumentStatistics::indexedTextDocumentsCount)).setter(TextDocumentStatistics.setter(Builder::indexedTextDocumentsCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexedTextDocumentsCount").build()}).build();
    private static final SdkField<Long> INDEXED_TEXT_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("IndexedTextBytes").getter(TextDocumentStatistics.getter(TextDocumentStatistics::indexedTextBytes)).setter(TextDocumentStatistics.setter(Builder::indexedTextBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexedTextBytes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEXED_TEXT_DOCUMENTS_COUNT_FIELD, INDEXED_TEXT_BYTES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer indexedTextDocumentsCount;
    private final Long indexedTextBytes;

    private TextDocumentStatistics(BuilderImpl builder) {
        this.indexedTextDocumentsCount = builder.indexedTextDocumentsCount;
        this.indexedTextBytes = builder.indexedTextBytes;
    }

    public final Integer indexedTextDocumentsCount() {
        return this.indexedTextDocumentsCount;
    }

    public final Long indexedTextBytes() {
        return this.indexedTextBytes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.indexedTextDocumentsCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexedTextBytes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextDocumentStatistics)) {
            return false;
        }
        TextDocumentStatistics other = (TextDocumentStatistics)obj;
        return Objects.equals(this.indexedTextDocumentsCount(), other.indexedTextDocumentsCount()) && Objects.equals(this.indexedTextBytes(), other.indexedTextBytes());
    }

    public final String toString() {
        return ToString.builder((String)"TextDocumentStatistics").add("IndexedTextDocumentsCount", (Object)this.indexedTextDocumentsCount()).add("IndexedTextBytes", (Object)this.indexedTextBytes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IndexedTextDocumentsCount": {
                return Optional.ofNullable(clazz.cast(this.indexedTextDocumentsCount()));
            }
            case "IndexedTextBytes": {
                return Optional.ofNullable(clazz.cast(this.indexedTextBytes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TextDocumentStatistics, T> g) {
        return obj -> g.apply((TextDocumentStatistics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer indexedTextDocumentsCount;
        private Long indexedTextBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(TextDocumentStatistics model) {
            this.indexedTextDocumentsCount(model.indexedTextDocumentsCount);
            this.indexedTextBytes(model.indexedTextBytes);
        }

        public final Integer getIndexedTextDocumentsCount() {
            return this.indexedTextDocumentsCount;
        }

        @Override
        public final Builder indexedTextDocumentsCount(Integer indexedTextDocumentsCount) {
            this.indexedTextDocumentsCount = indexedTextDocumentsCount;
            return this;
        }

        public final void setIndexedTextDocumentsCount(Integer indexedTextDocumentsCount) {
            this.indexedTextDocumentsCount = indexedTextDocumentsCount;
        }

        public final Long getIndexedTextBytes() {
            return this.indexedTextBytes;
        }

        @Override
        public final Builder indexedTextBytes(Long indexedTextBytes) {
            this.indexedTextBytes = indexedTextBytes;
            return this;
        }

        public final void setIndexedTextBytes(Long indexedTextBytes) {
            this.indexedTextBytes = indexedTextBytes;
        }

        public TextDocumentStatistics build() {
            return new TextDocumentStatistics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TextDocumentStatistics> {
        public Builder indexedTextDocumentsCount(Integer var1);

        public Builder indexedTextBytes(Long var1);
    }
}

