/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides configuration information for connecting to a Salesforce data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SalesforceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SalesforceConfiguration.Builder, SalesforceConfiguration> {
    private static final SdkField<String> SERVER_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerUrl").getter(getter(SalesforceConfiguration::serverUrl)).setter(setter(Builder::serverUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerUrl").build()).build();

    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretArn").getter(getter(SalesforceConfiguration::secretArn)).setter(setter(Builder::secretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()).build();

    private static final SdkField<List<SalesforceStandardObjectConfiguration>> STANDARD_OBJECT_CONFIGURATIONS_FIELD = SdkField
            .<List<SalesforceStandardObjectConfiguration>> builder(MarshallingType.LIST)
            .memberName("StandardObjectConfigurations")
            .getter(getter(SalesforceConfiguration::standardObjectConfigurations))
            .setter(setter(Builder::standardObjectConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardObjectConfigurations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SalesforceStandardObjectConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(SalesforceStandardObjectConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SalesforceKnowledgeArticleConfiguration> KNOWLEDGE_ARTICLE_CONFIGURATION_FIELD = SdkField
            .<SalesforceKnowledgeArticleConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("KnowledgeArticleConfiguration")
            .getter(getter(SalesforceConfiguration::knowledgeArticleConfiguration))
            .setter(setter(Builder::knowledgeArticleConfiguration))
            .constructor(SalesforceKnowledgeArticleConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KnowledgeArticleConfiguration")
                    .build()).build();

    private static final SdkField<SalesforceChatterFeedConfiguration> CHATTER_FEED_CONFIGURATION_FIELD = SdkField
            .<SalesforceChatterFeedConfiguration> builder(MarshallingType.SDK_POJO).memberName("ChatterFeedConfiguration")
            .getter(getter(SalesforceConfiguration::chatterFeedConfiguration)).setter(setter(Builder::chatterFeedConfiguration))
            .constructor(SalesforceChatterFeedConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChatterFeedConfiguration").build())
            .build();

    private static final SdkField<Boolean> CRAWL_ATTACHMENTS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CrawlAttachments").getter(getter(SalesforceConfiguration::crawlAttachments))
            .setter(setter(Builder::crawlAttachments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlAttachments").build()).build();

    private static final SdkField<SalesforceStandardObjectAttachmentConfiguration> STANDARD_OBJECT_ATTACHMENT_CONFIGURATION_FIELD = SdkField
            .<SalesforceStandardObjectAttachmentConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("StandardObjectAttachmentConfiguration")
            .getter(getter(SalesforceConfiguration::standardObjectAttachmentConfiguration))
            .setter(setter(Builder::standardObjectAttachmentConfiguration))
            .constructor(SalesforceStandardObjectAttachmentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("StandardObjectAttachmentConfiguration").build()).build();

    private static final SdkField<List<String>> INCLUDE_ATTACHMENT_FILE_PATTERNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("IncludeAttachmentFilePatterns")
            .getter(getter(SalesforceConfiguration::includeAttachmentFilePatterns))
            .setter(setter(Builder::includeAttachmentFilePatterns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeAttachmentFilePatterns")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EXCLUDE_ATTACHMENT_FILE_PATTERNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ExcludeAttachmentFilePatterns")
            .getter(getter(SalesforceConfiguration::excludeAttachmentFilePatterns))
            .setter(setter(Builder::excludeAttachmentFilePatterns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeAttachmentFilePatterns")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_URL_FIELD,
            SECRET_ARN_FIELD, STANDARD_OBJECT_CONFIGURATIONS_FIELD, KNOWLEDGE_ARTICLE_CONFIGURATION_FIELD,
            CHATTER_FEED_CONFIGURATION_FIELD, CRAWL_ATTACHMENTS_FIELD, STANDARD_OBJECT_ATTACHMENT_CONFIGURATION_FIELD,
            INCLUDE_ATTACHMENT_FILE_PATTERNS_FIELD, EXCLUDE_ATTACHMENT_FILE_PATTERNS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String serverUrl;

    private final String secretArn;

    private final List<SalesforceStandardObjectConfiguration> standardObjectConfigurations;

    private final SalesforceKnowledgeArticleConfiguration knowledgeArticleConfiguration;

    private final SalesforceChatterFeedConfiguration chatterFeedConfiguration;

    private final Boolean crawlAttachments;

    private final SalesforceStandardObjectAttachmentConfiguration standardObjectAttachmentConfiguration;

    private final List<String> includeAttachmentFilePatterns;

    private final List<String> excludeAttachmentFilePatterns;

    private SalesforceConfiguration(BuilderImpl builder) {
        this.serverUrl = builder.serverUrl;
        this.secretArn = builder.secretArn;
        this.standardObjectConfigurations = builder.standardObjectConfigurations;
        this.knowledgeArticleConfiguration = builder.knowledgeArticleConfiguration;
        this.chatterFeedConfiguration = builder.chatterFeedConfiguration;
        this.crawlAttachments = builder.crawlAttachments;
        this.standardObjectAttachmentConfiguration = builder.standardObjectAttachmentConfiguration;
        this.includeAttachmentFilePatterns = builder.includeAttachmentFilePatterns;
        this.excludeAttachmentFilePatterns = builder.excludeAttachmentFilePatterns;
    }

    /**
     * <p>
     * The instance URL for the Salesforce site that you want to index.
     * </p>
     * 
     * @return The instance URL for the Salesforce site that you want to index.
     */
    public final String serverUrl() {
        return serverUrl;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an AWS Secrets Manager secret that contains the key/value pairs required to
     * connect to your Salesforce instance. The secret must contain a JSON structure with the following keys:
     * </p>
     * <ul>
     * <li>
     * <p>
     * authenticationUrl - The OAUTH endpoint that Amazon Kendra connects to get an OAUTH token.
     * </p>
     * </li>
     * <li>
     * <p>
     * consumerKey - The application public key generated when you created your Salesforce application.
     * </p>
     * </li>
     * <li>
     * <p>
     * consumerSecret - The application private key generated when you created your Salesforce application.
     * </p>
     * </li>
     * <li>
     * <p>
     * password - The password associated with the user logging in to the Salesforce instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * securityToken - The token associated with the user account logging in to the Salesforce instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * username - The user name of the user logging in to the Salesforce instance.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The Amazon Resource Name (ARN) of an AWS Secrets Manager secret that contains the key/value pairs
     *         required to connect to your Salesforce instance. The secret must contain a JSON structure with the
     *         following keys:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         authenticationUrl - The OAUTH endpoint that Amazon Kendra connects to get an OAUTH token.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         consumerKey - The application public key generated when you created your Salesforce application.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         consumerSecret - The application private key generated when you created your Salesforce application.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         password - The password associated with the user logging in to the Salesforce instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         securityToken - The token associated with the user account logging in to the Salesforce instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         username - The user name of the user logging in to the Salesforce instance.
     *         </p>
     *         </li>
     */
    public final String secretArn() {
        return secretArn;
    }

    /**
     * Returns true if the StandardObjectConfigurations property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasStandardObjectConfigurations() {
        return standardObjectConfigurations != null && !(standardObjectConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the Salesforce standard objects that Amazon Kendra indexes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStandardObjectConfigurations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies the Salesforce standard objects that Amazon Kendra indexes.
     */
    public final List<SalesforceStandardObjectConfiguration> standardObjectConfigurations() {
        return standardObjectConfigurations;
    }

    /**
     * <p>
     * Specifies configuration information for the knowlege article types that Amazon Kendra indexes. Amazon Kendra
     * indexes standard knowledge articles and the standard fields of knowledge articles, or the custom fields of custom
     * knowledge articles, but not both.
     * </p>
     * 
     * @return Specifies configuration information for the knowlege article types that Amazon Kendra indexes. Amazon
     *         Kendra indexes standard knowledge articles and the standard fields of knowledge articles, or the custom
     *         fields of custom knowledge articles, but not both.
     */
    public final SalesforceKnowledgeArticleConfiguration knowledgeArticleConfiguration() {
        return knowledgeArticleConfiguration;
    }

    /**
     * <p>
     * Specifies configuration information for Salesforce chatter feeds.
     * </p>
     * 
     * @return Specifies configuration information for Salesforce chatter feeds.
     */
    public final SalesforceChatterFeedConfiguration chatterFeedConfiguration() {
        return chatterFeedConfiguration;
    }

    /**
     * <p>
     * Indicates whether Amazon Kendra should index attachments to Salesforce objects.
     * </p>
     * 
     * @return Indicates whether Amazon Kendra should index attachments to Salesforce objects.
     */
    public final Boolean crawlAttachments() {
        return crawlAttachments;
    }

    /**
     * <p>
     * Provides configuration information for processing attachments to Salesforce standard objects.
     * </p>
     * 
     * @return Provides configuration information for processing attachments to Salesforce standard objects.
     */
    public final SalesforceStandardObjectAttachmentConfiguration standardObjectAttachmentConfiguration() {
        return standardObjectAttachmentConfiguration;
    }

    /**
     * Returns true if the IncludeAttachmentFilePatterns property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public final boolean hasIncludeAttachmentFilePatterns() {
        return includeAttachmentFilePatterns != null && !(includeAttachmentFilePatterns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of regular expression patterns. Documents that match the patterns are included in the index. Documents
     * that don't match the patterns are excluded from the index. If a document matches both an inclusion pattern and an
     * exclusion pattern, the document is not included in the index.
     * </p>
     * <p>
     * The regex is applied to the name of the attached file.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIncludeAttachmentFilePatterns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of regular expression patterns. Documents that match the patterns are included in the index.
     *         Documents that don't match the patterns are excluded from the index. If a document matches both an
     *         inclusion pattern and an exclusion pattern, the document is not included in the index.</p>
     *         <p>
     *         The regex is applied to the name of the attached file.
     */
    public final List<String> includeAttachmentFilePatterns() {
        return includeAttachmentFilePatterns;
    }

    /**
     * Returns true if the ExcludeAttachmentFilePatterns property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public final boolean hasExcludeAttachmentFilePatterns() {
        return excludeAttachmentFilePatterns != null && !(excludeAttachmentFilePatterns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of regular expression patterns. Documents that match the patterns are excluded from the index. Documents
     * that don't match the patterns are included in the index. If a document matches both an exclusion pattern and an
     * inclusion pattern, the document is not included in the index.
     * </p>
     * <p>
     * The regex is applied to the name of the attached file.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExcludeAttachmentFilePatterns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of regular expression patterns. Documents that match the patterns are excluded from the index.
     *         Documents that don't match the patterns are included in the index. If a document matches both an
     *         exclusion pattern and an inclusion pattern, the document is not included in the index.</p>
     *         <p>
     *         The regex is applied to the name of the attached file.
     */
    public final List<String> excludeAttachmentFilePatterns() {
        return excludeAttachmentFilePatterns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serverUrl());
        hashCode = 31 * hashCode + Objects.hashCode(secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasStandardObjectConfigurations() ? standardObjectConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeArticleConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(chatterFeedConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(crawlAttachments());
        hashCode = 31 * hashCode + Objects.hashCode(standardObjectAttachmentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasIncludeAttachmentFilePatterns() ? includeAttachmentFilePatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExcludeAttachmentFilePatterns() ? excludeAttachmentFilePatterns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SalesforceConfiguration)) {
            return false;
        }
        SalesforceConfiguration other = (SalesforceConfiguration) obj;
        return Objects.equals(serverUrl(), other.serverUrl()) && Objects.equals(secretArn(), other.secretArn())
                && hasStandardObjectConfigurations() == other.hasStandardObjectConfigurations()
                && Objects.equals(standardObjectConfigurations(), other.standardObjectConfigurations())
                && Objects.equals(knowledgeArticleConfiguration(), other.knowledgeArticleConfiguration())
                && Objects.equals(chatterFeedConfiguration(), other.chatterFeedConfiguration())
                && Objects.equals(crawlAttachments(), other.crawlAttachments())
                && Objects.equals(standardObjectAttachmentConfiguration(), other.standardObjectAttachmentConfiguration())
                && hasIncludeAttachmentFilePatterns() == other.hasIncludeAttachmentFilePatterns()
                && Objects.equals(includeAttachmentFilePatterns(), other.includeAttachmentFilePatterns())
                && hasExcludeAttachmentFilePatterns() == other.hasExcludeAttachmentFilePatterns()
                && Objects.equals(excludeAttachmentFilePatterns(), other.excludeAttachmentFilePatterns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("SalesforceConfiguration")
                .add("ServerUrl", serverUrl())
                .add("SecretArn", secretArn())
                .add("StandardObjectConfigurations", hasStandardObjectConfigurations() ? standardObjectConfigurations() : null)
                .add("KnowledgeArticleConfiguration", knowledgeArticleConfiguration())
                .add("ChatterFeedConfiguration", chatterFeedConfiguration())
                .add("CrawlAttachments", crawlAttachments())
                .add("StandardObjectAttachmentConfiguration", standardObjectAttachmentConfiguration())
                .add("IncludeAttachmentFilePatterns", hasIncludeAttachmentFilePatterns() ? includeAttachmentFilePatterns() : null)
                .add("ExcludeAttachmentFilePatterns", hasExcludeAttachmentFilePatterns() ? excludeAttachmentFilePatterns() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServerUrl":
            return Optional.ofNullable(clazz.cast(serverUrl()));
        case "SecretArn":
            return Optional.ofNullable(clazz.cast(secretArn()));
        case "StandardObjectConfigurations":
            return Optional.ofNullable(clazz.cast(standardObjectConfigurations()));
        case "KnowledgeArticleConfiguration":
            return Optional.ofNullable(clazz.cast(knowledgeArticleConfiguration()));
        case "ChatterFeedConfiguration":
            return Optional.ofNullable(clazz.cast(chatterFeedConfiguration()));
        case "CrawlAttachments":
            return Optional.ofNullable(clazz.cast(crawlAttachments()));
        case "StandardObjectAttachmentConfiguration":
            return Optional.ofNullable(clazz.cast(standardObjectAttachmentConfiguration()));
        case "IncludeAttachmentFilePatterns":
            return Optional.ofNullable(clazz.cast(includeAttachmentFilePatterns()));
        case "ExcludeAttachmentFilePatterns":
            return Optional.ofNullable(clazz.cast(excludeAttachmentFilePatterns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SalesforceConfiguration, T> g) {
        return obj -> g.apply((SalesforceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SalesforceConfiguration> {
        /**
         * <p>
         * The instance URL for the Salesforce site that you want to index.
         * </p>
         * 
         * @param serverUrl
         *        The instance URL for the Salesforce site that you want to index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverUrl(String serverUrl);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an AWS Secrets Manager secret that contains the key/value pairs required to
         * connect to your Salesforce instance. The secret must contain a JSON structure with the following keys:
         * </p>
         * <ul>
         * <li>
         * <p>
         * authenticationUrl - The OAUTH endpoint that Amazon Kendra connects to get an OAUTH token.
         * </p>
         * </li>
         * <li>
         * <p>
         * consumerKey - The application public key generated when you created your Salesforce application.
         * </p>
         * </li>
         * <li>
         * <p>
         * consumerSecret - The application private key generated when you created your Salesforce application.
         * </p>
         * </li>
         * <li>
         * <p>
         * password - The password associated with the user logging in to the Salesforce instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * securityToken - The token associated with the user account logging in to the Salesforce instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * username - The user name of the user logging in to the Salesforce instance.
         * </p>
         * </li>
         * </ul>
         * 
         * @param secretArn
         *        The Amazon Resource Name (ARN) of an AWS Secrets Manager secret that contains the key/value pairs
         *        required to connect to your Salesforce instance. The secret must contain a JSON structure with the
         *        following keys:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        authenticationUrl - The OAUTH endpoint that Amazon Kendra connects to get an OAUTH token.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        consumerKey - The application public key generated when you created your Salesforce application.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        consumerSecret - The application private key generated when you created your Salesforce application.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        password - The password associated with the user logging in to the Salesforce instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        securityToken - The token associated with the user account logging in to the Salesforce instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        username - The user name of the user logging in to the Salesforce instance.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArn(String secretArn);

        /**
         * <p>
         * Specifies the Salesforce standard objects that Amazon Kendra indexes.
         * </p>
         * 
         * @param standardObjectConfigurations
         *        Specifies the Salesforce standard objects that Amazon Kendra indexes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardObjectConfigurations(Collection<SalesforceStandardObjectConfiguration> standardObjectConfigurations);

        /**
         * <p>
         * Specifies the Salesforce standard objects that Amazon Kendra indexes.
         * </p>
         * 
         * @param standardObjectConfigurations
         *        Specifies the Salesforce standard objects that Amazon Kendra indexes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardObjectConfigurations(SalesforceStandardObjectConfiguration... standardObjectConfigurations);

        /**
         * <p>
         * Specifies the Salesforce standard objects that Amazon Kendra indexes.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <SalesforceStandardObjectConfiguration>.Builder} avoiding the need to create one manually via {@link List
         * <SalesforceStandardObjectConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SalesforceStandardObjectConfiguration>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #standardObjectConfigurations(List<SalesforceStandardObjectConfiguration>)}.
         * 
         * @param standardObjectConfigurations
         *        a consumer that will call methods on {@link List<SalesforceStandardObjectConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #standardObjectConfigurations(List<SalesforceStandardObjectConfiguration>)
         */
        Builder standardObjectConfigurations(
                Consumer<SalesforceStandardObjectConfiguration.Builder>... standardObjectConfigurations);

        /**
         * <p>
         * Specifies configuration information for the knowlege article types that Amazon Kendra indexes. Amazon Kendra
         * indexes standard knowledge articles and the standard fields of knowledge articles, or the custom fields of
         * custom knowledge articles, but not both.
         * </p>
         * 
         * @param knowledgeArticleConfiguration
         *        Specifies configuration information for the knowlege article types that Amazon Kendra indexes. Amazon
         *        Kendra indexes standard knowledge articles and the standard fields of knowledge articles, or the
         *        custom fields of custom knowledge articles, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeArticleConfiguration(SalesforceKnowledgeArticleConfiguration knowledgeArticleConfiguration);

        /**
         * <p>
         * Specifies configuration information for the knowlege article types that Amazon Kendra indexes. Amazon Kendra
         * indexes standard knowledge articles and the standard fields of knowledge articles, or the custom fields of
         * custom knowledge articles, but not both.
         * </p>
         * This is a convenience that creates an instance of the {@link SalesforceKnowledgeArticleConfiguration.Builder}
         * avoiding the need to create one manually via {@link SalesforceKnowledgeArticleConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link SalesforceKnowledgeArticleConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #knowledgeArticleConfiguration(SalesforceKnowledgeArticleConfiguration)}.
         * 
         * @param knowledgeArticleConfiguration
         *        a consumer that will call methods on {@link SalesforceKnowledgeArticleConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #knowledgeArticleConfiguration(SalesforceKnowledgeArticleConfiguration)
         */
        default Builder knowledgeArticleConfiguration(
                Consumer<SalesforceKnowledgeArticleConfiguration.Builder> knowledgeArticleConfiguration) {
            return knowledgeArticleConfiguration(SalesforceKnowledgeArticleConfiguration.builder()
                    .applyMutation(knowledgeArticleConfiguration).build());
        }

        /**
         * <p>
         * Specifies configuration information for Salesforce chatter feeds.
         * </p>
         * 
         * @param chatterFeedConfiguration
         *        Specifies configuration information for Salesforce chatter feeds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chatterFeedConfiguration(SalesforceChatterFeedConfiguration chatterFeedConfiguration);

        /**
         * <p>
         * Specifies configuration information for Salesforce chatter feeds.
         * </p>
         * This is a convenience that creates an instance of the {@link SalesforceChatterFeedConfiguration.Builder}
         * avoiding the need to create one manually via {@link SalesforceChatterFeedConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link SalesforceChatterFeedConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #chatterFeedConfiguration(SalesforceChatterFeedConfiguration)}
         * .
         * 
         * @param chatterFeedConfiguration
         *        a consumer that will call methods on {@link SalesforceChatterFeedConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #chatterFeedConfiguration(SalesforceChatterFeedConfiguration)
         */
        default Builder chatterFeedConfiguration(Consumer<SalesforceChatterFeedConfiguration.Builder> chatterFeedConfiguration) {
            return chatterFeedConfiguration(SalesforceChatterFeedConfiguration.builder().applyMutation(chatterFeedConfiguration)
                    .build());
        }

        /**
         * <p>
         * Indicates whether Amazon Kendra should index attachments to Salesforce objects.
         * </p>
         * 
         * @param crawlAttachments
         *        Indicates whether Amazon Kendra should index attachments to Salesforce objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crawlAttachments(Boolean crawlAttachments);

        /**
         * <p>
         * Provides configuration information for processing attachments to Salesforce standard objects.
         * </p>
         * 
         * @param standardObjectAttachmentConfiguration
         *        Provides configuration information for processing attachments to Salesforce standard objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardObjectAttachmentConfiguration(
                SalesforceStandardObjectAttachmentConfiguration standardObjectAttachmentConfiguration);

        /**
         * <p>
         * Provides configuration information for processing attachments to Salesforce standard objects.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link SalesforceStandardObjectAttachmentConfiguration.Builder} avoiding the need to create one manually via
         * {@link SalesforceStandardObjectAttachmentConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link SalesforceStandardObjectAttachmentConfiguration.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #standardObjectAttachmentConfiguration(SalesforceStandardObjectAttachmentConfiguration)}.
         * 
         * @param standardObjectAttachmentConfiguration
         *        a consumer that will call methods on {@link SalesforceStandardObjectAttachmentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #standardObjectAttachmentConfiguration(SalesforceStandardObjectAttachmentConfiguration)
         */
        default Builder standardObjectAttachmentConfiguration(
                Consumer<SalesforceStandardObjectAttachmentConfiguration.Builder> standardObjectAttachmentConfiguration) {
            return standardObjectAttachmentConfiguration(SalesforceStandardObjectAttachmentConfiguration.builder()
                    .applyMutation(standardObjectAttachmentConfiguration).build());
        }

        /**
         * <p>
         * A list of regular expression patterns. Documents that match the patterns are included in the index. Documents
         * that don't match the patterns are excluded from the index. If a document matches both an inclusion pattern
         * and an exclusion pattern, the document is not included in the index.
         * </p>
         * <p>
         * The regex is applied to the name of the attached file.
         * </p>
         * 
         * @param includeAttachmentFilePatterns
         *        A list of regular expression patterns. Documents that match the patterns are included in the index.
         *        Documents that don't match the patterns are excluded from the index. If a document matches both an
         *        inclusion pattern and an exclusion pattern, the document is not included in the index.</p>
         *        <p>
         *        The regex is applied to the name of the attached file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeAttachmentFilePatterns(Collection<String> includeAttachmentFilePatterns);

        /**
         * <p>
         * A list of regular expression patterns. Documents that match the patterns are included in the index. Documents
         * that don't match the patterns are excluded from the index. If a document matches both an inclusion pattern
         * and an exclusion pattern, the document is not included in the index.
         * </p>
         * <p>
         * The regex is applied to the name of the attached file.
         * </p>
         * 
         * @param includeAttachmentFilePatterns
         *        A list of regular expression patterns. Documents that match the patterns are included in the index.
         *        Documents that don't match the patterns are excluded from the index. If a document matches both an
         *        inclusion pattern and an exclusion pattern, the document is not included in the index.</p>
         *        <p>
         *        The regex is applied to the name of the attached file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeAttachmentFilePatterns(String... includeAttachmentFilePatterns);

        /**
         * <p>
         * A list of regular expression patterns. Documents that match the patterns are excluded from the index.
         * Documents that don't match the patterns are included in the index. If a document matches both an exclusion
         * pattern and an inclusion pattern, the document is not included in the index.
         * </p>
         * <p>
         * The regex is applied to the name of the attached file.
         * </p>
         * 
         * @param excludeAttachmentFilePatterns
         *        A list of regular expression patterns. Documents that match the patterns are excluded from the index.
         *        Documents that don't match the patterns are included in the index. If a document matches both an
         *        exclusion pattern and an inclusion pattern, the document is not included in the index.</p>
         *        <p>
         *        The regex is applied to the name of the attached file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeAttachmentFilePatterns(Collection<String> excludeAttachmentFilePatterns);

        /**
         * <p>
         * A list of regular expression patterns. Documents that match the patterns are excluded from the index.
         * Documents that don't match the patterns are included in the index. If a document matches both an exclusion
         * pattern and an inclusion pattern, the document is not included in the index.
         * </p>
         * <p>
         * The regex is applied to the name of the attached file.
         * </p>
         * 
         * @param excludeAttachmentFilePatterns
         *        A list of regular expression patterns. Documents that match the patterns are excluded from the index.
         *        Documents that don't match the patterns are included in the index. If a document matches both an
         *        exclusion pattern and an inclusion pattern, the document is not included in the index.</p>
         *        <p>
         *        The regex is applied to the name of the attached file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeAttachmentFilePatterns(String... excludeAttachmentFilePatterns);
    }

    static final class BuilderImpl implements Builder {
        private String serverUrl;

        private String secretArn;

        private List<SalesforceStandardObjectConfiguration> standardObjectConfigurations = DefaultSdkAutoConstructList
                .getInstance();

        private SalesforceKnowledgeArticleConfiguration knowledgeArticleConfiguration;

        private SalesforceChatterFeedConfiguration chatterFeedConfiguration;

        private Boolean crawlAttachments;

        private SalesforceStandardObjectAttachmentConfiguration standardObjectAttachmentConfiguration;

        private List<String> includeAttachmentFilePatterns = DefaultSdkAutoConstructList.getInstance();

        private List<String> excludeAttachmentFilePatterns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SalesforceConfiguration model) {
            serverUrl(model.serverUrl);
            secretArn(model.secretArn);
            standardObjectConfigurations(model.standardObjectConfigurations);
            knowledgeArticleConfiguration(model.knowledgeArticleConfiguration);
            chatterFeedConfiguration(model.chatterFeedConfiguration);
            crawlAttachments(model.crawlAttachments);
            standardObjectAttachmentConfiguration(model.standardObjectAttachmentConfiguration);
            includeAttachmentFilePatterns(model.includeAttachmentFilePatterns);
            excludeAttachmentFilePatterns(model.excludeAttachmentFilePatterns);
        }

        public final String getServerUrl() {
            return serverUrl;
        }

        @Override
        public final Builder serverUrl(String serverUrl) {
            this.serverUrl = serverUrl;
            return this;
        }

        public final void setServerUrl(String serverUrl) {
            this.serverUrl = serverUrl;
        }

        public final String getSecretArn() {
            return secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        public final Collection<SalesforceStandardObjectConfiguration.Builder> getStandardObjectConfigurations() {
            if (standardObjectConfigurations instanceof SdkAutoConstructList) {
                return null;
            }
            return standardObjectConfigurations != null ? standardObjectConfigurations.stream()
                    .map(SalesforceStandardObjectConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder standardObjectConfigurations(
                Collection<SalesforceStandardObjectConfiguration> standardObjectConfigurations) {
            this.standardObjectConfigurations = SalesforceStandardObjectConfigurationListCopier
                    .copy(standardObjectConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder standardObjectConfigurations(SalesforceStandardObjectConfiguration... standardObjectConfigurations) {
            standardObjectConfigurations(Arrays.asList(standardObjectConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder standardObjectConfigurations(
                Consumer<SalesforceStandardObjectConfiguration.Builder>... standardObjectConfigurations) {
            standardObjectConfigurations(Stream.of(standardObjectConfigurations)
                    .map(c -> SalesforceStandardObjectConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setStandardObjectConfigurations(
                Collection<SalesforceStandardObjectConfiguration.BuilderImpl> standardObjectConfigurations) {
            this.standardObjectConfigurations = SalesforceStandardObjectConfigurationListCopier
                    .copyFromBuilder(standardObjectConfigurations);
        }

        public final SalesforceKnowledgeArticleConfiguration.Builder getKnowledgeArticleConfiguration() {
            return knowledgeArticleConfiguration != null ? knowledgeArticleConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder knowledgeArticleConfiguration(SalesforceKnowledgeArticleConfiguration knowledgeArticleConfiguration) {
            this.knowledgeArticleConfiguration = knowledgeArticleConfiguration;
            return this;
        }

        public final void setKnowledgeArticleConfiguration(
                SalesforceKnowledgeArticleConfiguration.BuilderImpl knowledgeArticleConfiguration) {
            this.knowledgeArticleConfiguration = knowledgeArticleConfiguration != null ? knowledgeArticleConfiguration.build()
                    : null;
        }

        public final SalesforceChatterFeedConfiguration.Builder getChatterFeedConfiguration() {
            return chatterFeedConfiguration != null ? chatterFeedConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder chatterFeedConfiguration(SalesforceChatterFeedConfiguration chatterFeedConfiguration) {
            this.chatterFeedConfiguration = chatterFeedConfiguration;
            return this;
        }

        public final void setChatterFeedConfiguration(SalesforceChatterFeedConfiguration.BuilderImpl chatterFeedConfiguration) {
            this.chatterFeedConfiguration = chatterFeedConfiguration != null ? chatterFeedConfiguration.build() : null;
        }

        public final Boolean getCrawlAttachments() {
            return crawlAttachments;
        }

        @Override
        public final Builder crawlAttachments(Boolean crawlAttachments) {
            this.crawlAttachments = crawlAttachments;
            return this;
        }

        public final void setCrawlAttachments(Boolean crawlAttachments) {
            this.crawlAttachments = crawlAttachments;
        }

        public final SalesforceStandardObjectAttachmentConfiguration.Builder getStandardObjectAttachmentConfiguration() {
            return standardObjectAttachmentConfiguration != null ? standardObjectAttachmentConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder standardObjectAttachmentConfiguration(
                SalesforceStandardObjectAttachmentConfiguration standardObjectAttachmentConfiguration) {
            this.standardObjectAttachmentConfiguration = standardObjectAttachmentConfiguration;
            return this;
        }

        public final void setStandardObjectAttachmentConfiguration(
                SalesforceStandardObjectAttachmentConfiguration.BuilderImpl standardObjectAttachmentConfiguration) {
            this.standardObjectAttachmentConfiguration = standardObjectAttachmentConfiguration != null ? standardObjectAttachmentConfiguration
                    .build() : null;
        }

        public final Collection<String> getIncludeAttachmentFilePatterns() {
            if (includeAttachmentFilePatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return includeAttachmentFilePatterns;
        }

        @Override
        public final Builder includeAttachmentFilePatterns(Collection<String> includeAttachmentFilePatterns) {
            this.includeAttachmentFilePatterns = DataSourceInclusionsExclusionsStringsCopier.copy(includeAttachmentFilePatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeAttachmentFilePatterns(String... includeAttachmentFilePatterns) {
            includeAttachmentFilePatterns(Arrays.asList(includeAttachmentFilePatterns));
            return this;
        }

        public final void setIncludeAttachmentFilePatterns(Collection<String> includeAttachmentFilePatterns) {
            this.includeAttachmentFilePatterns = DataSourceInclusionsExclusionsStringsCopier.copy(includeAttachmentFilePatterns);
        }

        public final Collection<String> getExcludeAttachmentFilePatterns() {
            if (excludeAttachmentFilePatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return excludeAttachmentFilePatterns;
        }

        @Override
        public final Builder excludeAttachmentFilePatterns(Collection<String> excludeAttachmentFilePatterns) {
            this.excludeAttachmentFilePatterns = DataSourceInclusionsExclusionsStringsCopier.copy(excludeAttachmentFilePatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeAttachmentFilePatterns(String... excludeAttachmentFilePatterns) {
            excludeAttachmentFilePatterns(Arrays.asList(excludeAttachmentFilePatterns));
            return this;
        }

        public final void setExcludeAttachmentFilePatterns(Collection<String> excludeAttachmentFilePatterns) {
            this.excludeAttachmentFilePatterns = DataSourceInclusionsExclusionsStringsCopier.copy(excludeAttachmentFilePatterns);
        }

        @Override
        public SalesforceConfiguration build() {
            return new SalesforceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
