/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides feedback on how relevant a document is to a search. Your application uses the <a>SubmitFeedback</a>
 * operation to provide relevance information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RelevanceFeedback implements SdkPojo, Serializable,
        ToCopyableBuilder<RelevanceFeedback.Builder, RelevanceFeedback> {
    private static final SdkField<String> RESULT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResultId").getter(getter(RelevanceFeedback::resultId)).setter(setter(Builder::resultId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultId").build()).build();

    private static final SdkField<String> RELEVANCE_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RelevanceValue").getter(getter(RelevanceFeedback::relevanceValueAsString))
            .setter(setter(Builder::relevanceValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelevanceValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULT_ID_FIELD,
            RELEVANCE_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resultId;

    private final String relevanceValue;

    private RelevanceFeedback(BuilderImpl builder) {
        this.resultId = builder.resultId;
        this.relevanceValue = builder.relevanceValue;
    }

    /**
     * <p>
     * The unique identifier of the search result that the user provided relevance feedback for.
     * </p>
     * 
     * @return The unique identifier of the search result that the user provided relevance feedback for.
     */
    public final String resultId() {
        return resultId;
    }

    /**
     * <p>
     * Whether to document was relevant or not relevant to the search.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #relevanceValue}
     * will return {@link RelevanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #relevanceValueAsString}.
     * </p>
     * 
     * @return Whether to document was relevant or not relevant to the search.
     * @see RelevanceType
     */
    public final RelevanceType relevanceValue() {
        return RelevanceType.fromValue(relevanceValue);
    }

    /**
     * <p>
     * Whether to document was relevant or not relevant to the search.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #relevanceValue}
     * will return {@link RelevanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #relevanceValueAsString}.
     * </p>
     * 
     * @return Whether to document was relevant or not relevant to the search.
     * @see RelevanceType
     */
    public final String relevanceValueAsString() {
        return relevanceValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resultId());
        hashCode = 31 * hashCode + Objects.hashCode(relevanceValueAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelevanceFeedback)) {
            return false;
        }
        RelevanceFeedback other = (RelevanceFeedback) obj;
        return Objects.equals(resultId(), other.resultId())
                && Objects.equals(relevanceValueAsString(), other.relevanceValueAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RelevanceFeedback").add("ResultId", resultId()).add("RelevanceValue", relevanceValueAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResultId":
            return Optional.ofNullable(clazz.cast(resultId()));
        case "RelevanceValue":
            return Optional.ofNullable(clazz.cast(relevanceValueAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RelevanceFeedback, T> g) {
        return obj -> g.apply((RelevanceFeedback) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RelevanceFeedback> {
        /**
         * <p>
         * The unique identifier of the search result that the user provided relevance feedback for.
         * </p>
         * 
         * @param resultId
         *        The unique identifier of the search result that the user provided relevance feedback for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultId(String resultId);

        /**
         * <p>
         * Whether to document was relevant or not relevant to the search.
         * </p>
         * 
         * @param relevanceValue
         *        Whether to document was relevant or not relevant to the search.
         * @see RelevanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RelevanceType
         */
        Builder relevanceValue(String relevanceValue);

        /**
         * <p>
         * Whether to document was relevant or not relevant to the search.
         * </p>
         * 
         * @param relevanceValue
         *        Whether to document was relevant or not relevant to the search.
         * @see RelevanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RelevanceType
         */
        Builder relevanceValue(RelevanceType relevanceValue);
    }

    static final class BuilderImpl implements Builder {
        private String resultId;

        private String relevanceValue;

        private BuilderImpl() {
        }

        private BuilderImpl(RelevanceFeedback model) {
            resultId(model.resultId);
            relevanceValue(model.relevanceValue);
        }

        public final String getResultId() {
            return resultId;
        }

        @Override
        public final Builder resultId(String resultId) {
            this.resultId = resultId;
            return this;
        }

        public final void setResultId(String resultId) {
            this.resultId = resultId;
        }

        public final String getRelevanceValue() {
            return relevanceValue;
        }

        @Override
        public final Builder relevanceValue(String relevanceValue) {
            this.relevanceValue = relevanceValue;
            return this;
        }

        @Override
        public final Builder relevanceValue(RelevanceType relevanceValue) {
            this.relevanceValue(relevanceValue == null ? null : relevanceValue.toString());
            return this;
        }

        public final void setRelevanceValue(String relevanceValue) {
            this.relevanceValue = relevanceValue;
        }

        @Override
        public RelevanceFeedback build() {
            return new RelevanceFeedback(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
