/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryRequest extends KendraRequest implements ToCopyableBuilder<QueryRequest.Builder, QueryRequest> {
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexId").getter(getter(QueryRequest::indexId)).setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()).build();

    private static final SdkField<String> QUERY_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryText").getter(getter(QueryRequest::queryText)).setter(setter(Builder::queryText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryText").build()).build();

    private static final SdkField<AttributeFilter> ATTRIBUTE_FILTER_FIELD = SdkField
            .<AttributeFilter> builder(MarshallingType.SDK_POJO).memberName("AttributeFilter")
            .getter(getter(QueryRequest::attributeFilter)).setter(setter(Builder::attributeFilter))
            .constructor(AttributeFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeFilter").build()).build();

    private static final SdkField<List<Facet>> FACETS_FIELD = SdkField
            .<List<Facet>> builder(MarshallingType.LIST)
            .memberName("Facets")
            .getter(getter(QueryRequest::facets))
            .setter(setter(Builder::facets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Facets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Facet> builder(MarshallingType.SDK_POJO)
                                            .constructor(Facet::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> REQUESTED_DOCUMENT_ATTRIBUTES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RequestedDocumentAttributes")
            .getter(getter(QueryRequest::requestedDocumentAttributes))
            .setter(setter(Builder::requestedDocumentAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestedDocumentAttributes")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> QUERY_RESULT_TYPE_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryResultTypeFilter").getter(getter(QueryRequest::queryResultTypeFilterAsString))
            .setter(setter(Builder::queryResultTypeFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryResultTypeFilter").build())
            .build();

    private static final SdkField<Integer> PAGE_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PageNumber").getter(getter(QueryRequest::pageNumber)).setter(setter(Builder::pageNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageNumber").build()).build();

    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PageSize").getter(getter(QueryRequest::pageSize)).setter(setter(Builder::pageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageSize").build()).build();

    private static final SdkField<SortingConfiguration> SORTING_CONFIGURATION_FIELD = SdkField
            .<SortingConfiguration> builder(MarshallingType.SDK_POJO).memberName("SortingConfiguration")
            .getter(getter(QueryRequest::sortingConfiguration)).setter(setter(Builder::sortingConfiguration))
            .constructor(SortingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortingConfiguration").build())
            .build();

    private static final SdkField<UserContext> USER_CONTEXT_FIELD = SdkField.<UserContext> builder(MarshallingType.SDK_POJO)
            .memberName("UserContext").getter(getter(QueryRequest::userContext)).setter(setter(Builder::userContext))
            .constructor(UserContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserContext").build()).build();

    private static final SdkField<String> VISITOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VisitorId").getter(getter(QueryRequest::visitorId)).setter(setter(Builder::visitorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisitorId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_ID_FIELD,
            QUERY_TEXT_FIELD, ATTRIBUTE_FILTER_FIELD, FACETS_FIELD, REQUESTED_DOCUMENT_ATTRIBUTES_FIELD,
            QUERY_RESULT_TYPE_FILTER_FIELD, PAGE_NUMBER_FIELD, PAGE_SIZE_FIELD, SORTING_CONFIGURATION_FIELD, USER_CONTEXT_FIELD,
            VISITOR_ID_FIELD));

    private final String indexId;

    private final String queryText;

    private final AttributeFilter attributeFilter;

    private final List<Facet> facets;

    private final List<String> requestedDocumentAttributes;

    private final String queryResultTypeFilter;

    private final Integer pageNumber;

    private final Integer pageSize;

    private final SortingConfiguration sortingConfiguration;

    private final UserContext userContext;

    private final String visitorId;

    private QueryRequest(BuilderImpl builder) {
        super(builder);
        this.indexId = builder.indexId;
        this.queryText = builder.queryText;
        this.attributeFilter = builder.attributeFilter;
        this.facets = builder.facets;
        this.requestedDocumentAttributes = builder.requestedDocumentAttributes;
        this.queryResultTypeFilter = builder.queryResultTypeFilter;
        this.pageNumber = builder.pageNumber;
        this.pageSize = builder.pageSize;
        this.sortingConfiguration = builder.sortingConfiguration;
        this.userContext = builder.userContext;
        this.visitorId = builder.visitorId;
    }

    /**
     * <p>
     * The unique identifier of the index to search. The identifier is returned in the response from the operation.
     * </p>
     * 
     * @return The unique identifier of the index to search. The identifier is returned in the response from the
     *         operation.
     */
    public final String indexId() {
        return indexId;
    }

    /**
     * <p>
     * The text to search for.
     * </p>
     * 
     * @return The text to search for.
     */
    public final String queryText() {
        return queryText;
    }

    /**
     * <p>
     * Enables filtered searches based on document attributes. You can only provide one attribute filter; however, the
     * <code>AndAllFilters</code>, <code>NotFilter</code>, and <code>OrAllFilters</code> parameters contain a list of
     * other filters.
     * </p>
     * <p>
     * The <code>AttributeFilter</code> parameter enables you to create a set of filtering rules that a document must
     * satisfy to be included in the query results.
     * </p>
     * 
     * @return Enables filtered searches based on document attributes. You can only provide one attribute filter;
     *         however, the <code>AndAllFilters</code>, <code>NotFilter</code>, and <code>OrAllFilters</code> parameters
     *         contain a list of other filters.</p>
     *         <p>
     *         The <code>AttributeFilter</code> parameter enables you to create a set of filtering rules that a document
     *         must satisfy to be included in the query results.
     */
    public final AttributeFilter attributeFilter() {
        return attributeFilter;
    }

    /**
     * Returns true if the Facets property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFacets() {
        return facets != null && !(facets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of documents attributes. Amazon Kendra returns a count for each attribute key specified. You can use
     * this information to help narrow the search for your user.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFacets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of documents attributes. Amazon Kendra returns a count for each attribute key specified. You can
     *         use this information to help narrow the search for your user.
     */
    public final List<Facet> facets() {
        return facets;
    }

    /**
     * Returns true if the RequestedDocumentAttributes property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasRequestedDocumentAttributes() {
        return requestedDocumentAttributes != null && !(requestedDocumentAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of document attributes to include in the response. No other document attributes are included in the
     * response. By default all document attributes are included in the response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRequestedDocumentAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of document attributes to include in the response. No other document attributes are included in
     *         the response. By default all document attributes are included in the response.
     */
    public final List<String> requestedDocumentAttributes() {
        return requestedDocumentAttributes;
    }

    /**
     * <p>
     * Sets the type of query. Only results for the specified query type are returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #queryResultTypeFilter} will return {@link QueryResultType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #queryResultTypeFilterAsString}.
     * </p>
     * 
     * @return Sets the type of query. Only results for the specified query type are returned.
     * @see QueryResultType
     */
    public final QueryResultType queryResultTypeFilter() {
        return QueryResultType.fromValue(queryResultTypeFilter);
    }

    /**
     * <p>
     * Sets the type of query. Only results for the specified query type are returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #queryResultTypeFilter} will return {@link QueryResultType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #queryResultTypeFilterAsString}.
     * </p>
     * 
     * @return Sets the type of query. Only results for the specified query type are returned.
     * @see QueryResultType
     */
    public final String queryResultTypeFilterAsString() {
        return queryResultTypeFilter;
    }

    /**
     * <p>
     * Query results are returned in pages the size of the <code>PageSize</code> parameter. By default, Amazon Kendra
     * returns the first page of results. Use this parameter to get result pages after the first one.
     * </p>
     * 
     * @return Query results are returned in pages the size of the <code>PageSize</code> parameter. By default, Amazon
     *         Kendra returns the first page of results. Use this parameter to get result pages after the first one.
     */
    public final Integer pageNumber() {
        return pageNumber;
    }

    /**
     * <p>
     * Sets the number of results that are returned in each page of results. The default page size is 10. The maximum
     * number of results returned is 100. If you ask for more than 100 results, only 100 are returned.
     * </p>
     * 
     * @return Sets the number of results that are returned in each page of results. The default page size is 10. The
     *         maximum number of results returned is 100. If you ask for more than 100 results, only 100 are returned.
     */
    public final Integer pageSize() {
        return pageSize;
    }

    /**
     * <p>
     * Provides information that determines how the results of the query are sorted. You can set the field that Amazon
     * Kendra should sort the results on, and specify whether the results should be sorted in ascending or descending
     * order. In the case of ties in sorting the results, the results are sorted by relevance.
     * </p>
     * <p>
     * If you don't provide sorting configuration, the results are sorted by the relevance that Amazon Kendra determines
     * for the result.
     * </p>
     * 
     * @return Provides information that determines how the results of the query are sorted. You can set the field that
     *         Amazon Kendra should sort the results on, and specify whether the results should be sorted in ascending
     *         or descending order. In the case of ties in sorting the results, the results are sorted by relevance.</p>
     *         <p>
     *         If you don't provide sorting configuration, the results are sorted by the relevance that Amazon Kendra
     *         determines for the result.
     */
    public final SortingConfiguration sortingConfiguration() {
        return sortingConfiguration;
    }

    /**
     * <p>
     * The user context token.
     * </p>
     * 
     * @return The user context token.
     */
    public final UserContext userContext() {
        return userContext;
    }

    /**
     * <p>
     * Provides an identifier for a specific user. The <code>VisitorId</code> should be a unique identifier, such as a
     * GUID. Don't use personally identifiable information, such as the user's email address, as the
     * <code>VisitorId</code>.
     * </p>
     * 
     * @return Provides an identifier for a specific user. The <code>VisitorId</code> should be a unique identifier,
     *         such as a GUID. Don't use personally identifiable information, such as the user's email address, as the
     *         <code>VisitorId</code>.
     */
    public final String visitorId() {
        return visitorId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        hashCode = 31 * hashCode + Objects.hashCode(queryText());
        hashCode = 31 * hashCode + Objects.hashCode(attributeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(hasFacets() ? facets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRequestedDocumentAttributes() ? requestedDocumentAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(queryResultTypeFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(pageNumber());
        hashCode = 31 * hashCode + Objects.hashCode(pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(sortingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(userContext());
        hashCode = 31 * hashCode + Objects.hashCode(visitorId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryRequest)) {
            return false;
        }
        QueryRequest other = (QueryRequest) obj;
        return Objects.equals(indexId(), other.indexId()) && Objects.equals(queryText(), other.queryText())
                && Objects.equals(attributeFilter(), other.attributeFilter()) && hasFacets() == other.hasFacets()
                && Objects.equals(facets(), other.facets())
                && hasRequestedDocumentAttributes() == other.hasRequestedDocumentAttributes()
                && Objects.equals(requestedDocumentAttributes(), other.requestedDocumentAttributes())
                && Objects.equals(queryResultTypeFilterAsString(), other.queryResultTypeFilterAsString())
                && Objects.equals(pageNumber(), other.pageNumber()) && Objects.equals(pageSize(), other.pageSize())
                && Objects.equals(sortingConfiguration(), other.sortingConfiguration())
                && Objects.equals(userContext(), other.userContext()) && Objects.equals(visitorId(), other.visitorId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QueryRequest").add("IndexId", indexId()).add("QueryText", queryText())
                .add("AttributeFilter", attributeFilter()).add("Facets", hasFacets() ? facets() : null)
                .add("RequestedDocumentAttributes", hasRequestedDocumentAttributes() ? requestedDocumentAttributes() : null)
                .add("QueryResultTypeFilter", queryResultTypeFilterAsString()).add("PageNumber", pageNumber())
                .add("PageSize", pageSize()).add("SortingConfiguration", sortingConfiguration())
                .add("UserContext", userContext()).add("VisitorId", visitorId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        case "QueryText":
            return Optional.ofNullable(clazz.cast(queryText()));
        case "AttributeFilter":
            return Optional.ofNullable(clazz.cast(attributeFilter()));
        case "Facets":
            return Optional.ofNullable(clazz.cast(facets()));
        case "RequestedDocumentAttributes":
            return Optional.ofNullable(clazz.cast(requestedDocumentAttributes()));
        case "QueryResultTypeFilter":
            return Optional.ofNullable(clazz.cast(queryResultTypeFilterAsString()));
        case "PageNumber":
            return Optional.ofNullable(clazz.cast(pageNumber()));
        case "PageSize":
            return Optional.ofNullable(clazz.cast(pageSize()));
        case "SortingConfiguration":
            return Optional.ofNullable(clazz.cast(sortingConfiguration()));
        case "UserContext":
            return Optional.ofNullable(clazz.cast(userContext()));
        case "VisitorId":
            return Optional.ofNullable(clazz.cast(visitorId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryRequest, T> g) {
        return obj -> g.apply((QueryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraRequest.Builder, SdkPojo, CopyableBuilder<Builder, QueryRequest> {
        /**
         * <p>
         * The unique identifier of the index to search. The identifier is returned in the response from the operation.
         * </p>
         * 
         * @param indexId
         *        The unique identifier of the index to search. The identifier is returned in the response from the
         *        operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);

        /**
         * <p>
         * The text to search for.
         * </p>
         * 
         * @param queryText
         *        The text to search for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryText(String queryText);

        /**
         * <p>
         * Enables filtered searches based on document attributes. You can only provide one attribute filter; however,
         * the <code>AndAllFilters</code>, <code>NotFilter</code>, and <code>OrAllFilters</code> parameters contain a
         * list of other filters.
         * </p>
         * <p>
         * The <code>AttributeFilter</code> parameter enables you to create a set of filtering rules that a document
         * must satisfy to be included in the query results.
         * </p>
         * 
         * @param attributeFilter
         *        Enables filtered searches based on document attributes. You can only provide one attribute filter;
         *        however, the <code>AndAllFilters</code>, <code>NotFilter</code>, and <code>OrAllFilters</code>
         *        parameters contain a list of other filters.</p>
         *        <p>
         *        The <code>AttributeFilter</code> parameter enables you to create a set of filtering rules that a
         *        document must satisfy to be included in the query results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeFilter(AttributeFilter attributeFilter);

        /**
         * <p>
         * Enables filtered searches based on document attributes. You can only provide one attribute filter; however,
         * the <code>AndAllFilters</code>, <code>NotFilter</code>, and <code>OrAllFilters</code> parameters contain a
         * list of other filters.
         * </p>
         * <p>
         * The <code>AttributeFilter</code> parameter enables you to create a set of filtering rules that a document
         * must satisfy to be included in the query results.
         * </p>
         * This is a convenience that creates an instance of the {@link AttributeFilter.Builder} avoiding the need to
         * create one manually via {@link AttributeFilter#builder()}.
         *
         * When the {@link Consumer} completes, {@link AttributeFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #attributeFilter(AttributeFilter)}.
         * 
         * @param attributeFilter
         *        a consumer that will call methods on {@link AttributeFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributeFilter(AttributeFilter)
         */
        default Builder attributeFilter(Consumer<AttributeFilter.Builder> attributeFilter) {
            return attributeFilter(AttributeFilter.builder().applyMutation(attributeFilter).build());
        }

        /**
         * <p>
         * An array of documents attributes. Amazon Kendra returns a count for each attribute key specified. You can use
         * this information to help narrow the search for your user.
         * </p>
         * 
         * @param facets
         *        An array of documents attributes. Amazon Kendra returns a count for each attribute key specified. You
         *        can use this information to help narrow the search for your user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder facets(Collection<Facet> facets);

        /**
         * <p>
         * An array of documents attributes. Amazon Kendra returns a count for each attribute key specified. You can use
         * this information to help narrow the search for your user.
         * </p>
         * 
         * @param facets
         *        An array of documents attributes. Amazon Kendra returns a count for each attribute key specified. You
         *        can use this information to help narrow the search for your user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder facets(Facet... facets);

        /**
         * <p>
         * An array of documents attributes. Amazon Kendra returns a count for each attribute key specified. You can use
         * this information to help narrow the search for your user.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Facet>.Builder} avoiding the need to create
         * one manually via {@link List<Facet>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Facet>.Builder#build()} is called immediately and its result
         * is passed to {@link #facets(List<Facet>)}.
         * 
         * @param facets
         *        a consumer that will call methods on {@link List<Facet>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #facets(List<Facet>)
         */
        Builder facets(Consumer<Facet.Builder>... facets);

        /**
         * <p>
         * An array of document attributes to include in the response. No other document attributes are included in the
         * response. By default all document attributes are included in the response.
         * </p>
         * 
         * @param requestedDocumentAttributes
         *        An array of document attributes to include in the response. No other document attributes are included
         *        in the response. By default all document attributes are included in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestedDocumentAttributes(Collection<String> requestedDocumentAttributes);

        /**
         * <p>
         * An array of document attributes to include in the response. No other document attributes are included in the
         * response. By default all document attributes are included in the response.
         * </p>
         * 
         * @param requestedDocumentAttributes
         *        An array of document attributes to include in the response. No other document attributes are included
         *        in the response. By default all document attributes are included in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestedDocumentAttributes(String... requestedDocumentAttributes);

        /**
         * <p>
         * Sets the type of query. Only results for the specified query type are returned.
         * </p>
         * 
         * @param queryResultTypeFilter
         *        Sets the type of query. Only results for the specified query type are returned.
         * @see QueryResultType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryResultType
         */
        Builder queryResultTypeFilter(String queryResultTypeFilter);

        /**
         * <p>
         * Sets the type of query. Only results for the specified query type are returned.
         * </p>
         * 
         * @param queryResultTypeFilter
         *        Sets the type of query. Only results for the specified query type are returned.
         * @see QueryResultType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryResultType
         */
        Builder queryResultTypeFilter(QueryResultType queryResultTypeFilter);

        /**
         * <p>
         * Query results are returned in pages the size of the <code>PageSize</code> parameter. By default, Amazon
         * Kendra returns the first page of results. Use this parameter to get result pages after the first one.
         * </p>
         * 
         * @param pageNumber
         *        Query results are returned in pages the size of the <code>PageSize</code> parameter. By default,
         *        Amazon Kendra returns the first page of results. Use this parameter to get result pages after the
         *        first one.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageNumber(Integer pageNumber);

        /**
         * <p>
         * Sets the number of results that are returned in each page of results. The default page size is 10. The
         * maximum number of results returned is 100. If you ask for more than 100 results, only 100 are returned.
         * </p>
         * 
         * @param pageSize
         *        Sets the number of results that are returned in each page of results. The default page size is 10. The
         *        maximum number of results returned is 100. If you ask for more than 100 results, only 100 are
         *        returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageSize(Integer pageSize);

        /**
         * <p>
         * Provides information that determines how the results of the query are sorted. You can set the field that
         * Amazon Kendra should sort the results on, and specify whether the results should be sorted in ascending or
         * descending order. In the case of ties in sorting the results, the results are sorted by relevance.
         * </p>
         * <p>
         * If you don't provide sorting configuration, the results are sorted by the relevance that Amazon Kendra
         * determines for the result.
         * </p>
         * 
         * @param sortingConfiguration
         *        Provides information that determines how the results of the query are sorted. You can set the field
         *        that Amazon Kendra should sort the results on, and specify whether the results should be sorted in
         *        ascending or descending order. In the case of ties in sorting the results, the results are sorted by
         *        relevance.</p>
         *        <p>
         *        If you don't provide sorting configuration, the results are sorted by the relevance that Amazon Kendra
         *        determines for the result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortingConfiguration(SortingConfiguration sortingConfiguration);

        /**
         * <p>
         * Provides information that determines how the results of the query are sorted. You can set the field that
         * Amazon Kendra should sort the results on, and specify whether the results should be sorted in ascending or
         * descending order. In the case of ties in sorting the results, the results are sorted by relevance.
         * </p>
         * <p>
         * If you don't provide sorting configuration, the results are sorted by the relevance that Amazon Kendra
         * determines for the result.
         * </p>
         * This is a convenience that creates an instance of the {@link SortingConfiguration.Builder} avoiding the need
         * to create one manually via {@link SortingConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link SortingConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #sortingConfiguration(SortingConfiguration)}.
         * 
         * @param sortingConfiguration
         *        a consumer that will call methods on {@link SortingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortingConfiguration(SortingConfiguration)
         */
        default Builder sortingConfiguration(Consumer<SortingConfiguration.Builder> sortingConfiguration) {
            return sortingConfiguration(SortingConfiguration.builder().applyMutation(sortingConfiguration).build());
        }

        /**
         * <p>
         * The user context token.
         * </p>
         * 
         * @param userContext
         *        The user context token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userContext(UserContext userContext);

        /**
         * <p>
         * The user context token.
         * </p>
         * This is a convenience that creates an instance of the {@link UserContext.Builder} avoiding the need to create
         * one manually via {@link UserContext#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserContext.Builder#build()} is called immediately and its result
         * is passed to {@link #userContext(UserContext)}.
         * 
         * @param userContext
         *        a consumer that will call methods on {@link UserContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userContext(UserContext)
         */
        default Builder userContext(Consumer<UserContext.Builder> userContext) {
            return userContext(UserContext.builder().applyMutation(userContext).build());
        }

        /**
         * <p>
         * Provides an identifier for a specific user. The <code>VisitorId</code> should be a unique identifier, such as
         * a GUID. Don't use personally identifiable information, such as the user's email address, as the
         * <code>VisitorId</code>.
         * </p>
         * 
         * @param visitorId
         *        Provides an identifier for a specific user. The <code>VisitorId</code> should be a unique identifier,
         *        such as a GUID. Don't use personally identifiable information, such as the user's email address, as
         *        the <code>VisitorId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visitorId(String visitorId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KendraRequest.BuilderImpl implements Builder {
        private String indexId;

        private String queryText;

        private AttributeFilter attributeFilter;

        private List<Facet> facets = DefaultSdkAutoConstructList.getInstance();

        private List<String> requestedDocumentAttributes = DefaultSdkAutoConstructList.getInstance();

        private String queryResultTypeFilter;

        private Integer pageNumber;

        private Integer pageSize;

        private SortingConfiguration sortingConfiguration;

        private UserContext userContext;

        private String visitorId;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryRequest model) {
            super(model);
            indexId(model.indexId);
            queryText(model.queryText);
            attributeFilter(model.attributeFilter);
            facets(model.facets);
            requestedDocumentAttributes(model.requestedDocumentAttributes);
            queryResultTypeFilter(model.queryResultTypeFilter);
            pageNumber(model.pageNumber);
            pageSize(model.pageSize);
            sortingConfiguration(model.sortingConfiguration);
            userContext(model.userContext);
            visitorId(model.visitorId);
        }

        public final String getIndexId() {
            return indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        public final String getQueryText() {
            return queryText;
        }

        @Override
        public final Builder queryText(String queryText) {
            this.queryText = queryText;
            return this;
        }

        public final void setQueryText(String queryText) {
            this.queryText = queryText;
        }

        public final AttributeFilter.Builder getAttributeFilter() {
            return attributeFilter != null ? attributeFilter.toBuilder() : null;
        }

        @Override
        public final Builder attributeFilter(AttributeFilter attributeFilter) {
            this.attributeFilter = attributeFilter;
            return this;
        }

        public final void setAttributeFilter(AttributeFilter.BuilderImpl attributeFilter) {
            this.attributeFilter = attributeFilter != null ? attributeFilter.build() : null;
        }

        public final Collection<Facet.Builder> getFacets() {
            if (facets instanceof SdkAutoConstructList) {
                return null;
            }
            return facets != null ? facets.stream().map(Facet::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder facets(Collection<Facet> facets) {
            this.facets = FacetListCopier.copy(facets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder facets(Facet... facets) {
            facets(Arrays.asList(facets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder facets(Consumer<Facet.Builder>... facets) {
            facets(Stream.of(facets).map(c -> Facet.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFacets(Collection<Facet.BuilderImpl> facets) {
            this.facets = FacetListCopier.copyFromBuilder(facets);
        }

        public final Collection<String> getRequestedDocumentAttributes() {
            if (requestedDocumentAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return requestedDocumentAttributes;
        }

        @Override
        public final Builder requestedDocumentAttributes(Collection<String> requestedDocumentAttributes) {
            this.requestedDocumentAttributes = DocumentAttributeKeyListCopier.copy(requestedDocumentAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requestedDocumentAttributes(String... requestedDocumentAttributes) {
            requestedDocumentAttributes(Arrays.asList(requestedDocumentAttributes));
            return this;
        }

        public final void setRequestedDocumentAttributes(Collection<String> requestedDocumentAttributes) {
            this.requestedDocumentAttributes = DocumentAttributeKeyListCopier.copy(requestedDocumentAttributes);
        }

        public final String getQueryResultTypeFilter() {
            return queryResultTypeFilter;
        }

        @Override
        public final Builder queryResultTypeFilter(String queryResultTypeFilter) {
            this.queryResultTypeFilter = queryResultTypeFilter;
            return this;
        }

        @Override
        public final Builder queryResultTypeFilter(QueryResultType queryResultTypeFilter) {
            this.queryResultTypeFilter(queryResultTypeFilter == null ? null : queryResultTypeFilter.toString());
            return this;
        }

        public final void setQueryResultTypeFilter(String queryResultTypeFilter) {
            this.queryResultTypeFilter = queryResultTypeFilter;
        }

        public final Integer getPageNumber() {
            return pageNumber;
        }

        @Override
        public final Builder pageNumber(Integer pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public final void setPageNumber(Integer pageNumber) {
            this.pageNumber = pageNumber;
        }

        public final Integer getPageSize() {
            return pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public final SortingConfiguration.Builder getSortingConfiguration() {
            return sortingConfiguration != null ? sortingConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder sortingConfiguration(SortingConfiguration sortingConfiguration) {
            this.sortingConfiguration = sortingConfiguration;
            return this;
        }

        public final void setSortingConfiguration(SortingConfiguration.BuilderImpl sortingConfiguration) {
            this.sortingConfiguration = sortingConfiguration != null ? sortingConfiguration.build() : null;
        }

        public final UserContext.Builder getUserContext() {
            return userContext != null ? userContext.toBuilder() : null;
        }

        @Override
        public final Builder userContext(UserContext userContext) {
            this.userContext = userContext;
            return this;
        }

        public final void setUserContext(UserContext.BuilderImpl userContext) {
            this.userContext = userContext != null ? userContext.build() : null;
        }

        public final String getVisitorId() {
            return visitorId;
        }

        @Override
        public final Builder visitorId(String visitorId) {
            this.visitorId = visitorId;
            return this;
        }

        public final void setVisitorId(String visitorId) {
            this.visitorId = visitorId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public QueryRequest build() {
            return new QueryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
