/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDataSourceSyncJobsResponse extends KendraResponse implements
        ToCopyableBuilder<ListDataSourceSyncJobsResponse.Builder, ListDataSourceSyncJobsResponse> {
    private static final SdkField<List<DataSourceSyncJob>> HISTORY_FIELD = SdkField
            .<List<DataSourceSyncJob>> builder(MarshallingType.LIST)
            .memberName("History")
            .getter(getter(ListDataSourceSyncJobsResponse::history))
            .setter(setter(Builder::history))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("History").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataSourceSyncJob> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataSourceSyncJob::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListDataSourceSyncJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HISTORY_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<DataSourceSyncJob> history;

    private final String nextToken;

    private ListDataSourceSyncJobsResponse(BuilderImpl builder) {
        super(builder);
        this.history = builder.history;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the History property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasHistory() {
        return history != null && !(history instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A history of synchronization jobs for the data source.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasHistory()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A history of synchronization jobs for the data source.
     */
    public final List<DataSourceSyncJob> history() {
        return history;
    }

    /**
     * <p>
     * The <code>GetDataSourceSyncJobHistory</code> operation returns a page of vocabularies at a time. The maximum size
     * of the page is set by the <code>MaxResults</code> parameter. If there are more jobs in the list than the page
     * size, Amazon Kendra returns the NextPage token. Include the token in the next request to the
     * <code>GetDataSourceSyncJobHistory</code> operation to return in the next page of jobs.
     * </p>
     * 
     * @return The <code>GetDataSourceSyncJobHistory</code> operation returns a page of vocabularies at a time. The
     *         maximum size of the page is set by the <code>MaxResults</code> parameter. If there are more jobs in the
     *         list than the page size, Amazon Kendra returns the NextPage token. Include the token in the next request
     *         to the <code>GetDataSourceSyncJobHistory</code> operation to return in the next page of jobs.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasHistory() ? history() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataSourceSyncJobsResponse)) {
            return false;
        }
        ListDataSourceSyncJobsResponse other = (ListDataSourceSyncJobsResponse) obj;
        return hasHistory() == other.hasHistory() && Objects.equals(history(), other.history())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDataSourceSyncJobsResponse").add("History", hasHistory() ? history() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "History":
            return Optional.ofNullable(clazz.cast(history()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDataSourceSyncJobsResponse, T> g) {
        return obj -> g.apply((ListDataSourceSyncJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListDataSourceSyncJobsResponse> {
        /**
         * <p>
         * A history of synchronization jobs for the data source.
         * </p>
         * 
         * @param history
         *        A history of synchronization jobs for the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder history(Collection<DataSourceSyncJob> history);

        /**
         * <p>
         * A history of synchronization jobs for the data source.
         * </p>
         * 
         * @param history
         *        A history of synchronization jobs for the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder history(DataSourceSyncJob... history);

        /**
         * <p>
         * A history of synchronization jobs for the data source.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DataSourceSyncJob>.Builder} avoiding the
         * need to create one manually via {@link List<DataSourceSyncJob>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DataSourceSyncJob>.Builder#build()} is called immediately
         * and its result is passed to {@link #history(List<DataSourceSyncJob>)}.
         * 
         * @param history
         *        a consumer that will call methods on {@link List<DataSourceSyncJob>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #history(List<DataSourceSyncJob>)
         */
        Builder history(Consumer<DataSourceSyncJob.Builder>... history);

        /**
         * <p>
         * The <code>GetDataSourceSyncJobHistory</code> operation returns a page of vocabularies at a time. The maximum
         * size of the page is set by the <code>MaxResults</code> parameter. If there are more jobs in the list than the
         * page size, Amazon Kendra returns the NextPage token. Include the token in the next request to the
         * <code>GetDataSourceSyncJobHistory</code> operation to return in the next page of jobs.
         * </p>
         * 
         * @param nextToken
         *        The <code>GetDataSourceSyncJobHistory</code> operation returns a page of vocabularies at a time. The
         *        maximum size of the page is set by the <code>MaxResults</code> parameter. If there are more jobs in
         *        the list than the page size, Amazon Kendra returns the NextPage token. Include the token in the next
         *        request to the <code>GetDataSourceSyncJobHistory</code> operation to return in the next page of jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends KendraResponse.BuilderImpl implements Builder {
        private List<DataSourceSyncJob> history = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataSourceSyncJobsResponse model) {
            super(model);
            history(model.history);
            nextToken(model.nextToken);
        }

        public final Collection<DataSourceSyncJob.Builder> getHistory() {
            if (history instanceof SdkAutoConstructList) {
                return null;
            }
            return history != null ? history.stream().map(DataSourceSyncJob::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder history(Collection<DataSourceSyncJob> history) {
            this.history = DataSourceSyncJobHistoryListCopier.copy(history);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder history(DataSourceSyncJob... history) {
            history(Arrays.asList(history));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder history(Consumer<DataSourceSyncJob.Builder>... history) {
            history(Stream.of(history).map(c -> DataSourceSyncJob.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setHistory(Collection<DataSourceSyncJob.BuilderImpl> history) {
            this.history = DataSourceSyncJobHistoryListCopier.copyFromBuilder(history);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDataSourceSyncJobsResponse build() {
            return new ListDataSourceSyncJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
