/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.ContentType;
import software.amazon.awssdk.services.kendra.model.DocumentAttribute;
import software.amazon.awssdk.services.kendra.model.DocumentAttributeListCopier;
import software.amazon.awssdk.services.kendra.model.Principal;
import software.amazon.awssdk.services.kendra.model.PrincipalListCopier;
import software.amazon.awssdk.services.kendra.model.S3Path;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Document
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Document> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(Document.getter(Document::id)).setter(Document.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(Document.getter(Document::title)).setter(Document.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<SdkBytes> BLOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("Blob").getter(Document.getter(Document::blob)).setter(Document.setter(Builder::blob)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Blob").build()}).build();
    private static final SdkField<S3Path> S3_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3Path").getter(Document.getter(Document::s3Path)).setter(Document.setter(Builder::s3Path)).constructor(S3Path::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Path").build()}).build();
    private static final SdkField<List<DocumentAttribute>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Attributes").getter(Document.getter(Document::attributes)).setter(Document.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DocumentAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Principal>> ACCESS_CONTROL_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccessControlList").getter(Document.getter(Document::accessControlList)).setter(Document.setter(Builder::accessControlList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessControlList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Principal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentType").getter(Document.getter(Document::contentTypeAsString)).setter(Document.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TITLE_FIELD, BLOB_FIELD, S3_PATH_FIELD, ATTRIBUTES_FIELD, ACCESS_CONTROL_LIST_FIELD, CONTENT_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String title;
    private final SdkBytes blob;
    private final S3Path s3Path;
    private final List<DocumentAttribute> attributes;
    private final List<Principal> accessControlList;
    private final String contentType;

    private Document(BuilderImpl builder) {
        this.id = builder.id;
        this.title = builder.title;
        this.blob = builder.blob;
        this.s3Path = builder.s3Path;
        this.attributes = builder.attributes;
        this.accessControlList = builder.accessControlList;
        this.contentType = builder.contentType;
    }

    public final String id() {
        return this.id;
    }

    public final String title() {
        return this.title;
    }

    public final SdkBytes blob() {
        return this.blob;
    }

    public final S3Path s3Path() {
        return this.s3Path;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructList);
    }

    public final List<DocumentAttribute> attributes() {
        return this.attributes;
    }

    public final boolean hasAccessControlList() {
        return this.accessControlList != null && !(this.accessControlList instanceof SdkAutoConstructList);
    }

    public final List<Principal> accessControlList() {
        return this.accessControlList;
    }

    public final ContentType contentType() {
        return ContentType.fromValue(this.contentType);
    }

    public final String contentTypeAsString() {
        return this.contentType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.blob());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Path());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccessControlList() ? this.accessControlList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.contentTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Document)) {
            return false;
        }
        Document other = (Document)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.blob(), other.blob()) && Objects.equals(this.s3Path(), other.s3Path()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && this.hasAccessControlList() == other.hasAccessControlList() && Objects.equals(this.accessControlList(), other.accessControlList()) && Objects.equals(this.contentTypeAsString(), other.contentTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Document").add("Id", (Object)this.id()).add("Title", (Object)this.title()).add("Blob", (Object)this.blob()).add("S3Path", (Object)this.s3Path()).add("Attributes", this.hasAttributes() ? this.attributes() : null).add("AccessControlList", this.hasAccessControlList() ? this.accessControlList() : null).add("ContentType", (Object)this.contentTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Blob": {
                return Optional.ofNullable(clazz.cast(this.blob()));
            }
            case "S3Path": {
                return Optional.ofNullable(clazz.cast(this.s3Path()));
            }
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "AccessControlList": {
                return Optional.ofNullable(clazz.cast(this.accessControlList()));
            }
            case "ContentType": {
                return Optional.ofNullable(clazz.cast(this.contentTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Document, T> g) {
        return obj -> g.apply((Document)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String title;
        private SdkBytes blob;
        private S3Path s3Path;
        private List<DocumentAttribute> attributes = DefaultSdkAutoConstructList.getInstance();
        private List<Principal> accessControlList = DefaultSdkAutoConstructList.getInstance();
        private String contentType;

        private BuilderImpl() {
        }

        private BuilderImpl(Document model) {
            this.id(model.id);
            this.title(model.title);
            this.blob(model.blob);
            this.s3Path(model.s3Path);
            this.attributes(model.attributes);
            this.accessControlList(model.accessControlList);
            this.contentType(model.contentType);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getTitle() {
            return this.title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public final ByteBuffer getBlob() {
            return this.blob == null ? null : this.blob.asByteBuffer();
        }

        @Override
        public final Builder blob(SdkBytes blob) {
            this.blob = StandardMemberCopier.copy((SdkBytes)blob);
            return this;
        }

        public final void setBlob(ByteBuffer blob) {
            this.blob(blob == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)blob));
        }

        public final S3Path.Builder getS3Path() {
            return this.s3Path != null ? this.s3Path.toBuilder() : null;
        }

        @Override
        public final Builder s3Path(S3Path s3Path) {
            this.s3Path = s3Path;
            return this;
        }

        public final void setS3Path(S3Path.BuilderImpl s3Path) {
            this.s3Path = s3Path != null ? s3Path.build() : null;
        }

        public final Collection<DocumentAttribute.Builder> getAttributes() {
            if (this.attributes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.attributes != null ? (Collection)this.attributes.stream().map(DocumentAttribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributes(Collection<DocumentAttribute> attributes) {
            this.attributes = DocumentAttributeListCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(DocumentAttribute ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<DocumentAttribute.Builder> ... attributes) {
            this.attributes(Stream.of(attributes).map(c -> (DocumentAttribute)((DocumentAttribute.Builder)DocumentAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttributes(Collection<DocumentAttribute.BuilderImpl> attributes) {
            this.attributes = DocumentAttributeListCopier.copyFromBuilder(attributes);
        }

        public final Collection<Principal.Builder> getAccessControlList() {
            if (this.accessControlList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accessControlList != null ? (Collection)this.accessControlList.stream().map(Principal::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder accessControlList(Collection<Principal> accessControlList) {
            this.accessControlList = PrincipalListCopier.copy(accessControlList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessControlList(Principal ... accessControlList) {
            this.accessControlList(Arrays.asList(accessControlList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessControlList(Consumer<Principal.Builder> ... accessControlList) {
            this.accessControlList(Stream.of(accessControlList).map(c -> (Principal)((Principal.Builder)Principal.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAccessControlList(Collection<Principal.BuilderImpl> accessControlList) {
            this.accessControlList = PrincipalListCopier.copyFromBuilder(accessControlList);
        }

        public final String getContentType() {
            return this.contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public final Builder contentType(ContentType contentType) {
            this.contentType(contentType == null ? null : contentType.toString());
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public Document build() {
            return new Document(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Document> {
        public Builder id(String var1);

        public Builder title(String var1);

        public Builder blob(SdkBytes var1);

        public Builder s3Path(S3Path var1);

        default public Builder s3Path(Consumer<S3Path.Builder> s3Path) {
            return this.s3Path((S3Path)((S3Path.Builder)S3Path.builder().applyMutation(s3Path)).build());
        }

        public Builder attributes(Collection<DocumentAttribute> var1);

        public Builder attributes(DocumentAttribute ... var1);

        public Builder attributes(Consumer<DocumentAttribute.Builder> ... var1);

        public Builder accessControlList(Collection<Principal> var1);

        public Builder accessControlList(Principal ... var1);

        public Builder accessControlList(Consumer<Principal.Builder> ... var1);

        public Builder contentType(String var1);

        public Builder contentType(ContentType var1);
    }
}

