/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum IndexEdition {
    DEVELOPER_EDITION("DEVELOPER_EDITION"),
    ENTERPRISE_EDITION("ENTERPRISE_EDITION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private IndexEdition(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IndexEdition fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(IndexEdition.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IndexEdition> knownValues() {
        return Stream.of(IndexEdition.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

