/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CapacityUnitsConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CapacityUnitsConfiguration> {
    private static final SdkField<Integer> STORAGE_CAPACITY_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CapacityUnitsConfiguration.getter(CapacityUnitsConfiguration::storageCapacityUnits)).setter(CapacityUnitsConfiguration.setter(Builder::storageCapacityUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageCapacityUnits").build()}).build();
    private static final SdkField<Integer> QUERY_CAPACITY_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CapacityUnitsConfiguration.getter(CapacityUnitsConfiguration::queryCapacityUnits)).setter(CapacityUnitsConfiguration.setter(Builder::queryCapacityUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryCapacityUnits").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_CAPACITY_UNITS_FIELD, QUERY_CAPACITY_UNITS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer storageCapacityUnits;
    private final Integer queryCapacityUnits;

    private CapacityUnitsConfiguration(BuilderImpl builder) {
        this.storageCapacityUnits = builder.storageCapacityUnits;
        this.queryCapacityUnits = builder.queryCapacityUnits;
    }

    public Integer storageCapacityUnits() {
        return this.storageCapacityUnits;
    }

    public Integer queryCapacityUnits() {
        return this.queryCapacityUnits;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.storageCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryCapacityUnits());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityUnitsConfiguration)) {
            return false;
        }
        CapacityUnitsConfiguration other = (CapacityUnitsConfiguration)obj;
        return Objects.equals(this.storageCapacityUnits(), other.storageCapacityUnits()) && Objects.equals(this.queryCapacityUnits(), other.queryCapacityUnits());
    }

    public String toString() {
        return ToString.builder((String)"CapacityUnitsConfiguration").add("StorageCapacityUnits", (Object)this.storageCapacityUnits()).add("QueryCapacityUnits", (Object)this.queryCapacityUnits()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StorageCapacityUnits": {
                return Optional.ofNullable(clazz.cast(this.storageCapacityUnits()));
            }
            case "QueryCapacityUnits": {
                return Optional.ofNullable(clazz.cast(this.queryCapacityUnits()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CapacityUnitsConfiguration, T> g) {
        return obj -> g.apply((CapacityUnitsConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer storageCapacityUnits;
        private Integer queryCapacityUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityUnitsConfiguration model) {
            this.storageCapacityUnits(model.storageCapacityUnits);
            this.queryCapacityUnits(model.queryCapacityUnits);
        }

        public final Integer getStorageCapacityUnits() {
            return this.storageCapacityUnits;
        }

        @Override
        public final Builder storageCapacityUnits(Integer storageCapacityUnits) {
            this.storageCapacityUnits = storageCapacityUnits;
            return this;
        }

        public final void setStorageCapacityUnits(Integer storageCapacityUnits) {
            this.storageCapacityUnits = storageCapacityUnits;
        }

        public final Integer getQueryCapacityUnits() {
            return this.queryCapacityUnits;
        }

        @Override
        public final Builder queryCapacityUnits(Integer queryCapacityUnits) {
            this.queryCapacityUnits = queryCapacityUnits;
            return this;
        }

        public final void setQueryCapacityUnits(Integer queryCapacityUnits) {
            this.queryCapacityUnits = queryCapacityUnits;
        }

        public CapacityUnitsConfiguration build() {
            return new CapacityUnitsConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CapacityUnitsConfiguration> {
        public Builder storageCapacityUnits(Integer var1);

        public Builder queryCapacityUnits(Integer var1);
    }
}

