/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.DataSourceSyncJob;
import software.amazon.awssdk.services.kendra.model.DataSourceSyncJobHistoryListCopier;
import software.amazon.awssdk.services.kendra.model.KendraResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDataSourceSyncJobsResponse
extends KendraResponse
implements ToCopyableBuilder<Builder, ListDataSourceSyncJobsResponse> {
    private static final SdkField<List<DataSourceSyncJob>> HISTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListDataSourceSyncJobsResponse.getter(ListDataSourceSyncJobsResponse::history)).setter(ListDataSourceSyncJobsResponse.setter(Builder::history)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("History").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSourceSyncJob::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListDataSourceSyncJobsResponse.getter(ListDataSourceSyncJobsResponse::nextToken)).setter(ListDataSourceSyncJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HISTORY_FIELD, NEXT_TOKEN_FIELD));
    private final List<DataSourceSyncJob> history;
    private final String nextToken;

    private ListDataSourceSyncJobsResponse(BuilderImpl builder) {
        super(builder);
        this.history = builder.history;
        this.nextToken = builder.nextToken;
    }

    public boolean hasHistory() {
        return this.history != null && !(this.history instanceof SdkAutoConstructList);
    }

    public List<DataSourceSyncJob> history() {
        return this.history;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.history());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataSourceSyncJobsResponse)) {
            return false;
        }
        ListDataSourceSyncJobsResponse other = (ListDataSourceSyncJobsResponse)((Object)obj);
        return Objects.equals(this.history(), other.history()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListDataSourceSyncJobsResponse").add("History", this.history()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "History": {
                return Optional.ofNullable(clazz.cast(this.history()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDataSourceSyncJobsResponse, T> g) {
        return obj -> g.apply((ListDataSourceSyncJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KendraResponse.BuilderImpl
    implements Builder {
        private List<DataSourceSyncJob> history = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataSourceSyncJobsResponse model) {
            super(model);
            this.history(model.history);
            this.nextToken(model.nextToken);
        }

        public final Collection<DataSourceSyncJob.Builder> getHistory() {
            return this.history != null ? (Collection)this.history.stream().map(DataSourceSyncJob::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder history(Collection<DataSourceSyncJob> history) {
            this.history = DataSourceSyncJobHistoryListCopier.copy(history);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder history(DataSourceSyncJob ... history) {
            this.history(Arrays.asList(history));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder history(Consumer<DataSourceSyncJob.Builder> ... history) {
            this.history(Stream.of(history).map(c -> (DataSourceSyncJob)((DataSourceSyncJob.Builder)DataSourceSyncJob.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setHistory(Collection<DataSourceSyncJob.BuilderImpl> history) {
            this.history = DataSourceSyncJobHistoryListCopier.copyFromBuilder(history);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDataSourceSyncJobsResponse build() {
            return new ListDataSourceSyncJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KendraResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDataSourceSyncJobsResponse> {
        public Builder history(Collection<DataSourceSyncJob> var1);

        public Builder history(DataSourceSyncJob ... var1);

        public Builder history(Consumer<DataSourceSyncJob.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

