/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kendra.model.AclConfiguration;
import software.amazon.awssdk.services.kendra.model.ColumnConfiguration;
import software.amazon.awssdk.services.kendra.model.ConnectionConfiguration;
import software.amazon.awssdk.services.kendra.model.DataSourceVpcConfiguration;
import software.amazon.awssdk.services.kendra.model.DatabaseEngineType;
import software.amazon.awssdk.services.kendra.model.SqlConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DatabaseConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DatabaseConfiguration> {
    private static final SdkField<String> DATABASE_ENGINE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DatabaseConfiguration.getter(DatabaseConfiguration::databaseEngineTypeAsString)).setter(DatabaseConfiguration.setter(Builder::databaseEngineType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseEngineType").build()}).build();
    private static final SdkField<ConnectionConfiguration> CONNECTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DatabaseConfiguration.getter(DatabaseConfiguration::connectionConfiguration)).setter(DatabaseConfiguration.setter(Builder::connectionConfiguration)).constructor(ConnectionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionConfiguration").build()}).build();
    private static final SdkField<DataSourceVpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DatabaseConfiguration.getter(DatabaseConfiguration::vpcConfiguration)).setter(DatabaseConfiguration.setter(Builder::vpcConfiguration)).constructor(DataSourceVpcConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfiguration").build()}).build();
    private static final SdkField<ColumnConfiguration> COLUMN_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DatabaseConfiguration.getter(DatabaseConfiguration::columnConfiguration)).setter(DatabaseConfiguration.setter(Builder::columnConfiguration)).constructor(ColumnConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnConfiguration").build()}).build();
    private static final SdkField<AclConfiguration> ACL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DatabaseConfiguration.getter(DatabaseConfiguration::aclConfiguration)).setter(DatabaseConfiguration.setter(Builder::aclConfiguration)).constructor(AclConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AclConfiguration").build()}).build();
    private static final SdkField<SqlConfiguration> SQL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DatabaseConfiguration.getter(DatabaseConfiguration::sqlConfiguration)).setter(DatabaseConfiguration.setter(Builder::sqlConfiguration)).constructor(SqlConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqlConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_ENGINE_TYPE_FIELD, CONNECTION_CONFIGURATION_FIELD, VPC_CONFIGURATION_FIELD, COLUMN_CONFIGURATION_FIELD, ACL_CONFIGURATION_FIELD, SQL_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String databaseEngineType;
    private final ConnectionConfiguration connectionConfiguration;
    private final DataSourceVpcConfiguration vpcConfiguration;
    private final ColumnConfiguration columnConfiguration;
    private final AclConfiguration aclConfiguration;
    private final SqlConfiguration sqlConfiguration;

    private DatabaseConfiguration(BuilderImpl builder) {
        this.databaseEngineType = builder.databaseEngineType;
        this.connectionConfiguration = builder.connectionConfiguration;
        this.vpcConfiguration = builder.vpcConfiguration;
        this.columnConfiguration = builder.columnConfiguration;
        this.aclConfiguration = builder.aclConfiguration;
        this.sqlConfiguration = builder.sqlConfiguration;
    }

    public DatabaseEngineType databaseEngineType() {
        return DatabaseEngineType.fromValue(this.databaseEngineType);
    }

    public String databaseEngineTypeAsString() {
        return this.databaseEngineType;
    }

    public ConnectionConfiguration connectionConfiguration() {
        return this.connectionConfiguration;
    }

    public DataSourceVpcConfiguration vpcConfiguration() {
        return this.vpcConfiguration;
    }

    public ColumnConfiguration columnConfiguration() {
        return this.columnConfiguration;
    }

    public AclConfiguration aclConfiguration() {
        return this.aclConfiguration;
    }

    public SqlConfiguration sqlConfiguration() {
        return this.sqlConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseEngineTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.columnConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.aclConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.sqlConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatabaseConfiguration)) {
            return false;
        }
        DatabaseConfiguration other = (DatabaseConfiguration)obj;
        return Objects.equals(this.databaseEngineTypeAsString(), other.databaseEngineTypeAsString()) && Objects.equals(this.connectionConfiguration(), other.connectionConfiguration()) && Objects.equals(this.vpcConfiguration(), other.vpcConfiguration()) && Objects.equals(this.columnConfiguration(), other.columnConfiguration()) && Objects.equals(this.aclConfiguration(), other.aclConfiguration()) && Objects.equals(this.sqlConfiguration(), other.sqlConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"DatabaseConfiguration").add("DatabaseEngineType", (Object)this.databaseEngineTypeAsString()).add("ConnectionConfiguration", (Object)this.connectionConfiguration()).add("VpcConfiguration", (Object)this.vpcConfiguration()).add("ColumnConfiguration", (Object)this.columnConfiguration()).add("AclConfiguration", (Object)this.aclConfiguration()).add("SqlConfiguration", (Object)this.sqlConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatabaseEngineType": {
                return Optional.ofNullable(clazz.cast(this.databaseEngineTypeAsString()));
            }
            case "ConnectionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.connectionConfiguration()));
            }
            case "VpcConfiguration": {
                return Optional.ofNullable(clazz.cast(this.vpcConfiguration()));
            }
            case "ColumnConfiguration": {
                return Optional.ofNullable(clazz.cast(this.columnConfiguration()));
            }
            case "AclConfiguration": {
                return Optional.ofNullable(clazz.cast(this.aclConfiguration()));
            }
            case "SqlConfiguration": {
                return Optional.ofNullable(clazz.cast(this.sqlConfiguration()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatabaseConfiguration, T> g) {
        return obj -> g.apply((DatabaseConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String databaseEngineType;
        private ConnectionConfiguration connectionConfiguration;
        private DataSourceVpcConfiguration vpcConfiguration;
        private ColumnConfiguration columnConfiguration;
        private AclConfiguration aclConfiguration;
        private SqlConfiguration sqlConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DatabaseConfiguration model) {
            this.databaseEngineType(model.databaseEngineType);
            this.connectionConfiguration(model.connectionConfiguration);
            this.vpcConfiguration(model.vpcConfiguration);
            this.columnConfiguration(model.columnConfiguration);
            this.aclConfiguration(model.aclConfiguration);
            this.sqlConfiguration(model.sqlConfiguration);
        }

        public final String getDatabaseEngineType() {
            return this.databaseEngineType;
        }

        @Override
        public final Builder databaseEngineType(String databaseEngineType) {
            this.databaseEngineType = databaseEngineType;
            return this;
        }

        @Override
        public final Builder databaseEngineType(DatabaseEngineType databaseEngineType) {
            this.databaseEngineType(databaseEngineType == null ? null : databaseEngineType.toString());
            return this;
        }

        public final void setDatabaseEngineType(String databaseEngineType) {
            this.databaseEngineType = databaseEngineType;
        }

        public final ConnectionConfiguration.Builder getConnectionConfiguration() {
            return this.connectionConfiguration != null ? this.connectionConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder connectionConfiguration(ConnectionConfiguration connectionConfiguration) {
            this.connectionConfiguration = connectionConfiguration;
            return this;
        }

        public final void setConnectionConfiguration(ConnectionConfiguration.BuilderImpl connectionConfiguration) {
            this.connectionConfiguration = connectionConfiguration != null ? connectionConfiguration.build() : null;
        }

        public final DataSourceVpcConfiguration.Builder getVpcConfiguration() {
            return this.vpcConfiguration != null ? this.vpcConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfiguration(DataSourceVpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        public final void setVpcConfiguration(DataSourceVpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        public final ColumnConfiguration.Builder getColumnConfiguration() {
            return this.columnConfiguration != null ? this.columnConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder columnConfiguration(ColumnConfiguration columnConfiguration) {
            this.columnConfiguration = columnConfiguration;
            return this;
        }

        public final void setColumnConfiguration(ColumnConfiguration.BuilderImpl columnConfiguration) {
            this.columnConfiguration = columnConfiguration != null ? columnConfiguration.build() : null;
        }

        public final AclConfiguration.Builder getAclConfiguration() {
            return this.aclConfiguration != null ? this.aclConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder aclConfiguration(AclConfiguration aclConfiguration) {
            this.aclConfiguration = aclConfiguration;
            return this;
        }

        public final void setAclConfiguration(AclConfiguration.BuilderImpl aclConfiguration) {
            this.aclConfiguration = aclConfiguration != null ? aclConfiguration.build() : null;
        }

        public final SqlConfiguration.Builder getSqlConfiguration() {
            return this.sqlConfiguration != null ? this.sqlConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder sqlConfiguration(SqlConfiguration sqlConfiguration) {
            this.sqlConfiguration = sqlConfiguration;
            return this;
        }

        public final void setSqlConfiguration(SqlConfiguration.BuilderImpl sqlConfiguration) {
            this.sqlConfiguration = sqlConfiguration != null ? sqlConfiguration.build() : null;
        }

        public DatabaseConfiguration build() {
            return new DatabaseConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DatabaseConfiguration> {
        public Builder databaseEngineType(String var1);

        public Builder databaseEngineType(DatabaseEngineType var1);

        public Builder connectionConfiguration(ConnectionConfiguration var1);

        default public Builder connectionConfiguration(Consumer<ConnectionConfiguration.Builder> connectionConfiguration) {
            return this.connectionConfiguration((ConnectionConfiguration)((ConnectionConfiguration.Builder)ConnectionConfiguration.builder().applyMutation(connectionConfiguration)).build());
        }

        public Builder vpcConfiguration(DataSourceVpcConfiguration var1);

        default public Builder vpcConfiguration(Consumer<DataSourceVpcConfiguration.Builder> vpcConfiguration) {
            return this.vpcConfiguration((DataSourceVpcConfiguration)((DataSourceVpcConfiguration.Builder)DataSourceVpcConfiguration.builder().applyMutation(vpcConfiguration)).build());
        }

        public Builder columnConfiguration(ColumnConfiguration var1);

        default public Builder columnConfiguration(Consumer<ColumnConfiguration.Builder> columnConfiguration) {
            return this.columnConfiguration((ColumnConfiguration)((ColumnConfiguration.Builder)ColumnConfiguration.builder().applyMutation(columnConfiguration)).build());
        }

        public Builder aclConfiguration(AclConfiguration var1);

        default public Builder aclConfiguration(Consumer<AclConfiguration.Builder> aclConfiguration) {
            return this.aclConfiguration((AclConfiguration)((AclConfiguration.Builder)AclConfiguration.builder().applyMutation(aclConfiguration)).build());
        }

        public Builder sqlConfiguration(SqlConfiguration var1);

        default public Builder sqlConfiguration(Consumer<SqlConfiguration.Builder> sqlConfiguration) {
            return this.sqlConfiguration((SqlConfiguration)((SqlConfiguration.Builder)SqlConfiguration.builder().applyMutation(sqlConfiguration)).build());
        }
    }
}

