/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.DataSourceInclusionsExclusionsStringsCopier;
import software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping;
import software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMappingListCopier;
import software.amazon.awssdk.services.kendra.model.OneDriveUsers;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OneDriveConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OneDriveConfiguration> {
    private static final SdkField<String> TENANT_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OneDriveConfiguration.getter(OneDriveConfiguration::tenantDomain)).setter(OneDriveConfiguration.setter(Builder::tenantDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantDomain").build()}).build();
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OneDriveConfiguration.getter(OneDriveConfiguration::secretArn)).setter(OneDriveConfiguration.setter(Builder::secretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()}).build();
    private static final SdkField<OneDriveUsers> ONE_DRIVE_USERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(OneDriveConfiguration.getter(OneDriveConfiguration::oneDriveUsers)).setter(OneDriveConfiguration.setter(Builder::oneDriveUsers)).constructor(OneDriveUsers::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OneDriveUsers").build()}).build();
    private static final SdkField<List<String>> INCLUSION_PATTERNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(OneDriveConfiguration.getter(OneDriveConfiguration::inclusionPatterns)).setter(OneDriveConfiguration.setter(Builder::inclusionPatterns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InclusionPatterns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXCLUSION_PATTERNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(OneDriveConfiguration.getter(OneDriveConfiguration::exclusionPatterns)).setter(OneDriveConfiguration.setter(Builder::exclusionPatterns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusionPatterns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DataSourceToIndexFieldMapping>> FIELD_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(OneDriveConfiguration.getter(OneDriveConfiguration::fieldMappings)).setter(OneDriveConfiguration.setter(Builder::fieldMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSourceToIndexFieldMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TENANT_DOMAIN_FIELD, SECRET_ARN_FIELD, ONE_DRIVE_USERS_FIELD, INCLUSION_PATTERNS_FIELD, EXCLUSION_PATTERNS_FIELD, FIELD_MAPPINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String tenantDomain;
    private final String secretArn;
    private final OneDriveUsers oneDriveUsers;
    private final List<String> inclusionPatterns;
    private final List<String> exclusionPatterns;
    private final List<DataSourceToIndexFieldMapping> fieldMappings;

    private OneDriveConfiguration(BuilderImpl builder) {
        this.tenantDomain = builder.tenantDomain;
        this.secretArn = builder.secretArn;
        this.oneDriveUsers = builder.oneDriveUsers;
        this.inclusionPatterns = builder.inclusionPatterns;
        this.exclusionPatterns = builder.exclusionPatterns;
        this.fieldMappings = builder.fieldMappings;
    }

    public String tenantDomain() {
        return this.tenantDomain;
    }

    public String secretArn() {
        return this.secretArn;
    }

    public OneDriveUsers oneDriveUsers() {
        return this.oneDriveUsers;
    }

    public boolean hasInclusionPatterns() {
        return this.inclusionPatterns != null && !(this.inclusionPatterns instanceof SdkAutoConstructList);
    }

    public List<String> inclusionPatterns() {
        return this.inclusionPatterns;
    }

    public boolean hasExclusionPatterns() {
        return this.exclusionPatterns != null && !(this.exclusionPatterns instanceof SdkAutoConstructList);
    }

    public List<String> exclusionPatterns() {
        return this.exclusionPatterns;
    }

    public boolean hasFieldMappings() {
        return this.fieldMappings != null && !(this.fieldMappings instanceof SdkAutoConstructList);
    }

    public List<DataSourceToIndexFieldMapping> fieldMappings() {
        return this.fieldMappings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tenantDomain());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.oneDriveUsers());
        hashCode = 31 * hashCode + Objects.hashCode(this.inclusionPatterns());
        hashCode = 31 * hashCode + Objects.hashCode(this.exclusionPatterns());
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldMappings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OneDriveConfiguration)) {
            return false;
        }
        OneDriveConfiguration other = (OneDriveConfiguration)obj;
        return Objects.equals(this.tenantDomain(), other.tenantDomain()) && Objects.equals(this.secretArn(), other.secretArn()) && Objects.equals(this.oneDriveUsers(), other.oneDriveUsers()) && Objects.equals(this.inclusionPatterns(), other.inclusionPatterns()) && Objects.equals(this.exclusionPatterns(), other.exclusionPatterns()) && Objects.equals(this.fieldMappings(), other.fieldMappings());
    }

    public String toString() {
        return ToString.builder((String)"OneDriveConfiguration").add("TenantDomain", (Object)this.tenantDomain()).add("SecretArn", (Object)this.secretArn()).add("OneDriveUsers", (Object)this.oneDriveUsers()).add("InclusionPatterns", this.inclusionPatterns()).add("ExclusionPatterns", this.exclusionPatterns()).add("FieldMappings", this.fieldMappings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TenantDomain": {
                return Optional.ofNullable(clazz.cast(this.tenantDomain()));
            }
            case "SecretArn": {
                return Optional.ofNullable(clazz.cast(this.secretArn()));
            }
            case "OneDriveUsers": {
                return Optional.ofNullable(clazz.cast(this.oneDriveUsers()));
            }
            case "InclusionPatterns": {
                return Optional.ofNullable(clazz.cast(this.inclusionPatterns()));
            }
            case "ExclusionPatterns": {
                return Optional.ofNullable(clazz.cast(this.exclusionPatterns()));
            }
            case "FieldMappings": {
                return Optional.ofNullable(clazz.cast(this.fieldMappings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OneDriveConfiguration, T> g) {
        return obj -> g.apply((OneDriveConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String tenantDomain;
        private String secretArn;
        private OneDriveUsers oneDriveUsers;
        private List<String> inclusionPatterns = DefaultSdkAutoConstructList.getInstance();
        private List<String> exclusionPatterns = DefaultSdkAutoConstructList.getInstance();
        private List<DataSourceToIndexFieldMapping> fieldMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OneDriveConfiguration model) {
            this.tenantDomain(model.tenantDomain);
            this.secretArn(model.secretArn);
            this.oneDriveUsers(model.oneDriveUsers);
            this.inclusionPatterns(model.inclusionPatterns);
            this.exclusionPatterns(model.exclusionPatterns);
            this.fieldMappings(model.fieldMappings);
        }

        public final String getTenantDomain() {
            return this.tenantDomain;
        }

        @Override
        public final Builder tenantDomain(String tenantDomain) {
            this.tenantDomain = tenantDomain;
            return this;
        }

        public final void setTenantDomain(String tenantDomain) {
            this.tenantDomain = tenantDomain;
        }

        public final String getSecretArn() {
            return this.secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        public final OneDriveUsers.Builder getOneDriveUsers() {
            return this.oneDriveUsers != null ? this.oneDriveUsers.toBuilder() : null;
        }

        @Override
        public final Builder oneDriveUsers(OneDriveUsers oneDriveUsers) {
            this.oneDriveUsers = oneDriveUsers;
            return this;
        }

        public final void setOneDriveUsers(OneDriveUsers.BuilderImpl oneDriveUsers) {
            this.oneDriveUsers = oneDriveUsers != null ? oneDriveUsers.build() : null;
        }

        public final Collection<String> getInclusionPatterns() {
            return this.inclusionPatterns;
        }

        @Override
        public final Builder inclusionPatterns(Collection<String> inclusionPatterns) {
            this.inclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(inclusionPatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inclusionPatterns(String ... inclusionPatterns) {
            this.inclusionPatterns(Arrays.asList(inclusionPatterns));
            return this;
        }

        public final void setInclusionPatterns(Collection<String> inclusionPatterns) {
            this.inclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(inclusionPatterns);
        }

        public final Collection<String> getExclusionPatterns() {
            return this.exclusionPatterns;
        }

        @Override
        public final Builder exclusionPatterns(Collection<String> exclusionPatterns) {
            this.exclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(exclusionPatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclusionPatterns(String ... exclusionPatterns) {
            this.exclusionPatterns(Arrays.asList(exclusionPatterns));
            return this;
        }

        public final void setExclusionPatterns(Collection<String> exclusionPatterns) {
            this.exclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(exclusionPatterns);
        }

        public final Collection<DataSourceToIndexFieldMapping.Builder> getFieldMappings() {
            return this.fieldMappings != null ? (Collection)this.fieldMappings.stream().map(DataSourceToIndexFieldMapping::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder fieldMappings(Collection<DataSourceToIndexFieldMapping> fieldMappings) {
            this.fieldMappings = DataSourceToIndexFieldMappingListCopier.copy(fieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldMappings(DataSourceToIndexFieldMapping ... fieldMappings) {
            this.fieldMappings(Arrays.asList(fieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... fieldMappings) {
            this.fieldMappings(Stream.of(fieldMappings).map(c -> (DataSourceToIndexFieldMapping)((DataSourceToIndexFieldMapping.Builder)DataSourceToIndexFieldMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFieldMappings(Collection<DataSourceToIndexFieldMapping.BuilderImpl> fieldMappings) {
            this.fieldMappings = DataSourceToIndexFieldMappingListCopier.copyFromBuilder(fieldMappings);
        }

        public OneDriveConfiguration build() {
            return new OneDriveConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OneDriveConfiguration> {
        public Builder tenantDomain(String var1);

        public Builder secretArn(String var1);

        public Builder oneDriveUsers(OneDriveUsers var1);

        default public Builder oneDriveUsers(Consumer<OneDriveUsers.Builder> oneDriveUsers) {
            return this.oneDriveUsers((OneDriveUsers)((OneDriveUsers.Builder)OneDriveUsers.builder().applyMutation(oneDriveUsers)).build());
        }

        public Builder inclusionPatterns(Collection<String> var1);

        public Builder inclusionPatterns(String ... var1);

        public Builder exclusionPatterns(Collection<String> var1);

        public Builder exclusionPatterns(String ... var1);

        public Builder fieldMappings(Collection<DataSourceToIndexFieldMapping> var1);

        public Builder fieldMappings(DataSourceToIndexFieldMapping ... var1);

        public Builder fieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... var1);
    }
}

