/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafkaconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.kafkaconnect.model.Capacity;
import software.amazon.awssdk.services.kafkaconnect.model.ConnectorConfigurationCopier;
import software.amazon.awssdk.services.kafkaconnect.model.KafkaCluster;
import software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterClientAuthentication;
import software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterEncryptionInTransit;
import software.amazon.awssdk.services.kafkaconnect.model.KafkaConnectRequest;
import software.amazon.awssdk.services.kafkaconnect.model.LogDelivery;
import software.amazon.awssdk.services.kafkaconnect.model.Plugin;
import software.amazon.awssdk.services.kafkaconnect.model.TagsCopier;
import software.amazon.awssdk.services.kafkaconnect.model.WorkerConfiguration;
import software.amazon.awssdk.services.kafkaconnect.model.___listOfPluginCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateConnectorRequest
extends KafkaConnectRequest
implements ToCopyableBuilder<Builder, CreateConnectorRequest> {
    private static final SdkField<Capacity> CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("capacity").getter(CreateConnectorRequest.getter(CreateConnectorRequest::capacity)).setter(CreateConnectorRequest.setter(Builder::capacity)).constructor(Capacity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacity").build()}).build();
    private static final SdkField<Map<String, String>> CONNECTOR_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("connectorConfiguration").getter(CreateConnectorRequest.getter(CreateConnectorRequest::connectorConfiguration)).setter(CreateConnectorRequest.setter(Builder::connectorConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorConfiguration").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CONNECTOR_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorDescription").getter(CreateConnectorRequest.getter(CreateConnectorRequest::connectorDescription)).setter(CreateConnectorRequest.setter(Builder::connectorDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorDescription").build()}).build();
    private static final SdkField<String> CONNECTOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorName").getter(CreateConnectorRequest.getter(CreateConnectorRequest::connectorName)).setter(CreateConnectorRequest.setter(Builder::connectorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorName").build()}).build();
    private static final SdkField<KafkaCluster> KAFKA_CLUSTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("kafkaCluster").getter(CreateConnectorRequest.getter(CreateConnectorRequest::kafkaCluster)).setter(CreateConnectorRequest.setter(Builder::kafkaCluster)).constructor(KafkaCluster::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kafkaCluster").build()}).build();
    private static final SdkField<KafkaClusterClientAuthentication> KAFKA_CLUSTER_CLIENT_AUTHENTICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("kafkaClusterClientAuthentication").getter(CreateConnectorRequest.getter(CreateConnectorRequest::kafkaClusterClientAuthentication)).setter(CreateConnectorRequest.setter(Builder::kafkaClusterClientAuthentication)).constructor(KafkaClusterClientAuthentication::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kafkaClusterClientAuthentication").build()}).build();
    private static final SdkField<KafkaClusterEncryptionInTransit> KAFKA_CLUSTER_ENCRYPTION_IN_TRANSIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("kafkaClusterEncryptionInTransit").getter(CreateConnectorRequest.getter(CreateConnectorRequest::kafkaClusterEncryptionInTransit)).setter(CreateConnectorRequest.setter(Builder::kafkaClusterEncryptionInTransit)).constructor(KafkaClusterEncryptionInTransit::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kafkaClusterEncryptionInTransit").build()}).build();
    private static final SdkField<String> KAFKA_CONNECT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kafkaConnectVersion").getter(CreateConnectorRequest.getter(CreateConnectorRequest::kafkaConnectVersion)).setter(CreateConnectorRequest.setter(Builder::kafkaConnectVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kafkaConnectVersion").build()}).build();
    private static final SdkField<LogDelivery> LOG_DELIVERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("logDelivery").getter(CreateConnectorRequest.getter(CreateConnectorRequest::logDelivery)).setter(CreateConnectorRequest.setter(Builder::logDelivery)).constructor(LogDelivery::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logDelivery").build()}).build();
    private static final SdkField<List<Plugin>> PLUGINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("plugins").getter(CreateConnectorRequest.getter(CreateConnectorRequest::plugins)).setter(CreateConnectorRequest.setter(Builder::plugins)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("plugins").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Plugin::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SERVICE_EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceExecutionRoleArn").getter(CreateConnectorRequest.getter(CreateConnectorRequest::serviceExecutionRoleArn)).setter(CreateConnectorRequest.setter(Builder::serviceExecutionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceExecutionRoleArn").build()}).build();
    private static final SdkField<WorkerConfiguration> WORKER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("workerConfiguration").getter(CreateConnectorRequest.getter(CreateConnectorRequest::workerConfiguration)).setter(CreateConnectorRequest.setter(Builder::workerConfiguration)).constructor(WorkerConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workerConfiguration").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateConnectorRequest.getter(CreateConnectorRequest::tags)).setter(CreateConnectorRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_FIELD, CONNECTOR_CONFIGURATION_FIELD, CONNECTOR_DESCRIPTION_FIELD, CONNECTOR_NAME_FIELD, KAFKA_CLUSTER_FIELD, KAFKA_CLUSTER_CLIENT_AUTHENTICATION_FIELD, KAFKA_CLUSTER_ENCRYPTION_IN_TRANSIT_FIELD, KAFKA_CONNECT_VERSION_FIELD, LOG_DELIVERY_FIELD, PLUGINS_FIELD, SERVICE_EXECUTION_ROLE_ARN_FIELD, WORKER_CONFIGURATION_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateConnectorRequest.memberNameToFieldInitializer();
    private final Capacity capacity;
    private final Map<String, String> connectorConfiguration;
    private final String connectorDescription;
    private final String connectorName;
    private final KafkaCluster kafkaCluster;
    private final KafkaClusterClientAuthentication kafkaClusterClientAuthentication;
    private final KafkaClusterEncryptionInTransit kafkaClusterEncryptionInTransit;
    private final String kafkaConnectVersion;
    private final LogDelivery logDelivery;
    private final List<Plugin> plugins;
    private final String serviceExecutionRoleArn;
    private final WorkerConfiguration workerConfiguration;
    private final Map<String, String> tags;

    private CreateConnectorRequest(BuilderImpl builder) {
        super(builder);
        this.capacity = builder.capacity;
        this.connectorConfiguration = builder.connectorConfiguration;
        this.connectorDescription = builder.connectorDescription;
        this.connectorName = builder.connectorName;
        this.kafkaCluster = builder.kafkaCluster;
        this.kafkaClusterClientAuthentication = builder.kafkaClusterClientAuthentication;
        this.kafkaClusterEncryptionInTransit = builder.kafkaClusterEncryptionInTransit;
        this.kafkaConnectVersion = builder.kafkaConnectVersion;
        this.logDelivery = builder.logDelivery;
        this.plugins = builder.plugins;
        this.serviceExecutionRoleArn = builder.serviceExecutionRoleArn;
        this.workerConfiguration = builder.workerConfiguration;
        this.tags = builder.tags;
    }

    public final Capacity capacity() {
        return this.capacity;
    }

    public final boolean hasConnectorConfiguration() {
        return this.connectorConfiguration != null && !(this.connectorConfiguration instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> connectorConfiguration() {
        return this.connectorConfiguration;
    }

    public final String connectorDescription() {
        return this.connectorDescription;
    }

    public final String connectorName() {
        return this.connectorName;
    }

    public final KafkaCluster kafkaCluster() {
        return this.kafkaCluster;
    }

    public final KafkaClusterClientAuthentication kafkaClusterClientAuthentication() {
        return this.kafkaClusterClientAuthentication;
    }

    public final KafkaClusterEncryptionInTransit kafkaClusterEncryptionInTransit() {
        return this.kafkaClusterEncryptionInTransit;
    }

    public final String kafkaConnectVersion() {
        return this.kafkaConnectVersion;
    }

    public final LogDelivery logDelivery() {
        return this.logDelivery;
    }

    public final boolean hasPlugins() {
        return this.plugins != null && !(this.plugins instanceof SdkAutoConstructList);
    }

    public final List<Plugin> plugins() {
        return this.plugins;
    }

    public final String serviceExecutionRoleArn() {
        return this.serviceExecutionRoleArn;
    }

    public final WorkerConfiguration workerConfiguration() {
        return this.workerConfiguration;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.capacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnectorConfiguration() ? this.connectorConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.kafkaCluster());
        hashCode = 31 * hashCode + Objects.hashCode(this.kafkaClusterClientAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(this.kafkaClusterEncryptionInTransit());
        hashCode = 31 * hashCode + Objects.hashCode(this.kafkaConnectVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.logDelivery());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPlugins() ? this.plugins() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceExecutionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.workerConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConnectorRequest)) {
            return false;
        }
        CreateConnectorRequest other = (CreateConnectorRequest)((Object)obj);
        return Objects.equals(this.capacity(), other.capacity()) && this.hasConnectorConfiguration() == other.hasConnectorConfiguration() && Objects.equals(this.connectorConfiguration(), other.connectorConfiguration()) && Objects.equals(this.connectorDescription(), other.connectorDescription()) && Objects.equals(this.connectorName(), other.connectorName()) && Objects.equals(this.kafkaCluster(), other.kafkaCluster()) && Objects.equals(this.kafkaClusterClientAuthentication(), other.kafkaClusterClientAuthentication()) && Objects.equals(this.kafkaClusterEncryptionInTransit(), other.kafkaClusterEncryptionInTransit()) && Objects.equals(this.kafkaConnectVersion(), other.kafkaConnectVersion()) && Objects.equals(this.logDelivery(), other.logDelivery()) && this.hasPlugins() == other.hasPlugins() && Objects.equals(this.plugins(), other.plugins()) && Objects.equals(this.serviceExecutionRoleArn(), other.serviceExecutionRoleArn()) && Objects.equals(this.workerConfiguration(), other.workerConfiguration()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateConnectorRequest").add("Capacity", (Object)this.capacity()).add("ConnectorConfiguration", (Object)(this.connectorConfiguration() == null ? null : "*** Sensitive Data Redacted ***")).add("ConnectorDescription", (Object)this.connectorDescription()).add("ConnectorName", (Object)this.connectorName()).add("KafkaCluster", (Object)this.kafkaCluster()).add("KafkaClusterClientAuthentication", (Object)this.kafkaClusterClientAuthentication()).add("KafkaClusterEncryptionInTransit", (Object)this.kafkaClusterEncryptionInTransit()).add("KafkaConnectVersion", (Object)this.kafkaConnectVersion()).add("LogDelivery", (Object)this.logDelivery()).add("Plugins", this.hasPlugins() ? this.plugins() : null).add("ServiceExecutionRoleArn", (Object)this.serviceExecutionRoleArn()).add("WorkerConfiguration", (Object)this.workerConfiguration()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "capacity": {
                return Optional.ofNullable(clazz.cast(this.capacity()));
            }
            case "connectorConfiguration": {
                return Optional.ofNullable(clazz.cast(this.connectorConfiguration()));
            }
            case "connectorDescription": {
                return Optional.ofNullable(clazz.cast(this.connectorDescription()));
            }
            case "connectorName": {
                return Optional.ofNullable(clazz.cast(this.connectorName()));
            }
            case "kafkaCluster": {
                return Optional.ofNullable(clazz.cast(this.kafkaCluster()));
            }
            case "kafkaClusterClientAuthentication": {
                return Optional.ofNullable(clazz.cast(this.kafkaClusterClientAuthentication()));
            }
            case "kafkaClusterEncryptionInTransit": {
                return Optional.ofNullable(clazz.cast(this.kafkaClusterEncryptionInTransit()));
            }
            case "kafkaConnectVersion": {
                return Optional.ofNullable(clazz.cast(this.kafkaConnectVersion()));
            }
            case "logDelivery": {
                return Optional.ofNullable(clazz.cast(this.logDelivery()));
            }
            case "plugins": {
                return Optional.ofNullable(clazz.cast(this.plugins()));
            }
            case "serviceExecutionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.serviceExecutionRoleArn()));
            }
            case "workerConfiguration": {
                return Optional.ofNullable(clazz.cast(this.workerConfiguration()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("capacity", CAPACITY_FIELD);
        map.put("connectorConfiguration", CONNECTOR_CONFIGURATION_FIELD);
        map.put("connectorDescription", CONNECTOR_DESCRIPTION_FIELD);
        map.put("connectorName", CONNECTOR_NAME_FIELD);
        map.put("kafkaCluster", KAFKA_CLUSTER_FIELD);
        map.put("kafkaClusterClientAuthentication", KAFKA_CLUSTER_CLIENT_AUTHENTICATION_FIELD);
        map.put("kafkaClusterEncryptionInTransit", KAFKA_CLUSTER_ENCRYPTION_IN_TRANSIT_FIELD);
        map.put("kafkaConnectVersion", KAFKA_CONNECT_VERSION_FIELD);
        map.put("logDelivery", LOG_DELIVERY_FIELD);
        map.put("plugins", PLUGINS_FIELD);
        map.put("serviceExecutionRoleArn", SERVICE_EXECUTION_ROLE_ARN_FIELD);
        map.put("workerConfiguration", WORKER_CONFIGURATION_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateConnectorRequest, T> g) {
        return obj -> g.apply((CreateConnectorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KafkaConnectRequest.BuilderImpl
    implements Builder {
        private Capacity capacity;
        private Map<String, String> connectorConfiguration = DefaultSdkAutoConstructMap.getInstance();
        private String connectorDescription;
        private String connectorName;
        private KafkaCluster kafkaCluster;
        private KafkaClusterClientAuthentication kafkaClusterClientAuthentication;
        private KafkaClusterEncryptionInTransit kafkaClusterEncryptionInTransit;
        private String kafkaConnectVersion;
        private LogDelivery logDelivery;
        private List<Plugin> plugins = DefaultSdkAutoConstructList.getInstance();
        private String serviceExecutionRoleArn;
        private WorkerConfiguration workerConfiguration;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConnectorRequest model) {
            super(model);
            this.capacity(model.capacity);
            this.connectorConfiguration(model.connectorConfiguration);
            this.connectorDescription(model.connectorDescription);
            this.connectorName(model.connectorName);
            this.kafkaCluster(model.kafkaCluster);
            this.kafkaClusterClientAuthentication(model.kafkaClusterClientAuthentication);
            this.kafkaClusterEncryptionInTransit(model.kafkaClusterEncryptionInTransit);
            this.kafkaConnectVersion(model.kafkaConnectVersion);
            this.logDelivery(model.logDelivery);
            this.plugins(model.plugins);
            this.serviceExecutionRoleArn(model.serviceExecutionRoleArn);
            this.workerConfiguration(model.workerConfiguration);
            this.tags(model.tags);
        }

        public final Capacity.Builder getCapacity() {
            return this.capacity != null ? this.capacity.toBuilder() : null;
        }

        public final void setCapacity(Capacity.BuilderImpl capacity) {
            this.capacity = capacity != null ? capacity.build() : null;
        }

        @Override
        public final Builder capacity(Capacity capacity) {
            this.capacity = capacity;
            return this;
        }

        public final Map<String, String> getConnectorConfiguration() {
            if (this.connectorConfiguration instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.connectorConfiguration;
        }

        public final void setConnectorConfiguration(Map<String, String> connectorConfiguration) {
            this.connectorConfiguration = ConnectorConfigurationCopier.copy(connectorConfiguration);
        }

        @Override
        public final Builder connectorConfiguration(Map<String, String> connectorConfiguration) {
            this.connectorConfiguration = ConnectorConfigurationCopier.copy(connectorConfiguration);
            return this;
        }

        public final String getConnectorDescription() {
            return this.connectorDescription;
        }

        public final void setConnectorDescription(String connectorDescription) {
            this.connectorDescription = connectorDescription;
        }

        @Override
        public final Builder connectorDescription(String connectorDescription) {
            this.connectorDescription = connectorDescription;
            return this;
        }

        public final String getConnectorName() {
            return this.connectorName;
        }

        public final void setConnectorName(String connectorName) {
            this.connectorName = connectorName;
        }

        @Override
        public final Builder connectorName(String connectorName) {
            this.connectorName = connectorName;
            return this;
        }

        public final KafkaCluster.Builder getKafkaCluster() {
            return this.kafkaCluster != null ? this.kafkaCluster.toBuilder() : null;
        }

        public final void setKafkaCluster(KafkaCluster.BuilderImpl kafkaCluster) {
            this.kafkaCluster = kafkaCluster != null ? kafkaCluster.build() : null;
        }

        @Override
        public final Builder kafkaCluster(KafkaCluster kafkaCluster) {
            this.kafkaCluster = kafkaCluster;
            return this;
        }

        public final KafkaClusterClientAuthentication.Builder getKafkaClusterClientAuthentication() {
            return this.kafkaClusterClientAuthentication != null ? this.kafkaClusterClientAuthentication.toBuilder() : null;
        }

        public final void setKafkaClusterClientAuthentication(KafkaClusterClientAuthentication.BuilderImpl kafkaClusterClientAuthentication) {
            this.kafkaClusterClientAuthentication = kafkaClusterClientAuthentication != null ? kafkaClusterClientAuthentication.build() : null;
        }

        @Override
        public final Builder kafkaClusterClientAuthentication(KafkaClusterClientAuthentication kafkaClusterClientAuthentication) {
            this.kafkaClusterClientAuthentication = kafkaClusterClientAuthentication;
            return this;
        }

        public final KafkaClusterEncryptionInTransit.Builder getKafkaClusterEncryptionInTransit() {
            return this.kafkaClusterEncryptionInTransit != null ? this.kafkaClusterEncryptionInTransit.toBuilder() : null;
        }

        public final void setKafkaClusterEncryptionInTransit(KafkaClusterEncryptionInTransit.BuilderImpl kafkaClusterEncryptionInTransit) {
            this.kafkaClusterEncryptionInTransit = kafkaClusterEncryptionInTransit != null ? kafkaClusterEncryptionInTransit.build() : null;
        }

        @Override
        public final Builder kafkaClusterEncryptionInTransit(KafkaClusterEncryptionInTransit kafkaClusterEncryptionInTransit) {
            this.kafkaClusterEncryptionInTransit = kafkaClusterEncryptionInTransit;
            return this;
        }

        public final String getKafkaConnectVersion() {
            return this.kafkaConnectVersion;
        }

        public final void setKafkaConnectVersion(String kafkaConnectVersion) {
            this.kafkaConnectVersion = kafkaConnectVersion;
        }

        @Override
        public final Builder kafkaConnectVersion(String kafkaConnectVersion) {
            this.kafkaConnectVersion = kafkaConnectVersion;
            return this;
        }

        public final LogDelivery.Builder getLogDelivery() {
            return this.logDelivery != null ? this.logDelivery.toBuilder() : null;
        }

        public final void setLogDelivery(LogDelivery.BuilderImpl logDelivery) {
            this.logDelivery = logDelivery != null ? logDelivery.build() : null;
        }

        @Override
        public final Builder logDelivery(LogDelivery logDelivery) {
            this.logDelivery = logDelivery;
            return this;
        }

        public final List<Plugin.Builder> getPlugins() {
            List<Plugin.Builder> result = ___listOfPluginCopier.copyToBuilder(this.plugins);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlugins(Collection<Plugin.BuilderImpl> plugins) {
            this.plugins = ___listOfPluginCopier.copyFromBuilder(plugins);
        }

        @Override
        public final Builder plugins(Collection<Plugin> plugins) {
            this.plugins = ___listOfPluginCopier.copy(plugins);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder plugins(Plugin ... plugins) {
            this.plugins(Arrays.asList(plugins));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder plugins(Consumer<Plugin.Builder> ... plugins) {
            this.plugins(Stream.of(plugins).map(c -> (Plugin)((Plugin.Builder)Plugin.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getServiceExecutionRoleArn() {
            return this.serviceExecutionRoleArn;
        }

        public final void setServiceExecutionRoleArn(String serviceExecutionRoleArn) {
            this.serviceExecutionRoleArn = serviceExecutionRoleArn;
        }

        @Override
        public final Builder serviceExecutionRoleArn(String serviceExecutionRoleArn) {
            this.serviceExecutionRoleArn = serviceExecutionRoleArn;
            return this;
        }

        public final WorkerConfiguration.Builder getWorkerConfiguration() {
            return this.workerConfiguration != null ? this.workerConfiguration.toBuilder() : null;
        }

        public final void setWorkerConfiguration(WorkerConfiguration.BuilderImpl workerConfiguration) {
            this.workerConfiguration = workerConfiguration != null ? workerConfiguration.build() : null;
        }

        @Override
        public final Builder workerConfiguration(WorkerConfiguration workerConfiguration) {
            this.workerConfiguration = workerConfiguration;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConnectorRequest build() {
            return new CreateConnectorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KafkaConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateConnectorRequest> {
        public Builder capacity(Capacity var1);

        default public Builder capacity(Consumer<Capacity.Builder> capacity) {
            return this.capacity((Capacity)((Capacity.Builder)Capacity.builder().applyMutation(capacity)).build());
        }

        public Builder connectorConfiguration(Map<String, String> var1);

        public Builder connectorDescription(String var1);

        public Builder connectorName(String var1);

        public Builder kafkaCluster(KafkaCluster var1);

        default public Builder kafkaCluster(Consumer<KafkaCluster.Builder> kafkaCluster) {
            return this.kafkaCluster((KafkaCluster)((KafkaCluster.Builder)KafkaCluster.builder().applyMutation(kafkaCluster)).build());
        }

        public Builder kafkaClusterClientAuthentication(KafkaClusterClientAuthentication var1);

        default public Builder kafkaClusterClientAuthentication(Consumer<KafkaClusterClientAuthentication.Builder> kafkaClusterClientAuthentication) {
            return this.kafkaClusterClientAuthentication((KafkaClusterClientAuthentication)((KafkaClusterClientAuthentication.Builder)KafkaClusterClientAuthentication.builder().applyMutation(kafkaClusterClientAuthentication)).build());
        }

        public Builder kafkaClusterEncryptionInTransit(KafkaClusterEncryptionInTransit var1);

        default public Builder kafkaClusterEncryptionInTransit(Consumer<KafkaClusterEncryptionInTransit.Builder> kafkaClusterEncryptionInTransit) {
            return this.kafkaClusterEncryptionInTransit((KafkaClusterEncryptionInTransit)((KafkaClusterEncryptionInTransit.Builder)KafkaClusterEncryptionInTransit.builder().applyMutation(kafkaClusterEncryptionInTransit)).build());
        }

        public Builder kafkaConnectVersion(String var1);

        public Builder logDelivery(LogDelivery var1);

        default public Builder logDelivery(Consumer<LogDelivery.Builder> logDelivery) {
            return this.logDelivery((LogDelivery)((LogDelivery.Builder)LogDelivery.builder().applyMutation(logDelivery)).build());
        }

        public Builder plugins(Collection<Plugin> var1);

        public Builder plugins(Plugin ... var1);

        public Builder plugins(Consumer<Plugin.Builder> ... var1);

        public Builder serviceExecutionRoleArn(String var1);

        public Builder workerConfiguration(WorkerConfiguration var1);

        default public Builder workerConfiguration(Consumer<WorkerConfiguration.Builder> workerConfiguration) {
            return this.workerConfiguration((WorkerConfiguration)((WorkerConfiguration.Builder)WorkerConfiguration.builder().applyMutation(workerConfiguration)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

