/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafkaconnect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ConnectorOperationStepType {
    INITIALIZE_UPDATE("INITIALIZE_UPDATE"),
    FINALIZE_UPDATE("FINALIZE_UPDATE"),
    UPDATE_WORKER_SETTING("UPDATE_WORKER_SETTING"),
    UPDATE_CONNECTOR_CONFIGURATION("UPDATE_CONNECTOR_CONFIGURATION"),
    VALIDATE_UPDATE("VALIDATE_UPDATE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConnectorOperationStepType> VALUE_MAP;
    private final String value;

    private ConnectorOperationStepType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConnectorOperationStepType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConnectorOperationStepType> knownValues() {
        EnumSet<ConnectorOperationStepType> knownValues = EnumSet.allOf(ConnectorOperationStepType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ConnectorOperationStepType.class, ConnectorOperationStepType::toString);
    }
}

