/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafkaconnect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kafkaconnect.model.CustomPluginContentType;
import software.amazon.awssdk.services.kafkaconnect.model.CustomPluginFileDescription;
import software.amazon.awssdk.services.kafkaconnect.model.CustomPluginLocationDescription;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomPluginRevisionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomPluginRevisionSummary> {
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentType").getter(CustomPluginRevisionSummary.getter(CustomPluginRevisionSummary::contentTypeAsString)).setter(CustomPluginRevisionSummary.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentType").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(CustomPluginRevisionSummary.getter(CustomPluginRevisionSummary::creationTime)).setter(CustomPluginRevisionSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CustomPluginRevisionSummary.getter(CustomPluginRevisionSummary::description)).setter(CustomPluginRevisionSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<CustomPluginFileDescription> FILE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("fileDescription").getter(CustomPluginRevisionSummary.getter(CustomPluginRevisionSummary::fileDescription)).setter(CustomPluginRevisionSummary.setter(Builder::fileDescription)).constructor(CustomPluginFileDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileDescription").build()}).build();
    private static final SdkField<CustomPluginLocationDescription> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("location").getter(CustomPluginRevisionSummary.getter(CustomPluginRevisionSummary::location)).setter(CustomPluginRevisionSummary.setter(Builder::location)).constructor(CustomPluginLocationDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final SdkField<Long> REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("revision").getter(CustomPluginRevisionSummary.getter(CustomPluginRevisionSummary::revision)).setter(CustomPluginRevisionSummary.setter(Builder::revision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revision").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_TYPE_FIELD, CREATION_TIME_FIELD, DESCRIPTION_FIELD, FILE_DESCRIPTION_FIELD, LOCATION_FIELD, REVISION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String contentType;
    private final Instant creationTime;
    private final String description;
    private final CustomPluginFileDescription fileDescription;
    private final CustomPluginLocationDescription location;
    private final Long revision;

    private CustomPluginRevisionSummary(BuilderImpl builder) {
        this.contentType = builder.contentType;
        this.creationTime = builder.creationTime;
        this.description = builder.description;
        this.fileDescription = builder.fileDescription;
        this.location = builder.location;
        this.revision = builder.revision;
    }

    public final CustomPluginContentType contentType() {
        return CustomPluginContentType.fromValue(this.contentType);
    }

    public final String contentTypeAsString() {
        return this.contentType;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String description() {
        return this.description;
    }

    public final CustomPluginFileDescription fileDescription() {
        return this.fileDescription;
    }

    public final CustomPluginLocationDescription location() {
        return this.location;
    }

    public final Long revision() {
        return this.revision;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.contentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.revision());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomPluginRevisionSummary)) {
            return false;
        }
        CustomPluginRevisionSummary other = (CustomPluginRevisionSummary)obj;
        return Objects.equals(this.contentTypeAsString(), other.contentTypeAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.fileDescription(), other.fileDescription()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.revision(), other.revision());
    }

    public final String toString() {
        return ToString.builder((String)"CustomPluginRevisionSummary").add("ContentType", (Object)this.contentTypeAsString()).add("CreationTime", (Object)this.creationTime()).add("Description", (Object)this.description()).add("FileDescription", (Object)this.fileDescription()).add("Location", (Object)this.location()).add("Revision", (Object)this.revision()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "contentType": {
                return Optional.ofNullable(clazz.cast(this.contentTypeAsString()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "fileDescription": {
                return Optional.ofNullable(clazz.cast(this.fileDescription()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "revision": {
                return Optional.ofNullable(clazz.cast(this.revision()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomPluginRevisionSummary, T> g) {
        return obj -> g.apply((CustomPluginRevisionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String contentType;
        private Instant creationTime;
        private String description;
        private CustomPluginFileDescription fileDescription;
        private CustomPluginLocationDescription location;
        private Long revision;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomPluginRevisionSummary model) {
            this.contentType(model.contentType);
            this.creationTime(model.creationTime);
            this.description(model.description);
            this.fileDescription(model.fileDescription);
            this.location(model.location);
            this.revision(model.revision);
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public final Builder contentType(CustomPluginContentType contentType) {
            this.contentType(contentType == null ? null : contentType.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final CustomPluginFileDescription.Builder getFileDescription() {
            return this.fileDescription != null ? this.fileDescription.toBuilder() : null;
        }

        public final void setFileDescription(CustomPluginFileDescription.BuilderImpl fileDescription) {
            this.fileDescription = fileDescription != null ? fileDescription.build() : null;
        }

        @Override
        public final Builder fileDescription(CustomPluginFileDescription fileDescription) {
            this.fileDescription = fileDescription;
            return this;
        }

        public final CustomPluginLocationDescription.Builder getLocation() {
            return this.location != null ? this.location.toBuilder() : null;
        }

        public final void setLocation(CustomPluginLocationDescription.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        @Override
        public final Builder location(CustomPluginLocationDescription location) {
            this.location = location;
            return this;
        }

        public final Long getRevision() {
            return this.revision;
        }

        public final void setRevision(Long revision) {
            this.revision = revision;
        }

        @Override
        public final Builder revision(Long revision) {
            this.revision = revision;
            return this;
        }

        public CustomPluginRevisionSummary build() {
            return new CustomPluginRevisionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomPluginRevisionSummary> {
        public Builder contentType(String var1);

        public Builder contentType(CustomPluginContentType var1);

        public Builder creationTime(Instant var1);

        public Builder description(String var1);

        public Builder fileDescription(CustomPluginFileDescription var1);

        default public Builder fileDescription(Consumer<CustomPluginFileDescription.Builder> fileDescription) {
            return this.fileDescription((CustomPluginFileDescription)((CustomPluginFileDescription.Builder)CustomPluginFileDescription.builder().applyMutation(fileDescription)).build());
        }

        public Builder location(CustomPluginLocationDescription var1);

        default public Builder location(Consumer<CustomPluginLocationDescription.Builder> location) {
            return this.location((CustomPluginLocationDescription)((CustomPluginLocationDescription.Builder)CustomPluginLocationDescription.builder().applyMutation(location)).build());
        }

        public Builder revision(Long var1);
    }
}

