/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafkaconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kafkaconnect.KafkaConnectClient;
import software.amazon.awssdk.services.kafkaconnect.model.CustomPluginSummary;
import software.amazon.awssdk.services.kafkaconnect.model.ListCustomPluginsRequest;
import software.amazon.awssdk.services.kafkaconnect.model.ListCustomPluginsResponse;

public class ListCustomPluginsIterable
implements SdkIterable<ListCustomPluginsResponse> {
    private final KafkaConnectClient client;
    private final ListCustomPluginsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCustomPluginsIterable(KafkaConnectClient client, ListCustomPluginsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListCustomPluginsResponseFetcher();
    }

    public Iterator<ListCustomPluginsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CustomPluginSummary> customPlugins() {
        Function<ListCustomPluginsResponse, Iterator> getIterator = response -> {
            if (response != null && response.customPlugins() != null) {
                return response.customPlugins().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCustomPluginsResponseFetcher
    implements SyncPageFetcher<ListCustomPluginsResponse> {
        private ListCustomPluginsResponseFetcher() {
        }

        public boolean hasNextPage(ListCustomPluginsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCustomPluginsResponse nextPage(ListCustomPluginsResponse previousPage) {
            if (previousPage == null) {
                return ListCustomPluginsIterable.this.client.listCustomPlugins(ListCustomPluginsIterable.this.firstRequest);
            }
            return ListCustomPluginsIterable.this.client.listCustomPlugins((ListCustomPluginsRequest)((Object)ListCustomPluginsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

