/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivschat.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ivschat.model.EventAttributesCopier;
import software.amazon.awssdk.services.ivschat.model.IvschatRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendEventRequest
extends IvschatRequest
implements ToCopyableBuilder<Builder, SendEventRequest> {
    private static final SdkField<String> ROOM_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roomIdentifier").getter(SendEventRequest.getter(SendEventRequest::roomIdentifier)).setter(SendEventRequest.setter(Builder::roomIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roomIdentifier").build()}).build();
    private static final SdkField<String> EVENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventName").getter(SendEventRequest.getter(SendEventRequest::eventName)).setter(SendEventRequest.setter(Builder::eventName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventName").build()}).build();
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("attributes").getter(SendEventRequest.getter(SendEventRequest::attributes)).setter(SendEventRequest.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROOM_IDENTIFIER_FIELD, EVENT_NAME_FIELD, ATTRIBUTES_FIELD));
    private final String roomIdentifier;
    private final String eventName;
    private final Map<String, String> attributes;

    private SendEventRequest(BuilderImpl builder) {
        super(builder);
        this.roomIdentifier = builder.roomIdentifier;
        this.eventName = builder.eventName;
        this.attributes = builder.attributes;
    }

    public final String roomIdentifier() {
        return this.roomIdentifier;
    }

    public final String eventName() {
        return this.eventName;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> attributes() {
        return this.attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.roomIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendEventRequest)) {
            return false;
        }
        SendEventRequest other = (SendEventRequest)((Object)obj);
        return Objects.equals(this.roomIdentifier(), other.roomIdentifier()) && Objects.equals(this.eventName(), other.eventName()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes());
    }

    public final String toString() {
        return ToString.builder((String)"SendEventRequest").add("RoomIdentifier", (Object)this.roomIdentifier()).add("EventName", (Object)this.eventName()).add("Attributes", this.hasAttributes() ? this.attributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "roomIdentifier": {
                return Optional.ofNullable(clazz.cast(this.roomIdentifier()));
            }
            case "eventName": {
                return Optional.ofNullable(clazz.cast(this.eventName()));
            }
            case "attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendEventRequest, T> g) {
        return obj -> g.apply((SendEventRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IvschatRequest.BuilderImpl
    implements Builder {
        private String roomIdentifier;
        private String eventName;
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SendEventRequest model) {
            super(model);
            this.roomIdentifier(model.roomIdentifier);
            this.eventName(model.eventName);
            this.attributes(model.attributes);
        }

        public final String getRoomIdentifier() {
            return this.roomIdentifier;
        }

        public final void setRoomIdentifier(String roomIdentifier) {
            this.roomIdentifier = roomIdentifier;
        }

        @Override
        public final Builder roomIdentifier(String roomIdentifier) {
            this.roomIdentifier = roomIdentifier;
            return this;
        }

        public final String getEventName() {
            return this.eventName;
        }

        public final void setEventName(String eventName) {
            this.eventName = eventName;
        }

        @Override
        public final Builder eventName(String eventName) {
            this.eventName = eventName;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (this.attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = EventAttributesCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = EventAttributesCopier.copy(attributes);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendEventRequest build() {
            return new SendEventRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IvschatRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SendEventRequest> {
        public Builder roomIdentifier(String var1);

        public Builder eventName(String var1);

        public Builder attributes(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

