/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivschat.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ivschat.model.IvschatRequest;
import software.amazon.awssdk.services.ivschat.model.LoggingConfigurationIdentifierListCopier;
import software.amazon.awssdk.services.ivschat.model.MessageReviewHandler;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRoomRequest
extends IvschatRequest
implements ToCopyableBuilder<Builder, UpdateRoomRequest> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identifier").getter(UpdateRoomRequest.getter(UpdateRoomRequest::identifier)).setter(UpdateRoomRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()}).build();
    private static final SdkField<List<String>> LOGGING_CONFIGURATION_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("loggingConfigurationIdentifiers").getter(UpdateRoomRequest.getter(UpdateRoomRequest::loggingConfigurationIdentifiers)).setter(UpdateRoomRequest.setter(Builder::loggingConfigurationIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loggingConfigurationIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAXIMUM_MESSAGE_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maximumMessageLength").getter(UpdateRoomRequest.getter(UpdateRoomRequest::maximumMessageLength)).setter(UpdateRoomRequest.setter(Builder::maximumMessageLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumMessageLength").build()}).build();
    private static final SdkField<Integer> MAXIMUM_MESSAGE_RATE_PER_SECOND_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maximumMessageRatePerSecond").getter(UpdateRoomRequest.getter(UpdateRoomRequest::maximumMessageRatePerSecond)).setter(UpdateRoomRequest.setter(Builder::maximumMessageRatePerSecond)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumMessageRatePerSecond").build()}).build();
    private static final SdkField<MessageReviewHandler> MESSAGE_REVIEW_HANDLER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("messageReviewHandler").getter(UpdateRoomRequest.getter(UpdateRoomRequest::messageReviewHandler)).setter(UpdateRoomRequest.setter(Builder::messageReviewHandler)).constructor(MessageReviewHandler::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageReviewHandler").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateRoomRequest.getter(UpdateRoomRequest::name)).setter(UpdateRoomRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD, LOGGING_CONFIGURATION_IDENTIFIERS_FIELD, MAXIMUM_MESSAGE_LENGTH_FIELD, MAXIMUM_MESSAGE_RATE_PER_SECOND_FIELD, MESSAGE_REVIEW_HANDLER_FIELD, NAME_FIELD));
    private final String identifier;
    private final List<String> loggingConfigurationIdentifiers;
    private final Integer maximumMessageLength;
    private final Integer maximumMessageRatePerSecond;
    private final MessageReviewHandler messageReviewHandler;
    private final String name;

    private UpdateRoomRequest(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.loggingConfigurationIdentifiers = builder.loggingConfigurationIdentifiers;
        this.maximumMessageLength = builder.maximumMessageLength;
        this.maximumMessageRatePerSecond = builder.maximumMessageRatePerSecond;
        this.messageReviewHandler = builder.messageReviewHandler;
        this.name = builder.name;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final boolean hasLoggingConfigurationIdentifiers() {
        return this.loggingConfigurationIdentifiers != null && !(this.loggingConfigurationIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> loggingConfigurationIdentifiers() {
        return this.loggingConfigurationIdentifiers;
    }

    public final Integer maximumMessageLength() {
        return this.maximumMessageLength;
    }

    public final Integer maximumMessageRatePerSecond() {
        return this.maximumMessageRatePerSecond;
    }

    public final MessageReviewHandler messageReviewHandler() {
        return this.messageReviewHandler;
    }

    public final String name() {
        return this.name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLoggingConfigurationIdentifiers() ? this.loggingConfigurationIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumMessageLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumMessageRatePerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageReviewHandler());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRoomRequest)) {
            return false;
        }
        UpdateRoomRequest other = (UpdateRoomRequest)((Object)obj);
        return Objects.equals(this.identifier(), other.identifier()) && this.hasLoggingConfigurationIdentifiers() == other.hasLoggingConfigurationIdentifiers() && Objects.equals(this.loggingConfigurationIdentifiers(), other.loggingConfigurationIdentifiers()) && Objects.equals(this.maximumMessageLength(), other.maximumMessageLength()) && Objects.equals(this.maximumMessageRatePerSecond(), other.maximumMessageRatePerSecond()) && Objects.equals(this.messageReviewHandler(), other.messageReviewHandler()) && Objects.equals(this.name(), other.name());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateRoomRequest").add("Identifier", (Object)this.identifier()).add("LoggingConfigurationIdentifiers", this.hasLoggingConfigurationIdentifiers() ? this.loggingConfigurationIdentifiers() : null).add("MaximumMessageLength", (Object)this.maximumMessageLength()).add("MaximumMessageRatePerSecond", (Object)this.maximumMessageRatePerSecond()).add("MessageReviewHandler", (Object)this.messageReviewHandler()).add("Name", (Object)this.name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "loggingConfigurationIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.loggingConfigurationIdentifiers()));
            }
            case "maximumMessageLength": {
                return Optional.ofNullable(clazz.cast(this.maximumMessageLength()));
            }
            case "maximumMessageRatePerSecond": {
                return Optional.ofNullable(clazz.cast(this.maximumMessageRatePerSecond()));
            }
            case "messageReviewHandler": {
                return Optional.ofNullable(clazz.cast(this.messageReviewHandler()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRoomRequest, T> g) {
        return obj -> g.apply((UpdateRoomRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IvschatRequest.BuilderImpl
    implements Builder {
        private String identifier;
        private List<String> loggingConfigurationIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private Integer maximumMessageLength;
        private Integer maximumMessageRatePerSecond;
        private MessageReviewHandler messageReviewHandler;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRoomRequest model) {
            super(model);
            this.identifier(model.identifier);
            this.loggingConfigurationIdentifiers(model.loggingConfigurationIdentifiers);
            this.maximumMessageLength(model.maximumMessageLength);
            this.maximumMessageRatePerSecond(model.maximumMessageRatePerSecond);
            this.messageReviewHandler(model.messageReviewHandler);
            this.name(model.name);
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final Collection<String> getLoggingConfigurationIdentifiers() {
            if (this.loggingConfigurationIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.loggingConfigurationIdentifiers;
        }

        public final void setLoggingConfigurationIdentifiers(Collection<String> loggingConfigurationIdentifiers) {
            this.loggingConfigurationIdentifiers = LoggingConfigurationIdentifierListCopier.copy(loggingConfigurationIdentifiers);
        }

        @Override
        public final Builder loggingConfigurationIdentifiers(Collection<String> loggingConfigurationIdentifiers) {
            this.loggingConfigurationIdentifiers = LoggingConfigurationIdentifierListCopier.copy(loggingConfigurationIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loggingConfigurationIdentifiers(String ... loggingConfigurationIdentifiers) {
            this.loggingConfigurationIdentifiers(Arrays.asList(loggingConfigurationIdentifiers));
            return this;
        }

        public final Integer getMaximumMessageLength() {
            return this.maximumMessageLength;
        }

        public final void setMaximumMessageLength(Integer maximumMessageLength) {
            this.maximumMessageLength = maximumMessageLength;
        }

        @Override
        public final Builder maximumMessageLength(Integer maximumMessageLength) {
            this.maximumMessageLength = maximumMessageLength;
            return this;
        }

        public final Integer getMaximumMessageRatePerSecond() {
            return this.maximumMessageRatePerSecond;
        }

        public final void setMaximumMessageRatePerSecond(Integer maximumMessageRatePerSecond) {
            this.maximumMessageRatePerSecond = maximumMessageRatePerSecond;
        }

        @Override
        public final Builder maximumMessageRatePerSecond(Integer maximumMessageRatePerSecond) {
            this.maximumMessageRatePerSecond = maximumMessageRatePerSecond;
            return this;
        }

        public final MessageReviewHandler.Builder getMessageReviewHandler() {
            return this.messageReviewHandler != null ? this.messageReviewHandler.toBuilder() : null;
        }

        public final void setMessageReviewHandler(MessageReviewHandler.BuilderImpl messageReviewHandler) {
            this.messageReviewHandler = messageReviewHandler != null ? messageReviewHandler.build() : null;
        }

        @Override
        public final Builder messageReviewHandler(MessageReviewHandler messageReviewHandler) {
            this.messageReviewHandler = messageReviewHandler;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRoomRequest build() {
            return new UpdateRoomRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IvschatRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateRoomRequest> {
        public Builder identifier(String var1);

        public Builder loggingConfigurationIdentifiers(Collection<String> var1);

        public Builder loggingConfigurationIdentifiers(String ... var1);

        public Builder maximumMessageLength(Integer var1);

        public Builder maximumMessageRatePerSecond(Integer var1);

        public Builder messageReviewHandler(MessageReviewHandler var1);

        default public Builder messageReviewHandler(Consumer<MessageReviewHandler.Builder> messageReviewHandler) {
            return this.messageReviewHandler((MessageReviewHandler)((MessageReviewHandler.Builder)MessageReviewHandler.builder().applyMutation(messageReviewHandler)).build());
        }

        public Builder name(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

