/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ivs.IvsAsyncClient;
import software.amazon.awssdk.services.ivs.internal.UserAgentUtils;
import software.amazon.awssdk.services.ivs.model.ListPlaybackRestrictionPoliciesRequest;
import software.amazon.awssdk.services.ivs.model.ListPlaybackRestrictionPoliciesResponse;

public class ListPlaybackRestrictionPoliciesPublisher
implements SdkPublisher<ListPlaybackRestrictionPoliciesResponse> {
    private final IvsAsyncClient client;
    private final ListPlaybackRestrictionPoliciesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPlaybackRestrictionPoliciesPublisher(IvsAsyncClient client, ListPlaybackRestrictionPoliciesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPlaybackRestrictionPoliciesPublisher(IvsAsyncClient client, ListPlaybackRestrictionPoliciesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPlaybackRestrictionPoliciesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPlaybackRestrictionPoliciesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListPlaybackRestrictionPoliciesResponseFetcher
    implements AsyncPageFetcher<ListPlaybackRestrictionPoliciesResponse> {
        private ListPlaybackRestrictionPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListPlaybackRestrictionPoliciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPlaybackRestrictionPoliciesResponse> nextPage(ListPlaybackRestrictionPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListPlaybackRestrictionPoliciesPublisher.this.client.listPlaybackRestrictionPolicies(ListPlaybackRestrictionPoliciesPublisher.this.firstRequest);
            }
            return ListPlaybackRestrictionPoliciesPublisher.this.client.listPlaybackRestrictionPolicies((ListPlaybackRestrictionPoliciesRequest)((Object)ListPlaybackRestrictionPoliciesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

