/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ivs.IvsAsyncClient;
import software.amazon.awssdk.services.ivs.model.ListStreamKeysRequest;
import software.amazon.awssdk.services.ivs.model.ListStreamKeysResponse;
import software.amazon.awssdk.services.ivs.model.StreamKeySummary;

public class ListStreamKeysPublisher
implements SdkPublisher<ListStreamKeysResponse> {
    private final IvsAsyncClient client;
    private final ListStreamKeysRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListStreamKeysPublisher(IvsAsyncClient client, ListStreamKeysRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListStreamKeysPublisher(IvsAsyncClient client, ListStreamKeysRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListStreamKeysResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListStreamKeysResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<StreamKeySummary> streamKeys() {
        Function<ListStreamKeysResponse, Iterator> getIterator = response -> {
            if (response != null && response.streamKeys() != null) {
                return response.streamKeys().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListStreamKeysResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListStreamKeysResponseFetcher
    implements AsyncPageFetcher<ListStreamKeysResponse> {
        private ListStreamKeysResponseFetcher() {
        }

        public boolean hasNextPage(ListStreamKeysResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListStreamKeysResponse> nextPage(ListStreamKeysResponse previousPage) {
            if (previousPage == null) {
                return ListStreamKeysPublisher.this.client.listStreamKeys(ListStreamKeysPublisher.this.firstRequest);
            }
            return ListStreamKeysPublisher.this.client.listStreamKeys((ListStreamKeysRequest)((Object)ListStreamKeysPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

