/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessRequest;
import software.amazon.awssdk.services.iotwireless.model.PartnerType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisassociateAwsAccountFromPartnerAccountRequest
extends IotWirelessRequest
implements ToCopyableBuilder<Builder, DisassociateAwsAccountFromPartnerAccountRequest> {
    private static final SdkField<String> PARTNER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PartnerAccountId").getter(DisassociateAwsAccountFromPartnerAccountRequest.getter(DisassociateAwsAccountFromPartnerAccountRequest::partnerAccountId)).setter(DisassociateAwsAccountFromPartnerAccountRequest.setter(Builder::partnerAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("PartnerAccountId").build()}).build();
    private static final SdkField<String> PARTNER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PartnerType").getter(DisassociateAwsAccountFromPartnerAccountRequest.getter(DisassociateAwsAccountFromPartnerAccountRequest::partnerTypeAsString)).setter(DisassociateAwsAccountFromPartnerAccountRequest.setter(Builder::partnerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("partnerType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTNER_ACCOUNT_ID_FIELD, PARTNER_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DisassociateAwsAccountFromPartnerAccountRequest.memberNameToFieldInitializer();
    private final String partnerAccountId;
    private final String partnerType;

    private DisassociateAwsAccountFromPartnerAccountRequest(BuilderImpl builder) {
        super(builder);
        this.partnerAccountId = builder.partnerAccountId;
        this.partnerType = builder.partnerType;
    }

    public final String partnerAccountId() {
        return this.partnerAccountId;
    }

    public final PartnerType partnerType() {
        return PartnerType.fromValue(this.partnerType);
    }

    public final String partnerTypeAsString() {
        return this.partnerType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.partnerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.partnerTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateAwsAccountFromPartnerAccountRequest)) {
            return false;
        }
        DisassociateAwsAccountFromPartnerAccountRequest other = (DisassociateAwsAccountFromPartnerAccountRequest)((Object)obj);
        return Objects.equals(this.partnerAccountId(), other.partnerAccountId()) && Objects.equals(this.partnerTypeAsString(), other.partnerTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DisassociateAwsAccountFromPartnerAccountRequest").add("PartnerAccountId", (Object)this.partnerAccountId()).add("PartnerType", (Object)this.partnerTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PartnerAccountId": {
                return Optional.ofNullable(clazz.cast(this.partnerAccountId()));
            }
            case "PartnerType": {
                return Optional.ofNullable(clazz.cast(this.partnerTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("PartnerAccountId", PARTNER_ACCOUNT_ID_FIELD);
        map.put("partnerType", PARTNER_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisassociateAwsAccountFromPartnerAccountRequest, T> g) {
        return obj -> g.apply((DisassociateAwsAccountFromPartnerAccountRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessRequest.BuilderImpl
    implements Builder {
        private String partnerAccountId;
        private String partnerType;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateAwsAccountFromPartnerAccountRequest model) {
            super(model);
            this.partnerAccountId(model.partnerAccountId);
            this.partnerType(model.partnerType);
        }

        public final String getPartnerAccountId() {
            return this.partnerAccountId;
        }

        public final void setPartnerAccountId(String partnerAccountId) {
            this.partnerAccountId = partnerAccountId;
        }

        @Override
        public final Builder partnerAccountId(String partnerAccountId) {
            this.partnerAccountId = partnerAccountId;
            return this;
        }

        public final String getPartnerType() {
            return this.partnerType;
        }

        public final void setPartnerType(String partnerType) {
            this.partnerType = partnerType;
        }

        @Override
        public final Builder partnerType(String partnerType) {
            this.partnerType = partnerType;
            return this;
        }

        @Override
        public final Builder partnerType(PartnerType partnerType) {
            this.partnerType(partnerType == null ? null : partnerType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateAwsAccountFromPartnerAccountRequest build() {
            return new DisassociateAwsAccountFromPartnerAccountRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotWirelessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DisassociateAwsAccountFromPartnerAccountRequest> {
        public Builder partnerAccountId(String var1);

        public Builder partnerType(String var1);

        public Builder partnerType(PartnerType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

