/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessResponse;
import software.amazon.awssdk.services.iotwireless.model.NetworkAnalyzerConfigurationListCopier;
import software.amazon.awssdk.services.iotwireless.model.NetworkAnalyzerConfigurations;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListNetworkAnalyzerConfigurationsResponse
extends IotWirelessResponse
implements ToCopyableBuilder<Builder, ListNetworkAnalyzerConfigurationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListNetworkAnalyzerConfigurationsResponse.getter(ListNetworkAnalyzerConfigurationsResponse::nextToken)).setter(ListNetworkAnalyzerConfigurationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<NetworkAnalyzerConfigurations>> NETWORK_ANALYZER_CONFIGURATION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NetworkAnalyzerConfigurationList").getter(ListNetworkAnalyzerConfigurationsResponse.getter(ListNetworkAnalyzerConfigurationsResponse::networkAnalyzerConfigurationList)).setter(ListNetworkAnalyzerConfigurationsResponse.setter(Builder::networkAnalyzerConfigurationList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkAnalyzerConfigurationList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NetworkAnalyzerConfigurations::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, NETWORK_ANALYZER_CONFIGURATION_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListNetworkAnalyzerConfigurationsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<NetworkAnalyzerConfigurations> networkAnalyzerConfigurationList;

    private ListNetworkAnalyzerConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.networkAnalyzerConfigurationList = builder.networkAnalyzerConfigurationList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasNetworkAnalyzerConfigurationList() {
        return this.networkAnalyzerConfigurationList != null && !(this.networkAnalyzerConfigurationList instanceof SdkAutoConstructList);
    }

    public final List<NetworkAnalyzerConfigurations> networkAnalyzerConfigurationList() {
        return this.networkAnalyzerConfigurationList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkAnalyzerConfigurationList() ? this.networkAnalyzerConfigurationList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNetworkAnalyzerConfigurationsResponse)) {
            return false;
        }
        ListNetworkAnalyzerConfigurationsResponse other = (ListNetworkAnalyzerConfigurationsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasNetworkAnalyzerConfigurationList() == other.hasNetworkAnalyzerConfigurationList() && Objects.equals(this.networkAnalyzerConfigurationList(), other.networkAnalyzerConfigurationList());
    }

    public final String toString() {
        return ToString.builder((String)"ListNetworkAnalyzerConfigurationsResponse").add("NextToken", (Object)this.nextToken()).add("NetworkAnalyzerConfigurationList", this.hasNetworkAnalyzerConfigurationList() ? this.networkAnalyzerConfigurationList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "NetworkAnalyzerConfigurationList": {
                return Optional.ofNullable(clazz.cast(this.networkAnalyzerConfigurationList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("NetworkAnalyzerConfigurationList", NETWORK_ANALYZER_CONFIGURATION_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListNetworkAnalyzerConfigurationsResponse, T> g) {
        return obj -> g.apply((ListNetworkAnalyzerConfigurationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<NetworkAnalyzerConfigurations> networkAnalyzerConfigurationList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListNetworkAnalyzerConfigurationsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.networkAnalyzerConfigurationList(model.networkAnalyzerConfigurationList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<NetworkAnalyzerConfigurations.Builder> getNetworkAnalyzerConfigurationList() {
            List<NetworkAnalyzerConfigurations.Builder> result = NetworkAnalyzerConfigurationListCopier.copyToBuilder(this.networkAnalyzerConfigurationList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkAnalyzerConfigurationList(Collection<NetworkAnalyzerConfigurations.BuilderImpl> networkAnalyzerConfigurationList) {
            this.networkAnalyzerConfigurationList = NetworkAnalyzerConfigurationListCopier.copyFromBuilder(networkAnalyzerConfigurationList);
        }

        @Override
        public final Builder networkAnalyzerConfigurationList(Collection<NetworkAnalyzerConfigurations> networkAnalyzerConfigurationList) {
            this.networkAnalyzerConfigurationList = NetworkAnalyzerConfigurationListCopier.copy(networkAnalyzerConfigurationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkAnalyzerConfigurationList(NetworkAnalyzerConfigurations ... networkAnalyzerConfigurationList) {
            this.networkAnalyzerConfigurationList(Arrays.asList(networkAnalyzerConfigurationList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkAnalyzerConfigurationList(Consumer<NetworkAnalyzerConfigurations.Builder> ... networkAnalyzerConfigurationList) {
            this.networkAnalyzerConfigurationList(Stream.of(networkAnalyzerConfigurationList).map(c -> (NetworkAnalyzerConfigurations)((NetworkAnalyzerConfigurations.Builder)NetworkAnalyzerConfigurations.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListNetworkAnalyzerConfigurationsResponse build() {
            return new ListNetworkAnalyzerConfigurationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotWirelessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListNetworkAnalyzerConfigurationsResponse> {
        public Builder nextToken(String var1);

        public Builder networkAnalyzerConfigurationList(Collection<NetworkAnalyzerConfigurations> var1);

        public Builder networkAnalyzerConfigurationList(NetworkAnalyzerConfigurations ... var1);

        public Builder networkAnalyzerConfigurationList(Consumer<NetworkAnalyzerConfigurations.Builder> ... var1);
    }
}

