/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotwireless.model.GatewayListMulticastCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ParticipatingGatewaysMulticast
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ParticipatingGatewaysMulticast> {
    private static final SdkField<List<String>> GATEWAY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GatewayList").getter(ParticipatingGatewaysMulticast.getter(ParticipatingGatewaysMulticast::gatewayList)).setter(ParticipatingGatewaysMulticast.setter(Builder::gatewayList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> TRANSMISSION_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TransmissionInterval").getter(ParticipatingGatewaysMulticast.getter(ParticipatingGatewaysMulticast::transmissionInterval)).setter(ParticipatingGatewaysMulticast.setter(Builder::transmissionInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransmissionInterval").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_LIST_FIELD, TRANSMISSION_INTERVAL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ParticipatingGatewaysMulticast.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> gatewayList;
    private final Integer transmissionInterval;

    private ParticipatingGatewaysMulticast(BuilderImpl builder) {
        this.gatewayList = builder.gatewayList;
        this.transmissionInterval = builder.transmissionInterval;
    }

    public final boolean hasGatewayList() {
        return this.gatewayList != null && !(this.gatewayList instanceof SdkAutoConstructList);
    }

    public final List<String> gatewayList() {
        return this.gatewayList;
    }

    public final Integer transmissionInterval() {
        return this.transmissionInterval;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGatewayList() ? this.gatewayList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.transmissionInterval());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParticipatingGatewaysMulticast)) {
            return false;
        }
        ParticipatingGatewaysMulticast other = (ParticipatingGatewaysMulticast)obj;
        return this.hasGatewayList() == other.hasGatewayList() && Objects.equals(this.gatewayList(), other.gatewayList()) && Objects.equals(this.transmissionInterval(), other.transmissionInterval());
    }

    public final String toString() {
        return ToString.builder((String)"ParticipatingGatewaysMulticast").add("GatewayList", this.hasGatewayList() ? this.gatewayList() : null).add("TransmissionInterval", (Object)this.transmissionInterval()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GatewayList": {
                return Optional.ofNullable(clazz.cast(this.gatewayList()));
            }
            case "TransmissionInterval": {
                return Optional.ofNullable(clazz.cast(this.transmissionInterval()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GatewayList", GATEWAY_LIST_FIELD);
        map.put("TransmissionInterval", TRANSMISSION_INTERVAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ParticipatingGatewaysMulticast, T> g) {
        return obj -> g.apply((ParticipatingGatewaysMulticast)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> gatewayList = DefaultSdkAutoConstructList.getInstance();
        private Integer transmissionInterval;

        private BuilderImpl() {
        }

        private BuilderImpl(ParticipatingGatewaysMulticast model) {
            this.gatewayList(model.gatewayList);
            this.transmissionInterval(model.transmissionInterval);
        }

        public final Collection<String> getGatewayList() {
            if (this.gatewayList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.gatewayList;
        }

        public final void setGatewayList(Collection<String> gatewayList) {
            this.gatewayList = GatewayListMulticastCopier.copy(gatewayList);
        }

        @Override
        public final Builder gatewayList(Collection<String> gatewayList) {
            this.gatewayList = GatewayListMulticastCopier.copy(gatewayList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gatewayList(String ... gatewayList) {
            this.gatewayList(Arrays.asList(gatewayList));
            return this;
        }

        public final Integer getTransmissionInterval() {
            return this.transmissionInterval;
        }

        public final void setTransmissionInterval(Integer transmissionInterval) {
            this.transmissionInterval = transmissionInterval;
        }

        @Override
        public final Builder transmissionInterval(Integer transmissionInterval) {
            this.transmissionInterval = transmissionInterval;
            return this;
        }

        public ParticipatingGatewaysMulticast build() {
            return new ParticipatingGatewaysMulticast(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ParticipatingGatewaysMulticast> {
        public Builder gatewayList(Collection<String> var1);

        public Builder gatewayList(String ... var1);

        public Builder transmissionInterval(Integer var1);
    }
}

