/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotwireless.model.LteLocalId;
import software.amazon.awssdk.services.iotwireless.model.LteNmrListCopier;
import software.amazon.awssdk.services.iotwireless.model.LteNmrObj;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LteObj
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LteObj> {
    private static final SdkField<Integer> MCC_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Mcc").getter(LteObj.getter(LteObj::mcc)).setter(LteObj.setter(Builder::mcc)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mcc").build()}).build();
    private static final SdkField<Integer> MNC_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Mnc").getter(LteObj.getter(LteObj::mnc)).setter(LteObj.setter(Builder::mnc)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mnc").build()}).build();
    private static final SdkField<Integer> EUTRAN_CID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EutranCid").getter(LteObj.getter(LteObj::eutranCid)).setter(LteObj.setter(Builder::eutranCid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EutranCid").build()}).build();
    private static final SdkField<Integer> TAC_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Tac").getter(LteObj.getter(LteObj::tac)).setter(LteObj.setter(Builder::tac)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tac").build()}).build();
    private static final SdkField<LteLocalId> LTE_LOCAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LteLocalId").getter(LteObj.getter(LteObj::lteLocalId)).setter(LteObj.setter(Builder::lteLocalId)).constructor(LteLocalId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LteLocalId").build()}).build();
    private static final SdkField<Integer> LTE_TIMING_ADVANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("LteTimingAdvance").getter(LteObj.getter(LteObj::lteTimingAdvance)).setter(LteObj.setter(Builder::lteTimingAdvance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LteTimingAdvance").build()}).build();
    private static final SdkField<Integer> RSRP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Rsrp").getter(LteObj.getter(LteObj::rsrp)).setter(LteObj.setter(Builder::rsrp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rsrp").build()}).build();
    private static final SdkField<Float> RSRQ_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("Rsrq").getter(LteObj.getter(LteObj::rsrq)).setter(LteObj.setter(Builder::rsrq)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rsrq").build()}).build();
    private static final SdkField<Boolean> NR_CAPABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("NrCapable").getter(LteObj.getter(LteObj::nrCapable)).setter(LteObj.setter(Builder::nrCapable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NrCapable").build()}).build();
    private static final SdkField<List<LteNmrObj>> LTE_NMR_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LteNmr").getter(LteObj.getter(LteObj::lteNmr)).setter(LteObj.setter(Builder::lteNmr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LteNmr").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LteNmrObj::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MCC_FIELD, MNC_FIELD, EUTRAN_CID_FIELD, TAC_FIELD, LTE_LOCAL_ID_FIELD, LTE_TIMING_ADVANCE_FIELD, RSRP_FIELD, RSRQ_FIELD, NR_CAPABLE_FIELD, LTE_NMR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LteObj.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer mcc;
    private final Integer mnc;
    private final Integer eutranCid;
    private final Integer tac;
    private final LteLocalId lteLocalId;
    private final Integer lteTimingAdvance;
    private final Integer rsrp;
    private final Float rsrq;
    private final Boolean nrCapable;
    private final List<LteNmrObj> lteNmr;

    private LteObj(BuilderImpl builder) {
        this.mcc = builder.mcc;
        this.mnc = builder.mnc;
        this.eutranCid = builder.eutranCid;
        this.tac = builder.tac;
        this.lteLocalId = builder.lteLocalId;
        this.lteTimingAdvance = builder.lteTimingAdvance;
        this.rsrp = builder.rsrp;
        this.rsrq = builder.rsrq;
        this.nrCapable = builder.nrCapable;
        this.lteNmr = builder.lteNmr;
    }

    public final Integer mcc() {
        return this.mcc;
    }

    public final Integer mnc() {
        return this.mnc;
    }

    public final Integer eutranCid() {
        return this.eutranCid;
    }

    public final Integer tac() {
        return this.tac;
    }

    public final LteLocalId lteLocalId() {
        return this.lteLocalId;
    }

    public final Integer lteTimingAdvance() {
        return this.lteTimingAdvance;
    }

    public final Integer rsrp() {
        return this.rsrp;
    }

    public final Float rsrq() {
        return this.rsrq;
    }

    public final Boolean nrCapable() {
        return this.nrCapable;
    }

    public final boolean hasLteNmr() {
        return this.lteNmr != null && !(this.lteNmr instanceof SdkAutoConstructList);
    }

    public final List<LteNmrObj> lteNmr() {
        return this.lteNmr;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mcc());
        hashCode = 31 * hashCode + Objects.hashCode(this.mnc());
        hashCode = 31 * hashCode + Objects.hashCode(this.eutranCid());
        hashCode = 31 * hashCode + Objects.hashCode(this.tac());
        hashCode = 31 * hashCode + Objects.hashCode(this.lteLocalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lteTimingAdvance());
        hashCode = 31 * hashCode + Objects.hashCode(this.rsrp());
        hashCode = 31 * hashCode + Objects.hashCode(this.rsrq());
        hashCode = 31 * hashCode + Objects.hashCode(this.nrCapable());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLteNmr() ? this.lteNmr() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LteObj)) {
            return false;
        }
        LteObj other = (LteObj)obj;
        return Objects.equals(this.mcc(), other.mcc()) && Objects.equals(this.mnc(), other.mnc()) && Objects.equals(this.eutranCid(), other.eutranCid()) && Objects.equals(this.tac(), other.tac()) && Objects.equals(this.lteLocalId(), other.lteLocalId()) && Objects.equals(this.lteTimingAdvance(), other.lteTimingAdvance()) && Objects.equals(this.rsrp(), other.rsrp()) && Objects.equals(this.rsrq(), other.rsrq()) && Objects.equals(this.nrCapable(), other.nrCapable()) && this.hasLteNmr() == other.hasLteNmr() && Objects.equals(this.lteNmr(), other.lteNmr());
    }

    public final String toString() {
        return ToString.builder((String)"LteObj").add("Mcc", (Object)this.mcc()).add("Mnc", (Object)this.mnc()).add("EutranCid", (Object)this.eutranCid()).add("Tac", (Object)this.tac()).add("LteLocalId", (Object)this.lteLocalId()).add("LteTimingAdvance", (Object)this.lteTimingAdvance()).add("Rsrp", (Object)this.rsrp()).add("Rsrq", (Object)this.rsrq()).add("NrCapable", (Object)this.nrCapable()).add("LteNmr", this.hasLteNmr() ? this.lteNmr() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Mcc": {
                return Optional.ofNullable(clazz.cast(this.mcc()));
            }
            case "Mnc": {
                return Optional.ofNullable(clazz.cast(this.mnc()));
            }
            case "EutranCid": {
                return Optional.ofNullable(clazz.cast(this.eutranCid()));
            }
            case "Tac": {
                return Optional.ofNullable(clazz.cast(this.tac()));
            }
            case "LteLocalId": {
                return Optional.ofNullable(clazz.cast(this.lteLocalId()));
            }
            case "LteTimingAdvance": {
                return Optional.ofNullable(clazz.cast(this.lteTimingAdvance()));
            }
            case "Rsrp": {
                return Optional.ofNullable(clazz.cast(this.rsrp()));
            }
            case "Rsrq": {
                return Optional.ofNullable(clazz.cast(this.rsrq()));
            }
            case "NrCapable": {
                return Optional.ofNullable(clazz.cast(this.nrCapable()));
            }
            case "LteNmr": {
                return Optional.ofNullable(clazz.cast(this.lteNmr()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Mcc", MCC_FIELD);
        map.put("Mnc", MNC_FIELD);
        map.put("EutranCid", EUTRAN_CID_FIELD);
        map.put("Tac", TAC_FIELD);
        map.put("LteLocalId", LTE_LOCAL_ID_FIELD);
        map.put("LteTimingAdvance", LTE_TIMING_ADVANCE_FIELD);
        map.put("Rsrp", RSRP_FIELD);
        map.put("Rsrq", RSRQ_FIELD);
        map.put("NrCapable", NR_CAPABLE_FIELD);
        map.put("LteNmr", LTE_NMR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LteObj, T> g) {
        return obj -> g.apply((LteObj)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer mcc;
        private Integer mnc;
        private Integer eutranCid;
        private Integer tac;
        private LteLocalId lteLocalId;
        private Integer lteTimingAdvance;
        private Integer rsrp;
        private Float rsrq;
        private Boolean nrCapable;
        private List<LteNmrObj> lteNmr = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LteObj model) {
            this.mcc(model.mcc);
            this.mnc(model.mnc);
            this.eutranCid(model.eutranCid);
            this.tac(model.tac);
            this.lteLocalId(model.lteLocalId);
            this.lteTimingAdvance(model.lteTimingAdvance);
            this.rsrp(model.rsrp);
            this.rsrq(model.rsrq);
            this.nrCapable(model.nrCapable);
            this.lteNmr(model.lteNmr);
        }

        public final Integer getMcc() {
            return this.mcc;
        }

        public final void setMcc(Integer mcc) {
            this.mcc = mcc;
        }

        @Override
        public final Builder mcc(Integer mcc) {
            this.mcc = mcc;
            return this;
        }

        public final Integer getMnc() {
            return this.mnc;
        }

        public final void setMnc(Integer mnc) {
            this.mnc = mnc;
        }

        @Override
        public final Builder mnc(Integer mnc) {
            this.mnc = mnc;
            return this;
        }

        public final Integer getEutranCid() {
            return this.eutranCid;
        }

        public final void setEutranCid(Integer eutranCid) {
            this.eutranCid = eutranCid;
        }

        @Override
        public final Builder eutranCid(Integer eutranCid) {
            this.eutranCid = eutranCid;
            return this;
        }

        public final Integer getTac() {
            return this.tac;
        }

        public final void setTac(Integer tac) {
            this.tac = tac;
        }

        @Override
        public final Builder tac(Integer tac) {
            this.tac = tac;
            return this;
        }

        public final LteLocalId.Builder getLteLocalId() {
            return this.lteLocalId != null ? this.lteLocalId.toBuilder() : null;
        }

        public final void setLteLocalId(LteLocalId.BuilderImpl lteLocalId) {
            this.lteLocalId = lteLocalId != null ? lteLocalId.build() : null;
        }

        @Override
        public final Builder lteLocalId(LteLocalId lteLocalId) {
            this.lteLocalId = lteLocalId;
            return this;
        }

        public final Integer getLteTimingAdvance() {
            return this.lteTimingAdvance;
        }

        public final void setLteTimingAdvance(Integer lteTimingAdvance) {
            this.lteTimingAdvance = lteTimingAdvance;
        }

        @Override
        public final Builder lteTimingAdvance(Integer lteTimingAdvance) {
            this.lteTimingAdvance = lteTimingAdvance;
            return this;
        }

        public final Integer getRsrp() {
            return this.rsrp;
        }

        public final void setRsrp(Integer rsrp) {
            this.rsrp = rsrp;
        }

        @Override
        public final Builder rsrp(Integer rsrp) {
            this.rsrp = rsrp;
            return this;
        }

        public final Float getRsrq() {
            return this.rsrq;
        }

        public final void setRsrq(Float rsrq) {
            this.rsrq = rsrq;
        }

        @Override
        public final Builder rsrq(Float rsrq) {
            this.rsrq = rsrq;
            return this;
        }

        public final Boolean getNrCapable() {
            return this.nrCapable;
        }

        public final void setNrCapable(Boolean nrCapable) {
            this.nrCapable = nrCapable;
        }

        @Override
        public final Builder nrCapable(Boolean nrCapable) {
            this.nrCapable = nrCapable;
            return this;
        }

        public final List<LteNmrObj.Builder> getLteNmr() {
            List<LteNmrObj.Builder> result = LteNmrListCopier.copyToBuilder(this.lteNmr);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLteNmr(Collection<LteNmrObj.BuilderImpl> lteNmr) {
            this.lteNmr = LteNmrListCopier.copyFromBuilder(lteNmr);
        }

        @Override
        public final Builder lteNmr(Collection<LteNmrObj> lteNmr) {
            this.lteNmr = LteNmrListCopier.copy(lteNmr);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lteNmr(LteNmrObj ... lteNmr) {
            this.lteNmr(Arrays.asList(lteNmr));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lteNmr(Consumer<LteNmrObj.Builder> ... lteNmr) {
            this.lteNmr(Stream.of(lteNmr).map(c -> (LteNmrObj)((LteNmrObj.Builder)LteNmrObj.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public LteObj build() {
            return new LteObj(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LteObj> {
        public Builder mcc(Integer var1);

        public Builder mnc(Integer var1);

        public Builder eutranCid(Integer var1);

        public Builder tac(Integer var1);

        public Builder lteLocalId(LteLocalId var1);

        default public Builder lteLocalId(Consumer<LteLocalId.Builder> lteLocalId) {
            return this.lteLocalId((LteLocalId)((LteLocalId.Builder)LteLocalId.builder().applyMutation(lteLocalId)).build());
        }

        public Builder lteTimingAdvance(Integer var1);

        public Builder rsrp(Integer var1);

        public Builder rsrq(Float var1);

        public Builder nrCapable(Boolean var1);

        public Builder lteNmr(Collection<LteNmrObj> var1);

        public Builder lteNmr(LteNmrObj ... var1);

        public Builder lteNmr(Consumer<LteNmrObj.Builder> ... var1);
    }
}

