/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessRequest;
import software.amazon.awssdk.services.iotwireless.model.WirelessDeviceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWirelessDevicesRequest
extends IotWirelessRequest
implements ToCopyableBuilder<Builder, ListWirelessDevicesRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListWirelessDevicesRequest.getter(ListWirelessDevicesRequest::maxResults)).setter(ListWirelessDevicesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListWirelessDevicesRequest.getter(ListWirelessDevicesRequest::nextToken)).setter(ListWirelessDevicesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<String> DESTINATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationName").getter(ListWirelessDevicesRequest.getter(ListWirelessDevicesRequest::destinationName)).setter(ListWirelessDevicesRequest.setter(Builder::destinationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("destinationName").build()}).build();
    private static final SdkField<String> DEVICE_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceProfileId").getter(ListWirelessDevicesRequest.getter(ListWirelessDevicesRequest::deviceProfileId)).setter(ListWirelessDevicesRequest.setter(Builder::deviceProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("deviceProfileId").build()}).build();
    private static final SdkField<String> SERVICE_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceProfileId").getter(ListWirelessDevicesRequest.getter(ListWirelessDevicesRequest::serviceProfileId)).setter(ListWirelessDevicesRequest.setter(Builder::serviceProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("serviceProfileId").build()}).build();
    private static final SdkField<String> WIRELESS_DEVICE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WirelessDeviceType").getter(ListWirelessDevicesRequest.getter(ListWirelessDevicesRequest::wirelessDeviceTypeAsString)).setter(ListWirelessDevicesRequest.setter(Builder::wirelessDeviceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("wirelessDeviceType").build()}).build();
    private static final SdkField<String> FUOTA_TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FuotaTaskId").getter(ListWirelessDevicesRequest.getter(ListWirelessDevicesRequest::fuotaTaskId)).setter(ListWirelessDevicesRequest.setter(Builder::fuotaTaskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("fuotaTaskId").build()}).build();
    private static final SdkField<String> MULTICAST_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MulticastGroupId").getter(ListWirelessDevicesRequest.getter(ListWirelessDevicesRequest::multicastGroupId)).setter(ListWirelessDevicesRequest.setter(Builder::multicastGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("multicastGroupId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, DESTINATION_NAME_FIELD, DEVICE_PROFILE_ID_FIELD, SERVICE_PROFILE_ID_FIELD, WIRELESS_DEVICE_TYPE_FIELD, FUOTA_TASK_ID_FIELD, MULTICAST_GROUP_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListWirelessDevicesRequest.memberNameToFieldInitializer();
    private final Integer maxResults;
    private final String nextToken;
    private final String destinationName;
    private final String deviceProfileId;
    private final String serviceProfileId;
    private final String wirelessDeviceType;
    private final String fuotaTaskId;
    private final String multicastGroupId;

    private ListWirelessDevicesRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.destinationName = builder.destinationName;
        this.deviceProfileId = builder.deviceProfileId;
        this.serviceProfileId = builder.serviceProfileId;
        this.wirelessDeviceType = builder.wirelessDeviceType;
        this.fuotaTaskId = builder.fuotaTaskId;
        this.multicastGroupId = builder.multicastGroupId;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String destinationName() {
        return this.destinationName;
    }

    public final String deviceProfileId() {
        return this.deviceProfileId;
    }

    public final String serviceProfileId() {
        return this.serviceProfileId;
    }

    public final WirelessDeviceType wirelessDeviceType() {
        return WirelessDeviceType.fromValue(this.wirelessDeviceType);
    }

    public final String wirelessDeviceTypeAsString() {
        return this.wirelessDeviceType;
    }

    public final String fuotaTaskId() {
        return this.fuotaTaskId;
    }

    public final String multicastGroupId() {
        return this.multicastGroupId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.wirelessDeviceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fuotaTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.multicastGroupId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWirelessDevicesRequest)) {
            return false;
        }
        ListWirelessDevicesRequest other = (ListWirelessDevicesRequest)((Object)obj);
        return Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.destinationName(), other.destinationName()) && Objects.equals(this.deviceProfileId(), other.deviceProfileId()) && Objects.equals(this.serviceProfileId(), other.serviceProfileId()) && Objects.equals(this.wirelessDeviceTypeAsString(), other.wirelessDeviceTypeAsString()) && Objects.equals(this.fuotaTaskId(), other.fuotaTaskId()) && Objects.equals(this.multicastGroupId(), other.multicastGroupId());
    }

    public final String toString() {
        return ToString.builder((String)"ListWirelessDevicesRequest").add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("DestinationName", (Object)this.destinationName()).add("DeviceProfileId", (Object)this.deviceProfileId()).add("ServiceProfileId", (Object)this.serviceProfileId()).add("WirelessDeviceType", (Object)this.wirelessDeviceTypeAsString()).add("FuotaTaskId", (Object)this.fuotaTaskId()).add("MulticastGroupId", (Object)this.multicastGroupId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "DestinationName": {
                return Optional.ofNullable(clazz.cast(this.destinationName()));
            }
            case "DeviceProfileId": {
                return Optional.ofNullable(clazz.cast(this.deviceProfileId()));
            }
            case "ServiceProfileId": {
                return Optional.ofNullable(clazz.cast(this.serviceProfileId()));
            }
            case "WirelessDeviceType": {
                return Optional.ofNullable(clazz.cast(this.wirelessDeviceTypeAsString()));
            }
            case "FuotaTaskId": {
                return Optional.ofNullable(clazz.cast(this.fuotaTaskId()));
            }
            case "MulticastGroupId": {
                return Optional.ofNullable(clazz.cast(this.multicastGroupId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("destinationName", DESTINATION_NAME_FIELD);
        map.put("deviceProfileId", DEVICE_PROFILE_ID_FIELD);
        map.put("serviceProfileId", SERVICE_PROFILE_ID_FIELD);
        map.put("wirelessDeviceType", WIRELESS_DEVICE_TYPE_FIELD);
        map.put("fuotaTaskId", FUOTA_TASK_ID_FIELD);
        map.put("multicastGroupId", MULTICAST_GROUP_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListWirelessDevicesRequest, T> g) {
        return obj -> g.apply((ListWirelessDevicesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessRequest.BuilderImpl
    implements Builder {
        private Integer maxResults;
        private String nextToken;
        private String destinationName;
        private String deviceProfileId;
        private String serviceProfileId;
        private String wirelessDeviceType;
        private String fuotaTaskId;
        private String multicastGroupId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWirelessDevicesRequest model) {
            super(model);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.destinationName(model.destinationName);
            this.deviceProfileId(model.deviceProfileId);
            this.serviceProfileId(model.serviceProfileId);
            this.wirelessDeviceType(model.wirelessDeviceType);
            this.fuotaTaskId(model.fuotaTaskId);
            this.multicastGroupId(model.multicastGroupId);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getDestinationName() {
            return this.destinationName;
        }

        public final void setDestinationName(String destinationName) {
            this.destinationName = destinationName;
        }

        @Override
        public final Builder destinationName(String destinationName) {
            this.destinationName = destinationName;
            return this;
        }

        public final String getDeviceProfileId() {
            return this.deviceProfileId;
        }

        public final void setDeviceProfileId(String deviceProfileId) {
            this.deviceProfileId = deviceProfileId;
        }

        @Override
        public final Builder deviceProfileId(String deviceProfileId) {
            this.deviceProfileId = deviceProfileId;
            return this;
        }

        public final String getServiceProfileId() {
            return this.serviceProfileId;
        }

        public final void setServiceProfileId(String serviceProfileId) {
            this.serviceProfileId = serviceProfileId;
        }

        @Override
        public final Builder serviceProfileId(String serviceProfileId) {
            this.serviceProfileId = serviceProfileId;
            return this;
        }

        public final String getWirelessDeviceType() {
            return this.wirelessDeviceType;
        }

        public final void setWirelessDeviceType(String wirelessDeviceType) {
            this.wirelessDeviceType = wirelessDeviceType;
        }

        @Override
        public final Builder wirelessDeviceType(String wirelessDeviceType) {
            this.wirelessDeviceType = wirelessDeviceType;
            return this;
        }

        @Override
        public final Builder wirelessDeviceType(WirelessDeviceType wirelessDeviceType) {
            this.wirelessDeviceType(wirelessDeviceType == null ? null : wirelessDeviceType.toString());
            return this;
        }

        public final String getFuotaTaskId() {
            return this.fuotaTaskId;
        }

        public final void setFuotaTaskId(String fuotaTaskId) {
            this.fuotaTaskId = fuotaTaskId;
        }

        @Override
        public final Builder fuotaTaskId(String fuotaTaskId) {
            this.fuotaTaskId = fuotaTaskId;
            return this;
        }

        public final String getMulticastGroupId() {
            return this.multicastGroupId;
        }

        public final void setMulticastGroupId(String multicastGroupId) {
            this.multicastGroupId = multicastGroupId;
        }

        @Override
        public final Builder multicastGroupId(String multicastGroupId) {
            this.multicastGroupId = multicastGroupId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListWirelessDevicesRequest build() {
            return new ListWirelessDevicesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotWirelessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWirelessDevicesRequest> {
        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder destinationName(String var1);

        public Builder deviceProfileId(String var1);

        public Builder serviceProfileId(String var1);

        public Builder wirelessDeviceType(String var1);

        public Builder wirelessDeviceType(WirelessDeviceType var1);

        public Builder fuotaTaskId(String var1);

        public Builder multicastGroupId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

