/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotwireless.model.EventConfigurationItem;
import software.amazon.awssdk.services.iotwireless.model.EventConfigurationsListCopier;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEventConfigurationsResponse
extends IotWirelessResponse
implements ToCopyableBuilder<Builder, ListEventConfigurationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListEventConfigurationsResponse.getter(ListEventConfigurationsResponse::nextToken)).setter(ListEventConfigurationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<EventConfigurationItem>> EVENT_CONFIGURATIONS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EventConfigurationsList").getter(ListEventConfigurationsResponse.getter(ListEventConfigurationsResponse::eventConfigurationsList)).setter(ListEventConfigurationsResponse.setter(Builder::eventConfigurationsList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventConfigurationsList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EventConfigurationItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, EVENT_CONFIGURATIONS_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListEventConfigurationsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<EventConfigurationItem> eventConfigurationsList;

    private ListEventConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.eventConfigurationsList = builder.eventConfigurationsList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasEventConfigurationsList() {
        return this.eventConfigurationsList != null && !(this.eventConfigurationsList instanceof SdkAutoConstructList);
    }

    public final List<EventConfigurationItem> eventConfigurationsList() {
        return this.eventConfigurationsList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventConfigurationsList() ? this.eventConfigurationsList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEventConfigurationsResponse)) {
            return false;
        }
        ListEventConfigurationsResponse other = (ListEventConfigurationsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasEventConfigurationsList() == other.hasEventConfigurationsList() && Objects.equals(this.eventConfigurationsList(), other.eventConfigurationsList());
    }

    public final String toString() {
        return ToString.builder((String)"ListEventConfigurationsResponse").add("NextToken", (Object)this.nextToken()).add("EventConfigurationsList", this.hasEventConfigurationsList() ? this.eventConfigurationsList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "EventConfigurationsList": {
                return Optional.ofNullable(clazz.cast(this.eventConfigurationsList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("EventConfigurationsList", EVENT_CONFIGURATIONS_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEventConfigurationsResponse, T> g) {
        return obj -> g.apply((ListEventConfigurationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<EventConfigurationItem> eventConfigurationsList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListEventConfigurationsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.eventConfigurationsList(model.eventConfigurationsList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<EventConfigurationItem.Builder> getEventConfigurationsList() {
            List<EventConfigurationItem.Builder> result = EventConfigurationsListCopier.copyToBuilder(this.eventConfigurationsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventConfigurationsList(Collection<EventConfigurationItem.BuilderImpl> eventConfigurationsList) {
            this.eventConfigurationsList = EventConfigurationsListCopier.copyFromBuilder(eventConfigurationsList);
        }

        @Override
        public final Builder eventConfigurationsList(Collection<EventConfigurationItem> eventConfigurationsList) {
            this.eventConfigurationsList = EventConfigurationsListCopier.copy(eventConfigurationsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventConfigurationsList(EventConfigurationItem ... eventConfigurationsList) {
            this.eventConfigurationsList(Arrays.asList(eventConfigurationsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventConfigurationsList(Consumer<EventConfigurationItem.Builder> ... eventConfigurationsList) {
            this.eventConfigurationsList(Stream.of(eventConfigurationsList).map(c -> (EventConfigurationItem)((EventConfigurationItem.Builder)EventConfigurationItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListEventConfigurationsResponse build() {
            return new ListEventConfigurationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotWirelessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEventConfigurationsResponse> {
        public Builder nextToken(String var1);

        public Builder eventConfigurationsList(Collection<EventConfigurationItem> var1);

        public Builder eventConfigurationsList(EventConfigurationItem ... var1);

        public Builder eventConfigurationsList(Consumer<EventConfigurationItem.Builder> ... var1);
    }
}

