/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GatewayListItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GatewayListItem> {
    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayId").getter(GatewayListItem.getter(GatewayListItem::gatewayId)).setter(GatewayListItem.setter(Builder::gatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayId").build()}).build();
    private static final SdkField<Integer> DOWNLINK_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DownlinkFrequency").getter(GatewayListItem.getter(GatewayListItem::downlinkFrequency)).setter(GatewayListItem.setter(Builder::downlinkFrequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DownlinkFrequency").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ID_FIELD, DOWNLINK_FREQUENCY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GatewayListItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String gatewayId;
    private final Integer downlinkFrequency;

    private GatewayListItem(BuilderImpl builder) {
        this.gatewayId = builder.gatewayId;
        this.downlinkFrequency = builder.downlinkFrequency;
    }

    public final String gatewayId() {
        return this.gatewayId;
    }

    public final Integer downlinkFrequency() {
        return this.downlinkFrequency;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.downlinkFrequency());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GatewayListItem)) {
            return false;
        }
        GatewayListItem other = (GatewayListItem)obj;
        return Objects.equals(this.gatewayId(), other.gatewayId()) && Objects.equals(this.downlinkFrequency(), other.downlinkFrequency());
    }

    public final String toString() {
        return ToString.builder((String)"GatewayListItem").add("GatewayId", (Object)this.gatewayId()).add("DownlinkFrequency", (Object)this.downlinkFrequency()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GatewayId": {
                return Optional.ofNullable(clazz.cast(this.gatewayId()));
            }
            case "DownlinkFrequency": {
                return Optional.ofNullable(clazz.cast(this.downlinkFrequency()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GatewayId", GATEWAY_ID_FIELD);
        map.put("DownlinkFrequency", DOWNLINK_FREQUENCY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GatewayListItem, T> g) {
        return obj -> g.apply((GatewayListItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String gatewayId;
        private Integer downlinkFrequency;

        private BuilderImpl() {
        }

        private BuilderImpl(GatewayListItem model) {
            this.gatewayId(model.gatewayId);
            this.downlinkFrequency(model.downlinkFrequency);
        }

        public final String getGatewayId() {
            return this.gatewayId;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final Integer getDownlinkFrequency() {
            return this.downlinkFrequency;
        }

        public final void setDownlinkFrequency(Integer downlinkFrequency) {
            this.downlinkFrequency = downlinkFrequency;
        }

        @Override
        public final Builder downlinkFrequency(Integer downlinkFrequency) {
            this.downlinkFrequency = downlinkFrequency;
            return this;
        }

        public GatewayListItem build() {
            return new GatewayListItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GatewayListItem> {
        public Builder gatewayId(String var1);

        public Builder downlinkFrequency(Integer var1);
    }
}

