/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotwireless.IotWirelessAsyncClient;
import software.amazon.awssdk.services.iotwireless.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesRequest;
import software.amazon.awssdk.services.iotwireless.model.ListWirelessDevicesResponse;

public class ListWirelessDevicesPublisher
implements SdkPublisher<ListWirelessDevicesResponse> {
    private final IotWirelessAsyncClient client;
    private final ListWirelessDevicesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListWirelessDevicesPublisher(IotWirelessAsyncClient client, ListWirelessDevicesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListWirelessDevicesPublisher(IotWirelessAsyncClient client, ListWirelessDevicesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListWirelessDevicesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListWirelessDevicesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListWirelessDevicesResponseFetcher
    implements AsyncPageFetcher<ListWirelessDevicesResponse> {
        private ListWirelessDevicesResponseFetcher() {
        }

        public boolean hasNextPage(ListWirelessDevicesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListWirelessDevicesResponse> nextPage(ListWirelessDevicesResponse previousPage) {
            if (previousPage == null) {
                return ListWirelessDevicesPublisher.this.client.listWirelessDevices(ListWirelessDevicesPublisher.this.firstRequest);
            }
            return ListWirelessDevicesPublisher.this.client.listWirelessDevices((ListWirelessDevicesRequest)((Object)ListWirelessDevicesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

