/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessRequest;
import software.amazon.awssdk.services.iotwireless.model.SidewalkSingleStartImportInfo;
import software.amazon.awssdk.services.iotwireless.model.Tag;
import software.amazon.awssdk.services.iotwireless.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartSingleWirelessDeviceImportTaskRequest
extends IotWirelessRequest
implements ToCopyableBuilder<Builder, StartSingleWirelessDeviceImportTaskRequest> {
    private static final SdkField<String> DESTINATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationName").getter(StartSingleWirelessDeviceImportTaskRequest.getter(StartSingleWirelessDeviceImportTaskRequest::destinationName)).setter(StartSingleWirelessDeviceImportTaskRequest.setter(Builder::destinationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationName").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(StartSingleWirelessDeviceImportTaskRequest.getter(StartSingleWirelessDeviceImportTaskRequest::clientRequestToken)).setter(StartSingleWirelessDeviceImportTaskRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceName").getter(StartSingleWirelessDeviceImportTaskRequest.getter(StartSingleWirelessDeviceImportTaskRequest::deviceName)).setter(StartSingleWirelessDeviceImportTaskRequest.setter(Builder::deviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceName").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(StartSingleWirelessDeviceImportTaskRequest.getter(StartSingleWirelessDeviceImportTaskRequest::tags)).setter(StartSingleWirelessDeviceImportTaskRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SidewalkSingleStartImportInfo> SIDEWALK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Sidewalk").getter(StartSingleWirelessDeviceImportTaskRequest.getter(StartSingleWirelessDeviceImportTaskRequest::sidewalk)).setter(StartSingleWirelessDeviceImportTaskRequest.setter(Builder::sidewalk)).constructor(SidewalkSingleStartImportInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sidewalk").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_NAME_FIELD, CLIENT_REQUEST_TOKEN_FIELD, DEVICE_NAME_FIELD, TAGS_FIELD, SIDEWALK_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DestinationName", DESTINATION_NAME_FIELD);
            this.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
            this.put("DeviceName", DEVICE_NAME_FIELD);
            this.put("Tags", TAGS_FIELD);
            this.put("Sidewalk", SIDEWALK_FIELD);
        }
    });
    private final String destinationName;
    private final String clientRequestToken;
    private final String deviceName;
    private final List<Tag> tags;
    private final SidewalkSingleStartImportInfo sidewalk;

    private StartSingleWirelessDeviceImportTaskRequest(BuilderImpl builder) {
        super(builder);
        this.destinationName = builder.destinationName;
        this.clientRequestToken = builder.clientRequestToken;
        this.deviceName = builder.deviceName;
        this.tags = builder.tags;
        this.sidewalk = builder.sidewalk;
    }

    public final String destinationName() {
        return this.destinationName;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final String deviceName() {
        return this.deviceName;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final SidewalkSingleStartImportInfo sidewalk() {
        return this.sidewalk;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sidewalk());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSingleWirelessDeviceImportTaskRequest)) {
            return false;
        }
        StartSingleWirelessDeviceImportTaskRequest other = (StartSingleWirelessDeviceImportTaskRequest)((Object)obj);
        return Objects.equals(this.destinationName(), other.destinationName()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.deviceName(), other.deviceName()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.sidewalk(), other.sidewalk());
    }

    public final String toString() {
        return ToString.builder((String)"StartSingleWirelessDeviceImportTaskRequest").add("DestinationName", (Object)this.destinationName()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("DeviceName", (Object)this.deviceName()).add("Tags", this.hasTags() ? this.tags() : null).add("Sidewalk", (Object)this.sidewalk()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DestinationName": {
                return Optional.ofNullable(clazz.cast(this.destinationName()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "DeviceName": {
                return Optional.ofNullable(clazz.cast(this.deviceName()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Sidewalk": {
                return Optional.ofNullable(clazz.cast(this.sidewalk()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartSingleWirelessDeviceImportTaskRequest, T> g) {
        return obj -> g.apply((StartSingleWirelessDeviceImportTaskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessRequest.BuilderImpl
    implements Builder {
        private String destinationName;
        private String clientRequestToken;
        private String deviceName;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private SidewalkSingleStartImportInfo sidewalk;

        private BuilderImpl() {
        }

        private BuilderImpl(StartSingleWirelessDeviceImportTaskRequest model) {
            super(model);
            this.destinationName(model.destinationName);
            this.clientRequestToken(model.clientRequestToken);
            this.deviceName(model.deviceName);
            this.tags(model.tags);
            this.sidewalk(model.sidewalk);
        }

        public final String getDestinationName() {
            return this.destinationName;
        }

        public final void setDestinationName(String destinationName) {
            this.destinationName = destinationName;
        }

        @Override
        public final Builder destinationName(String destinationName) {
            this.destinationName = destinationName;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getDeviceName() {
            return this.deviceName;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final SidewalkSingleStartImportInfo.Builder getSidewalk() {
            return this.sidewalk != null ? this.sidewalk.toBuilder() : null;
        }

        public final void setSidewalk(SidewalkSingleStartImportInfo.BuilderImpl sidewalk) {
            this.sidewalk = sidewalk != null ? sidewalk.build() : null;
        }

        @Override
        public final Builder sidewalk(SidewalkSingleStartImportInfo sidewalk) {
            this.sidewalk = sidewalk;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartSingleWirelessDeviceImportTaskRequest build() {
            return new StartSingleWirelessDeviceImportTaskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotWirelessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartSingleWirelessDeviceImportTaskRequest> {
        public Builder destinationName(String var1);

        public Builder clientRequestToken(String var1);

        public Builder deviceName(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder sidewalk(SidewalkSingleStartImportInfo var1);

        default public Builder sidewalk(Consumer<SidewalkSingleStartImportInfo.Builder> sidewalk) {
            return this.sidewalk((SidewalkSingleStartImportInfo)((SidewalkSingleStartImportInfo.Builder)SidewalkSingleStartImportInfo.builder().applyMutation(sidewalk)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

