/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotwireless.model.PositionConfigurationFec;
import software.amazon.awssdk.services.iotwireless.model.PositionConfigurationStatus;
import software.amazon.awssdk.services.iotwireless.model.PositionSolverProvider;
import software.amazon.awssdk.services.iotwireless.model.PositionSolverType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SemtechGnssDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SemtechGnssDetail> {
    private static final SdkField<String> PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Provider").getter(SemtechGnssDetail.getter(SemtechGnssDetail::providerAsString)).setter(SemtechGnssDetail.setter(Builder::provider)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Provider").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(SemtechGnssDetail.getter(SemtechGnssDetail::typeAsString)).setter(SemtechGnssDetail.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(SemtechGnssDetail.getter(SemtechGnssDetail::statusAsString)).setter(SemtechGnssDetail.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> FEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Fec").getter(SemtechGnssDetail.getter(SemtechGnssDetail::fecAsString)).setter(SemtechGnssDetail.setter(Builder::fec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fec").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVIDER_FIELD, TYPE_FIELD, STATUS_FIELD, FEC_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Provider", PROVIDER_FIELD);
            this.put("Type", TYPE_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("Fec", FEC_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String provider;
    private final String type;
    private final String status;
    private final String fec;

    private SemtechGnssDetail(BuilderImpl builder) {
        this.provider = builder.provider;
        this.type = builder.type;
        this.status = builder.status;
        this.fec = builder.fec;
    }

    public final PositionSolverProvider provider() {
        return PositionSolverProvider.fromValue(this.provider);
    }

    public final String providerAsString() {
        return this.provider;
    }

    public final PositionSolverType type() {
        return PositionSolverType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final PositionConfigurationStatus status() {
        return PositionConfigurationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final PositionConfigurationFec fec() {
        return PositionConfigurationFec.fromValue(this.fec);
    }

    public final String fecAsString() {
        return this.fec;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.providerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fecAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SemtechGnssDetail)) {
            return false;
        }
        SemtechGnssDetail other = (SemtechGnssDetail)obj;
        return Objects.equals(this.providerAsString(), other.providerAsString()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.fecAsString(), other.fecAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SemtechGnssDetail").add("Provider", (Object)this.providerAsString()).add("Type", (Object)this.typeAsString()).add("Status", (Object)this.statusAsString()).add("Fec", (Object)this.fecAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Provider": {
                return Optional.ofNullable(clazz.cast(this.providerAsString()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Fec": {
                return Optional.ofNullable(clazz.cast(this.fecAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SemtechGnssDetail, T> g) {
        return obj -> g.apply((SemtechGnssDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String provider;
        private String type;
        private String status;
        private String fec;

        private BuilderImpl() {
        }

        private BuilderImpl(SemtechGnssDetail model) {
            this.provider(model.provider);
            this.type(model.type);
            this.status(model.status);
            this.fec(model.fec);
        }

        public final String getProvider() {
            return this.provider;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        @Override
        public final Builder provider(PositionSolverProvider provider) {
            this.provider(provider == null ? null : provider.toString());
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PositionSolverType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PositionConfigurationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFec() {
            return this.fec;
        }

        public final void setFec(String fec) {
            this.fec = fec;
        }

        @Override
        public final Builder fec(String fec) {
            this.fec = fec;
            return this;
        }

        @Override
        public final Builder fec(PositionConfigurationFec fec) {
            this.fec(fec == null ? null : fec.toString());
            return this;
        }

        public SemtechGnssDetail build() {
            return new SemtechGnssDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SemtechGnssDetail> {
        public Builder provider(String var1);

        public Builder provider(PositionSolverProvider var1);

        public Builder type(String var1);

        public Builder type(PositionSolverType var1);

        public Builder status(String var1);

        public Builder status(PositionConfigurationStatus var1);

        public Builder fec(String var1);

        public Builder fec(PositionConfigurationFec var1);
    }
}

