/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MessageType {
    CUSTOM_COMMAND_ID_NOTIFY("CUSTOM_COMMAND_ID_NOTIFY"),
    CUSTOM_COMMAND_ID_GET("CUSTOM_COMMAND_ID_GET"),
    CUSTOM_COMMAND_ID_SET("CUSTOM_COMMAND_ID_SET"),
    CUSTOM_COMMAND_ID_RESP("CUSTOM_COMMAND_ID_RESP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MessageType> VALUE_MAP;
    private final String value;

    private MessageType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MessageType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MessageType> knownValues() {
        EnumSet<MessageType> knownValues = EnumSet.allOf(MessageType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MessageType.class, MessageType::toString);
    }
}

