/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotwireless.model.FuotaTask;
import software.amazon.awssdk.services.iotwireless.model.FuotaTaskListCopier;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFuotaTasksResponse
extends IotWirelessResponse
implements ToCopyableBuilder<Builder, ListFuotaTasksResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListFuotaTasksResponse.getter(ListFuotaTasksResponse::nextToken)).setter(ListFuotaTasksResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<FuotaTask>> FUOTA_TASK_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FuotaTaskList").getter(ListFuotaTasksResponse.getter(ListFuotaTasksResponse::fuotaTaskList)).setter(ListFuotaTasksResponse.setter(Builder::fuotaTaskList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FuotaTaskList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FuotaTask::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, FUOTA_TASK_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("FuotaTaskList", FUOTA_TASK_LIST_FIELD);
        }
    });
    private final String nextToken;
    private final List<FuotaTask> fuotaTaskList;

    private ListFuotaTasksResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.fuotaTaskList = builder.fuotaTaskList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasFuotaTaskList() {
        return this.fuotaTaskList != null && !(this.fuotaTaskList instanceof SdkAutoConstructList);
    }

    public final List<FuotaTask> fuotaTaskList() {
        return this.fuotaTaskList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFuotaTaskList() ? this.fuotaTaskList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFuotaTasksResponse)) {
            return false;
        }
        ListFuotaTasksResponse other = (ListFuotaTasksResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasFuotaTaskList() == other.hasFuotaTaskList() && Objects.equals(this.fuotaTaskList(), other.fuotaTaskList());
    }

    public final String toString() {
        return ToString.builder((String)"ListFuotaTasksResponse").add("NextToken", (Object)this.nextToken()).add("FuotaTaskList", this.hasFuotaTaskList() ? this.fuotaTaskList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "FuotaTaskList": {
                return Optional.ofNullable(clazz.cast(this.fuotaTaskList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListFuotaTasksResponse, T> g) {
        return obj -> g.apply((ListFuotaTasksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<FuotaTask> fuotaTaskList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListFuotaTasksResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.fuotaTaskList(model.fuotaTaskList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<FuotaTask.Builder> getFuotaTaskList() {
            List<FuotaTask.Builder> result = FuotaTaskListCopier.copyToBuilder(this.fuotaTaskList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFuotaTaskList(Collection<FuotaTask.BuilderImpl> fuotaTaskList) {
            this.fuotaTaskList = FuotaTaskListCopier.copyFromBuilder(fuotaTaskList);
        }

        @Override
        public final Builder fuotaTaskList(Collection<FuotaTask> fuotaTaskList) {
            this.fuotaTaskList = FuotaTaskListCopier.copy(fuotaTaskList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fuotaTaskList(FuotaTask ... fuotaTaskList) {
            this.fuotaTaskList(Arrays.asList(fuotaTaskList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fuotaTaskList(Consumer<FuotaTask.Builder> ... fuotaTaskList) {
            this.fuotaTaskList(Stream.of(fuotaTaskList).map(c -> (FuotaTask)((FuotaTask.Builder)FuotaTask.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListFuotaTasksResponse build() {
            return new ListFuotaTasksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotWirelessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFuotaTasksResponse> {
        public Builder nextToken(String var1);

        public Builder fuotaTaskList(Collection<FuotaTask> var1);

        public Builder fuotaTaskList(FuotaTask ... var1);

        public Builder fuotaTaskList(Consumer<FuotaTask.Builder> ... var1);
    }
}

