/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotwireless.model.ImportTaskStatus;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessResponse;
import software.amazon.awssdk.services.iotwireless.model.SidewalkGetStartImportInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetWirelessDeviceImportTaskResponse
extends IotWirelessResponse
implements ToCopyableBuilder<Builder, GetWirelessDeviceImportTaskResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(GetWirelessDeviceImportTaskResponse.getter(GetWirelessDeviceImportTaskResponse::id)).setter(GetWirelessDeviceImportTaskResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(GetWirelessDeviceImportTaskResponse.getter(GetWirelessDeviceImportTaskResponse::arn)).setter(GetWirelessDeviceImportTaskResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> DESTINATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationName").getter(GetWirelessDeviceImportTaskResponse.getter(GetWirelessDeviceImportTaskResponse::destinationName)).setter(GetWirelessDeviceImportTaskResponse.setter(Builder::destinationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationName").build()}).build();
    private static final SdkField<SidewalkGetStartImportInfo> SIDEWALK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Sidewalk").getter(GetWirelessDeviceImportTaskResponse.getter(GetWirelessDeviceImportTaskResponse::sidewalk)).setter(GetWirelessDeviceImportTaskResponse.setter(Builder::sidewalk)).constructor(SidewalkGetStartImportInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sidewalk").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(GetWirelessDeviceImportTaskResponse.getter(GetWirelessDeviceImportTaskResponse::creationTime)).setter(GetWirelessDeviceImportTaskResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetWirelessDeviceImportTaskResponse.getter(GetWirelessDeviceImportTaskResponse::statusAsString)).setter(GetWirelessDeviceImportTaskResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusReason").getter(GetWirelessDeviceImportTaskResponse.getter(GetWirelessDeviceImportTaskResponse::statusReason)).setter(GetWirelessDeviceImportTaskResponse.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()}).build();
    private static final SdkField<Long> INITIALIZED_IMPORTED_DEVICE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("InitializedImportedDeviceCount").getter(GetWirelessDeviceImportTaskResponse.getter(GetWirelessDeviceImportTaskResponse::initializedImportedDeviceCount)).setter(GetWirelessDeviceImportTaskResponse.setter(Builder::initializedImportedDeviceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitializedImportedDeviceCount").build()}).build();
    private static final SdkField<Long> PENDING_IMPORTED_DEVICE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("PendingImportedDeviceCount").getter(GetWirelessDeviceImportTaskResponse.getter(GetWirelessDeviceImportTaskResponse::pendingImportedDeviceCount)).setter(GetWirelessDeviceImportTaskResponse.setter(Builder::pendingImportedDeviceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingImportedDeviceCount").build()}).build();
    private static final SdkField<Long> ONBOARDED_IMPORTED_DEVICE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("OnboardedImportedDeviceCount").getter(GetWirelessDeviceImportTaskResponse.getter(GetWirelessDeviceImportTaskResponse::onboardedImportedDeviceCount)).setter(GetWirelessDeviceImportTaskResponse.setter(Builder::onboardedImportedDeviceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnboardedImportedDeviceCount").build()}).build();
    private static final SdkField<Long> FAILED_IMPORTED_DEVICE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("FailedImportedDeviceCount").getter(GetWirelessDeviceImportTaskResponse.getter(GetWirelessDeviceImportTaskResponse::failedImportedDeviceCount)).setter(GetWirelessDeviceImportTaskResponse.setter(Builder::failedImportedDeviceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedImportedDeviceCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, DESTINATION_NAME_FIELD, SIDEWALK_FIELD, CREATION_TIME_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, INITIALIZED_IMPORTED_DEVICE_COUNT_FIELD, PENDING_IMPORTED_DEVICE_COUNT_FIELD, ONBOARDED_IMPORTED_DEVICE_COUNT_FIELD, FAILED_IMPORTED_DEVICE_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Id", ID_FIELD);
            this.put("Arn", ARN_FIELD);
            this.put("DestinationName", DESTINATION_NAME_FIELD);
            this.put("Sidewalk", SIDEWALK_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("StatusReason", STATUS_REASON_FIELD);
            this.put("InitializedImportedDeviceCount", INITIALIZED_IMPORTED_DEVICE_COUNT_FIELD);
            this.put("PendingImportedDeviceCount", PENDING_IMPORTED_DEVICE_COUNT_FIELD);
            this.put("OnboardedImportedDeviceCount", ONBOARDED_IMPORTED_DEVICE_COUNT_FIELD);
            this.put("FailedImportedDeviceCount", FAILED_IMPORTED_DEVICE_COUNT_FIELD);
        }
    });
    private final String id;
    private final String arn;
    private final String destinationName;
    private final SidewalkGetStartImportInfo sidewalk;
    private final Instant creationTime;
    private final String status;
    private final String statusReason;
    private final Long initializedImportedDeviceCount;
    private final Long pendingImportedDeviceCount;
    private final Long onboardedImportedDeviceCount;
    private final Long failedImportedDeviceCount;

    private GetWirelessDeviceImportTaskResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.arn = builder.arn;
        this.destinationName = builder.destinationName;
        this.sidewalk = builder.sidewalk;
        this.creationTime = builder.creationTime;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.initializedImportedDeviceCount = builder.initializedImportedDeviceCount;
        this.pendingImportedDeviceCount = builder.pendingImportedDeviceCount;
        this.onboardedImportedDeviceCount = builder.onboardedImportedDeviceCount;
        this.failedImportedDeviceCount = builder.failedImportedDeviceCount;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String destinationName() {
        return this.destinationName;
    }

    public final SidewalkGetStartImportInfo sidewalk() {
        return this.sidewalk;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final ImportTaskStatus status() {
        return ImportTaskStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final Long initializedImportedDeviceCount() {
        return this.initializedImportedDeviceCount;
    }

    public final Long pendingImportedDeviceCount() {
        return this.pendingImportedDeviceCount;
    }

    public final Long onboardedImportedDeviceCount() {
        return this.onboardedImportedDeviceCount;
    }

    public final Long failedImportedDeviceCount() {
        return this.failedImportedDeviceCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sidewalk());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.initializedImportedDeviceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingImportedDeviceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.onboardedImportedDeviceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.failedImportedDeviceCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWirelessDeviceImportTaskResponse)) {
            return false;
        }
        GetWirelessDeviceImportTaskResponse other = (GetWirelessDeviceImportTaskResponse)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.destinationName(), other.destinationName()) && Objects.equals(this.sidewalk(), other.sidewalk()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.initializedImportedDeviceCount(), other.initializedImportedDeviceCount()) && Objects.equals(this.pendingImportedDeviceCount(), other.pendingImportedDeviceCount()) && Objects.equals(this.onboardedImportedDeviceCount(), other.onboardedImportedDeviceCount()) && Objects.equals(this.failedImportedDeviceCount(), other.failedImportedDeviceCount());
    }

    public final String toString() {
        return ToString.builder((String)"GetWirelessDeviceImportTaskResponse").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("DestinationName", (Object)this.destinationName()).add("Sidewalk", (Object)this.sidewalk()).add("CreationTime", (Object)this.creationTime()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("InitializedImportedDeviceCount", (Object)this.initializedImportedDeviceCount()).add("PendingImportedDeviceCount", (Object)this.pendingImportedDeviceCount()).add("OnboardedImportedDeviceCount", (Object)this.onboardedImportedDeviceCount()).add("FailedImportedDeviceCount", (Object)this.failedImportedDeviceCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "DestinationName": {
                return Optional.ofNullable(clazz.cast(this.destinationName()));
            }
            case "Sidewalk": {
                return Optional.ofNullable(clazz.cast(this.sidewalk()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "InitializedImportedDeviceCount": {
                return Optional.ofNullable(clazz.cast(this.initializedImportedDeviceCount()));
            }
            case "PendingImportedDeviceCount": {
                return Optional.ofNullable(clazz.cast(this.pendingImportedDeviceCount()));
            }
            case "OnboardedImportedDeviceCount": {
                return Optional.ofNullable(clazz.cast(this.onboardedImportedDeviceCount()));
            }
            case "FailedImportedDeviceCount": {
                return Optional.ofNullable(clazz.cast(this.failedImportedDeviceCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetWirelessDeviceImportTaskResponse, T> g) {
        return obj -> g.apply((GetWirelessDeviceImportTaskResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessResponse.BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String destinationName;
        private SidewalkGetStartImportInfo sidewalk;
        private Instant creationTime;
        private String status;
        private String statusReason;
        private Long initializedImportedDeviceCount;
        private Long pendingImportedDeviceCount;
        private Long onboardedImportedDeviceCount;
        private Long failedImportedDeviceCount;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWirelessDeviceImportTaskResponse model) {
            super(model);
            this.id(model.id);
            this.arn(model.arn);
            this.destinationName(model.destinationName);
            this.sidewalk(model.sidewalk);
            this.creationTime(model.creationTime);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.initializedImportedDeviceCount(model.initializedImportedDeviceCount);
            this.pendingImportedDeviceCount(model.pendingImportedDeviceCount);
            this.onboardedImportedDeviceCount(model.onboardedImportedDeviceCount);
            this.failedImportedDeviceCount(model.failedImportedDeviceCount);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDestinationName() {
            return this.destinationName;
        }

        public final void setDestinationName(String destinationName) {
            this.destinationName = destinationName;
        }

        @Override
        public final Builder destinationName(String destinationName) {
            this.destinationName = destinationName;
            return this;
        }

        public final SidewalkGetStartImportInfo.Builder getSidewalk() {
            return this.sidewalk != null ? this.sidewalk.toBuilder() : null;
        }

        public final void setSidewalk(SidewalkGetStartImportInfo.BuilderImpl sidewalk) {
            this.sidewalk = sidewalk != null ? sidewalk.build() : null;
        }

        @Override
        public final Builder sidewalk(SidewalkGetStartImportInfo sidewalk) {
            this.sidewalk = sidewalk;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ImportTaskStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Long getInitializedImportedDeviceCount() {
            return this.initializedImportedDeviceCount;
        }

        public final void setInitializedImportedDeviceCount(Long initializedImportedDeviceCount) {
            this.initializedImportedDeviceCount = initializedImportedDeviceCount;
        }

        @Override
        public final Builder initializedImportedDeviceCount(Long initializedImportedDeviceCount) {
            this.initializedImportedDeviceCount = initializedImportedDeviceCount;
            return this;
        }

        public final Long getPendingImportedDeviceCount() {
            return this.pendingImportedDeviceCount;
        }

        public final void setPendingImportedDeviceCount(Long pendingImportedDeviceCount) {
            this.pendingImportedDeviceCount = pendingImportedDeviceCount;
        }

        @Override
        public final Builder pendingImportedDeviceCount(Long pendingImportedDeviceCount) {
            this.pendingImportedDeviceCount = pendingImportedDeviceCount;
            return this;
        }

        public final Long getOnboardedImportedDeviceCount() {
            return this.onboardedImportedDeviceCount;
        }

        public final void setOnboardedImportedDeviceCount(Long onboardedImportedDeviceCount) {
            this.onboardedImportedDeviceCount = onboardedImportedDeviceCount;
        }

        @Override
        public final Builder onboardedImportedDeviceCount(Long onboardedImportedDeviceCount) {
            this.onboardedImportedDeviceCount = onboardedImportedDeviceCount;
            return this;
        }

        public final Long getFailedImportedDeviceCount() {
            return this.failedImportedDeviceCount;
        }

        public final void setFailedImportedDeviceCount(Long failedImportedDeviceCount) {
            this.failedImportedDeviceCount = failedImportedDeviceCount;
        }

        @Override
        public final Builder failedImportedDeviceCount(Long failedImportedDeviceCount) {
            this.failedImportedDeviceCount = failedImportedDeviceCount;
            return this;
        }

        @Override
        public GetWirelessDeviceImportTaskResponse build() {
            return new GetWirelessDeviceImportTaskResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotWirelessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetWirelessDeviceImportTaskResponse> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder destinationName(String var1);

        public Builder sidewalk(SidewalkGetStartImportInfo var1);

        default public Builder sidewalk(Consumer<SidewalkGetStartImportInfo.Builder> sidewalk) {
            return this.sidewalk((SidewalkGetStartImportInfo)((SidewalkGetStartImportInfo.Builder)SidewalkGetStartImportInfo.builder().applyMutation(sidewalk)).build());
        }

        public Builder creationTime(Instant var1);

        public Builder status(String var1);

        public Builder status(ImportTaskStatus var1);

        public Builder statusReason(String var1);

        public Builder initializedImportedDeviceCount(Long var1);

        public Builder pendingImportedDeviceCount(Long var1);

        public Builder onboardedImportedDeviceCount(Long var1);

        public Builder failedImportedDeviceCount(Long var1);
    }
}

