/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessRequest;
import software.amazon.awssdk.services.iotwireless.model.LoRaWANDevice;
import software.amazon.awssdk.services.iotwireless.model.PositioningConfigStatus;
import software.amazon.awssdk.services.iotwireless.model.SidewalkCreateWirelessDevice;
import software.amazon.awssdk.services.iotwireless.model.Tag;
import software.amazon.awssdk.services.iotwireless.model.TagListCopier;
import software.amazon.awssdk.services.iotwireless.model.WirelessDeviceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateWirelessDeviceRequest
extends IotWirelessRequest
implements ToCopyableBuilder<Builder, CreateWirelessDeviceRequest> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(CreateWirelessDeviceRequest.getter(CreateWirelessDeviceRequest::typeAsString)).setter(CreateWirelessDeviceRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateWirelessDeviceRequest.getter(CreateWirelessDeviceRequest::name)).setter(CreateWirelessDeviceRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateWirelessDeviceRequest.getter(CreateWirelessDeviceRequest::description)).setter(CreateWirelessDeviceRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> DESTINATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationName").getter(CreateWirelessDeviceRequest.getter(CreateWirelessDeviceRequest::destinationName)).setter(CreateWirelessDeviceRequest.setter(Builder::destinationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationName").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(CreateWirelessDeviceRequest.getter(CreateWirelessDeviceRequest::clientRequestToken)).setter(CreateWirelessDeviceRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<LoRaWANDevice> LO_RA_WAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LoRaWAN").getter(CreateWirelessDeviceRequest.getter(CreateWirelessDeviceRequest::loRaWAN)).setter(CreateWirelessDeviceRequest.setter(Builder::loRaWAN)).constructor(LoRaWANDevice::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoRaWAN").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateWirelessDeviceRequest.getter(CreateWirelessDeviceRequest::tags)).setter(CreateWirelessDeviceRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> POSITIONING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Positioning").getter(CreateWirelessDeviceRequest.getter(CreateWirelessDeviceRequest::positioningAsString)).setter(CreateWirelessDeviceRequest.setter(Builder::positioning)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Positioning").build()}).build();
    private static final SdkField<SidewalkCreateWirelessDevice> SIDEWALK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Sidewalk").getter(CreateWirelessDeviceRequest.getter(CreateWirelessDeviceRequest::sidewalk)).setter(CreateWirelessDeviceRequest.setter(Builder::sidewalk)).constructor(SidewalkCreateWirelessDevice::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sidewalk").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, NAME_FIELD, DESCRIPTION_FIELD, DESTINATION_NAME_FIELD, CLIENT_REQUEST_TOKEN_FIELD, LO_RA_WAN_FIELD, TAGS_FIELD, POSITIONING_FIELD, SIDEWALK_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Type", TYPE_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("DestinationName", DESTINATION_NAME_FIELD);
            this.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
            this.put("LoRaWAN", LO_RA_WAN_FIELD);
            this.put("Tags", TAGS_FIELD);
            this.put("Positioning", POSITIONING_FIELD);
            this.put("Sidewalk", SIDEWALK_FIELD);
        }
    });
    private final String type;
    private final String name;
    private final String description;
    private final String destinationName;
    private final String clientRequestToken;
    private final LoRaWANDevice loRaWAN;
    private final List<Tag> tags;
    private final String positioning;
    private final SidewalkCreateWirelessDevice sidewalk;

    private CreateWirelessDeviceRequest(BuilderImpl builder) {
        super(builder);
        this.type = builder.type;
        this.name = builder.name;
        this.description = builder.description;
        this.destinationName = builder.destinationName;
        this.clientRequestToken = builder.clientRequestToken;
        this.loRaWAN = builder.loRaWAN;
        this.tags = builder.tags;
        this.positioning = builder.positioning;
        this.sidewalk = builder.sidewalk;
    }

    public final WirelessDeviceType type() {
        return WirelessDeviceType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String destinationName() {
        return this.destinationName;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final LoRaWANDevice loRaWAN() {
        return this.loRaWAN;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final PositioningConfigStatus positioning() {
        return PositioningConfigStatus.fromValue(this.positioning);
    }

    public final String positioningAsString() {
        return this.positioning;
    }

    public final SidewalkCreateWirelessDevice sidewalk() {
        return this.sidewalk;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.loRaWAN());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.positioningAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sidewalk());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWirelessDeviceRequest)) {
            return false;
        }
        CreateWirelessDeviceRequest other = (CreateWirelessDeviceRequest)((Object)obj);
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.destinationName(), other.destinationName()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.loRaWAN(), other.loRaWAN()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.positioningAsString(), other.positioningAsString()) && Objects.equals(this.sidewalk(), other.sidewalk());
    }

    public final String toString() {
        return ToString.builder((String)"CreateWirelessDeviceRequest").add("Type", (Object)this.typeAsString()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("DestinationName", (Object)this.destinationName()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("LoRaWAN", (Object)this.loRaWAN()).add("Tags", this.hasTags() ? this.tags() : null).add("Positioning", (Object)this.positioningAsString()).add("Sidewalk", (Object)this.sidewalk()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DestinationName": {
                return Optional.ofNullable(clazz.cast(this.destinationName()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "LoRaWAN": {
                return Optional.ofNullable(clazz.cast(this.loRaWAN()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Positioning": {
                return Optional.ofNullable(clazz.cast(this.positioningAsString()));
            }
            case "Sidewalk": {
                return Optional.ofNullable(clazz.cast(this.sidewalk()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateWirelessDeviceRequest, T> g) {
        return obj -> g.apply((CreateWirelessDeviceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessRequest.BuilderImpl
    implements Builder {
        private String type;
        private String name;
        private String description;
        private String destinationName;
        private String clientRequestToken;
        private LoRaWANDevice loRaWAN;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String positioning;
        private SidewalkCreateWirelessDevice sidewalk;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWirelessDeviceRequest model) {
            super(model);
            this.type(model.type);
            this.name(model.name);
            this.description(model.description);
            this.destinationName(model.destinationName);
            this.clientRequestToken(model.clientRequestToken);
            this.loRaWAN(model.loRaWAN);
            this.tags(model.tags);
            this.positioning(model.positioning);
            this.sidewalk(model.sidewalk);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(WirelessDeviceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDestinationName() {
            return this.destinationName;
        }

        public final void setDestinationName(String destinationName) {
            this.destinationName = destinationName;
        }

        @Override
        public final Builder destinationName(String destinationName) {
            this.destinationName = destinationName;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final LoRaWANDevice.Builder getLoRaWAN() {
            return this.loRaWAN != null ? this.loRaWAN.toBuilder() : null;
        }

        public final void setLoRaWAN(LoRaWANDevice.BuilderImpl loRaWAN) {
            this.loRaWAN = loRaWAN != null ? loRaWAN.build() : null;
        }

        @Override
        public final Builder loRaWAN(LoRaWANDevice loRaWAN) {
            this.loRaWAN = loRaWAN;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPositioning() {
            return this.positioning;
        }

        public final void setPositioning(String positioning) {
            this.positioning = positioning;
        }

        @Override
        public final Builder positioning(String positioning) {
            this.positioning = positioning;
            return this;
        }

        @Override
        public final Builder positioning(PositioningConfigStatus positioning) {
            this.positioning(positioning == null ? null : positioning.toString());
            return this;
        }

        public final SidewalkCreateWirelessDevice.Builder getSidewalk() {
            return this.sidewalk != null ? this.sidewalk.toBuilder() : null;
        }

        public final void setSidewalk(SidewalkCreateWirelessDevice.BuilderImpl sidewalk) {
            this.sidewalk = sidewalk != null ? sidewalk.build() : null;
        }

        @Override
        public final Builder sidewalk(SidewalkCreateWirelessDevice sidewalk) {
            this.sidewalk = sidewalk;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWirelessDeviceRequest build() {
            return new CreateWirelessDeviceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotWirelessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateWirelessDeviceRequest> {
        public Builder type(String var1);

        public Builder type(WirelessDeviceType var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder destinationName(String var1);

        public Builder clientRequestToken(String var1);

        public Builder loRaWAN(LoRaWANDevice var1);

        default public Builder loRaWAN(Consumer<LoRaWANDevice.Builder> loRaWAN) {
            return this.loRaWAN((LoRaWANDevice)((LoRaWANDevice.Builder)LoRaWANDevice.builder().applyMutation(loRaWAN)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder positioning(String var1);

        public Builder positioning(PositioningConfigStatus var1);

        public Builder sidewalk(SidewalkCreateWirelessDevice var1);

        default public Builder sidewalk(Consumer<SidewalkCreateWirelessDevice.Builder> sidewalk) {
            return this.sidewalk((SidewalkCreateWirelessDevice)((SidewalkCreateWirelessDevice.Builder)SidewalkCreateWirelessDevice.builder().applyMutation(sidewalk)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

